/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.Base64;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.TimestampFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleTypeStaxUnmarshallers {
    private static Log log = LogFactory.getLog(SimpleTypeStaxUnmarshallers.class);

    public static class ShortJsonUnmarshaller
    implements Unmarshaller<Short, StaxUnmarshallerContext> {
        private static final ShortJsonUnmarshaller instance = new ShortJsonUnmarshaller();

        @Override
        public Short unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Short.valueOf(string);
        }

        public static ShortJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class CharacterJsonUnmarshaller
    implements Unmarshaller<Character, StaxUnmarshallerContext> {
        private static final CharacterJsonUnmarshaller instance = new CharacterJsonUnmarshaller();

        @Override
        public Character unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            if (string == null) {
                return null;
            }
            if ((string = string.trim()).isEmpty() || string.length() > 1) {
                throw new SdkClientException("'" + string + "' cannot be converted to Character");
            }
            return Character.valueOf(string.charAt(0));
        }

        public static CharacterJsonUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class ByteBufferStaxUnmarshaller
    implements Unmarshaller<ByteBuffer, StaxUnmarshallerContext> {
        private static final ByteBufferStaxUnmarshaller instance = new ByteBufferStaxUnmarshaller();

        @Override
        public ByteBuffer unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            byte[] byArray = Base64.decode(string);
            return ByteBuffer.wrap(byArray);
        }

        public static ByteBufferStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class DateStaxUnmarshaller
    implements Unmarshaller<Date, StaxUnmarshallerContext> {
        private static final DateStaxUnmarshaller instance = new DateStaxUnmarshaller();

        @Override
        public Date unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            if (string == null) {
                return null;
            }
            try {
                return DateUtils.parseISO8601Date(string);
            }
            catch (Exception exception) {
                log.warn("Unable to parse date '" + string + "':  " + exception.getMessage(), exception);
                return null;
            }
        }

        public static DateStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class DateStaxUnmarshallerFactory
    implements Unmarshaller<Date, StaxUnmarshallerContext> {
        private final String dateFormatType;

        private DateStaxUnmarshallerFactory(String string) {
            this.dateFormatType = string;
        }

        @Override
        public Date unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            if (string == null) {
                return null;
            }
            try {
                if (TimestampFormat.RFC_822.getFormat().equals(this.dateFormatType)) {
                    return DateUtils.parseRFC822Date(string);
                }
                if (TimestampFormat.UNIX_TIMESTAMP.getFormat().equals(this.dateFormatType)) {
                    return DateUtils.parseServiceSpecificDate(string);
                }
                return DateUtils.parseISO8601Date(string);
            }
            catch (Exception exception) {
                log.warn("Unable to parse date '" + string + "':  " + exception.getMessage(), exception);
                return null;
            }
        }

        public static DateStaxUnmarshallerFactory getInstance(String string) {
            return new DateStaxUnmarshallerFactory(string);
        }
    }

    public static class ByteStaxUnmarshaller
    implements Unmarshaller<Byte, StaxUnmarshallerContext> {
        private static final ByteStaxUnmarshaller instance = new ByteStaxUnmarshaller();

        @Override
        public Byte unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Byte.valueOf(string);
        }

        public static ByteStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class LongStaxUnmarshaller
    implements Unmarshaller<Long, StaxUnmarshallerContext> {
        private static final LongStaxUnmarshaller instance = new LongStaxUnmarshaller();

        @Override
        public Long unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Long.valueOf(Long.parseLong(string));
        }

        public static LongStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class FloatStaxUnmarshaller
    implements Unmarshaller<Float, StaxUnmarshallerContext> {
        private static final FloatStaxUnmarshaller instance = new FloatStaxUnmarshaller();

        @Override
        public Float unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Float.valueOf(string);
        }

        public static FloatStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class BooleanStaxUnmarshaller
    implements Unmarshaller<Boolean, StaxUnmarshallerContext> {
        private static final BooleanStaxUnmarshaller instance = new BooleanStaxUnmarshaller();

        @Override
        public Boolean unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Boolean.valueOf(Boolean.parseBoolean(string));
        }

        public static BooleanStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class IntegerStaxUnmarshaller
    implements Unmarshaller<Integer, StaxUnmarshallerContext> {
        private static final IntegerStaxUnmarshaller instance = new IntegerStaxUnmarshaller();

        @Override
        public Integer unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Integer.valueOf(Integer.parseInt(string));
        }

        public static IntegerStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class DoubleStaxUnmarshaller
    implements Unmarshaller<Double, StaxUnmarshallerContext> {
        private static final DoubleStaxUnmarshaller instance = new DoubleStaxUnmarshaller();

        @Override
        public Double unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : Double.valueOf(Double.parseDouble(string));
        }

        public static DoubleStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class BigIntegerStaxUnmarshaller
    implements Unmarshaller<BigInteger, StaxUnmarshallerContext> {
        private static final BigIntegerStaxUnmarshaller instance = new BigIntegerStaxUnmarshaller();

        @Override
        public BigInteger unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : new BigInteger(string);
        }

        public static BigIntegerStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class BigDecimalStaxUnmarshaller
    implements Unmarshaller<BigDecimal, StaxUnmarshallerContext> {
        private static final BigDecimalStaxUnmarshaller instance = new BigDecimalStaxUnmarshaller();

        @Override
        public BigDecimal unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            String string = staxUnmarshallerContext.readText();
            return string == null ? null : new BigDecimal(string);
        }

        public static BigDecimalStaxUnmarshaller getInstance() {
            return instance;
        }
    }

    public static class StringStaxUnmarshaller
    implements Unmarshaller<String, StaxUnmarshallerContext> {
        private static final StringStaxUnmarshaller instance = new StringStaxUnmarshaller();

        @Override
        public String unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
            return staxUnmarshallerContext.readText();
        }

        public static StringStaxUnmarshaller getInstance() {
            return instance;
        }
    }
}

