/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal.future;

import com.amazonaws.util.ValidationUtils;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DelegatingFuture<T>
implements Future<T> {
    private final Object mutationLock = new Object();
    private volatile Future<T> delegate;
    private volatile CancelState cancelState = CancelState.NOT_CANCELLED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegateIfUnset(Future<T> future) {
        if (this.hasDelegate()) {
            return;
        }
        Object object = this.mutationLock;
        synchronized (object) {
            if (this.hasDelegate()) {
                return;
            }
            this.setDelegate(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegate(Future<T> future) {
        Object object = this.mutationLock;
        synchronized (object) {
            ValidationUtils.assertAllAreNull("Delegate may only be set once.", this.delegate);
            switch (this.cancelState) {
                case NOT_CANCELLED: {
                    break;
                }
                case CANCELLED: {
                    future.cancel(false);
                    break;
                }
                case CANCELLED_MAY_INTERRUPT: {
                    future.cancel(true);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.delegate = future;
            this.mutationLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        Future<T> future = this.delegate;
        if (future != null) {
            return future.cancel(bl);
        }
        Object object = this.mutationLock;
        synchronized (object) {
            future = this.delegate;
            if (future != null) {
                return future.cancel(bl);
            }
            if (this.cancelState != CancelState.NOT_CANCELLED) {
                return false;
            }
            this.cancelState = bl ? CancelState.CANCELLED_MAY_INTERRUPT : CancelState.CANCELLED;
            this.mutationLock.notifyAll();
            return true;
        }
    }

    @Override
    public boolean isCancelled() {
        Future<T> future = this.delegate;
        if (future != null) {
            return future.isCancelled();
        }
        return this.cancelState != CancelState.NOT_CANCELLED;
    }

    @Override
    public boolean isDone() {
        Future<T> future = this.delegate;
        if (future != null) {
            return future.isDone();
        }
        return this.cancelState != CancelState.NOT_CANCELLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        Future<T> future = this.delegate;
        if (future != null) {
            return future.get();
        }
        Object object = this.mutationLock;
        synchronized (object) {
            future = this.delegate;
            while (future == null) {
                if (this.cancelState != CancelState.NOT_CANCELLED) {
                    throw new CancellationException("Future being waited on has been cancelled.");
                }
                this.mutationLock.wait();
                future = this.delegate;
            }
        }
        return future.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Future<T> future = this.delegate;
        if (future != null) {
            return future.get(l, timeUnit);
        }
        long l2 = timeUnit.toNanos(l);
        long l3 = System.nanoTime() + l2;
        Object object = this.mutationLock;
        synchronized (object) {
            future = this.delegate;
            while (future == null) {
                if (this.cancelState != CancelState.NOT_CANCELLED) {
                    throw new CancellationException("Future being waited on has been cancelled.");
                }
                long l4 = this.nanosUntil(l3);
                long l5 = TimeUnit.NANOSECONDS.toMillis(l4);
                int n = DelegatingFuture.toIntExact(l4 % 1000000L);
                this.mutationLock.wait(l5, n);
                future = this.delegate;
            }
        }
        return future.get(this.nanosUntil(l3), TimeUnit.NANOSECONDS);
    }

    private boolean hasDelegate() {
        return this.delegate != null;
    }

    private long nanosUntil(long l) throws TimeoutException {
        long l2 = l - System.nanoTime();
        if (l2 <= 0L) {
            throw new TimeoutException("Timed out waiting for future.");
        }
        return l2;
    }

    private static int toIntExact(long l) {
        if ((long)((int)l) != l) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)l;
    }

    private static enum CancelState {
        NOT_CANCELLED,
        CANCELLED_MAY_INTERRUPT,
        CANCELLED;

    }
}

