/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.event.DeliveryMode;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.transfer.PersistableTransfer;
import com.amazonaws.services.s3.transfer.internal.S3ProgressListener;
import java.util.concurrent.Future;
import org.apache.commons.logging.LogFactory;

public class S3ProgressPublisher
extends SDKProgressPublisher {
    public static Future<?> publishTransferPersistable(ProgressListener progressListener, PersistableTransfer persistableTransfer) {
        if (persistableTransfer == null || !(progressListener instanceof S3ProgressListener)) {
            return null;
        }
        S3ProgressListener s3ProgressListener = (S3ProgressListener)progressListener;
        return S3ProgressPublisher.deliverEvent(s3ProgressListener, persistableTransfer);
    }

    private static Future<?> deliverEvent(final S3ProgressListener s3ProgressListener, final PersistableTransfer persistableTransfer) {
        DeliveryMode deliveryMode;
        if (s3ProgressListener instanceof DeliveryMode && (deliveryMode = (DeliveryMode)((Object)s3ProgressListener)).isSyncCallSafe()) {
            return S3ProgressPublisher.quietlyCallListener(s3ProgressListener, persistableTransfer);
        }
        return S3ProgressPublisher.setLatestFutureTask(S3ProgressPublisher.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                s3ProgressListener.onPersistableTransfer(persistableTransfer);
            }
        }));
    }

    private static Future<?> quietlyCallListener(S3ProgressListener s3ProgressListener, PersistableTransfer persistableTransfer) {
        try {
            s3ProgressListener.onPersistableTransfer(persistableTransfer);
        }
        catch (Throwable throwable) {
            LogFactory.getLog(S3ProgressPublisher.class).debug("Failure from the event listener", throwable);
        }
        return null;
    }
}

