/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.EncryptedInitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.internal.CopyImpl;
import com.amazonaws.services.s3.transfer.internal.CopyPartCallable;
import com.amazonaws.services.s3.transfer.internal.CopyPartRequestFactory;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import com.amazonaws.services.s3.transfer.model.CopyResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CopyCallable
implements Callable<CopyResult> {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final CopyObjectRequest copyObjectRequest;
    private String multipartUploadId;
    private final ObjectMetadata metadata;
    private final CopyImpl copy;
    private static final Log log = LogFactory.getLog(CopyCallable.class);
    private final TransferManagerConfiguration configuration;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private final ProgressListenerChain listenerChain;

    public CopyCallable(TransferManager transferManager, ExecutorService executorService, CopyImpl copyImpl, CopyObjectRequest copyObjectRequest, ObjectMetadata objectMetadata, ProgressListenerChain progressListenerChain) {
        this.s3 = transferManager.getAmazonS3Client();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = executorService;
        this.copyObjectRequest = copyObjectRequest;
        this.metadata = objectMetadata;
        this.listenerChain = progressListenerChain;
        this.copy = copyImpl;
    }

    List<Future<PartETag>> getFutures() {
        return this.futures;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public boolean isMultipartCopy() {
        return this.metadata.getContentLength() > this.configuration.getMultipartCopyThreshold();
    }

    @Override
    public CopyResult call() throws Exception {
        this.copy.setState(Transfer.TransferState.InProgress);
        if (this.isMultipartCopy()) {
            SDKProgressPublisher.publishProgress(this.listenerChain, ProgressEventType.TRANSFER_STARTED_EVENT);
            this.copyInParts();
            return null;
        }
        return this.copyInOneChunk();
    }

    private CopyResult copyInOneChunk() {
        CopyObjectResult copyObjectResult = this.s3.copyObject(this.copyObjectRequest);
        CopyResult copyResult = new CopyResult();
        copyResult.setSourceBucketName(this.copyObjectRequest.getSourceBucketName());
        copyResult.setSourceKey(this.copyObjectRequest.getSourceKey());
        copyResult.setDestinationBucketName(this.copyObjectRequest.getDestinationBucketName());
        copyResult.setDestinationKey(this.copyObjectRequest.getDestinationKey());
        copyResult.setETag(copyObjectResult.getETag());
        copyResult.setVersionId(copyObjectResult.getVersionId());
        return copyResult;
    }

    private void copyInParts() throws Exception {
        this.multipartUploadId = this.initiateMultipartUpload(this.copyObjectRequest);
        long l = this.getOptimalPartSize(this.metadata.getContentLength());
        try {
            CopyPartRequestFactory copyPartRequestFactory = new CopyPartRequestFactory(this.copyObjectRequest, this.multipartUploadId, l, this.metadata.getContentLength());
            this.copyPartsInParallel(copyPartRequestFactory);
        }
        catch (Exception exception) {
            SDKProgressPublisher.publishProgress(this.listenerChain, ProgressEventType.TRANSFER_FAILED_EVENT);
            this.abortMultipartCopy();
            throw new RuntimeException("Unable to perform multipart copy", exception);
        }
    }

    private long getOptimalPartSize(long l) {
        long l2 = TransferManagerUtils.calculateOptimalPartSizeForCopy(this.copyObjectRequest, this.configuration, l);
        log.debug("Calculated optimal part size: " + l2);
        return l2;
    }

    private void copyPartsInParallel(CopyPartRequestFactory copyPartRequestFactory) {
        while (copyPartRequestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            CopyPartRequest copyPartRequest = copyPartRequestFactory.getNextCopyPartRequest();
            this.futures.add(this.threadPool.submit(new CopyPartCallable(this.s3, copyPartRequest)));
        }
    }

    private String initiateMultipartUpload(CopyObjectRequest copyObjectRequest) {
        EncryptedInitiateMultipartUploadRequest encryptedInitiateMultipartUploadRequest = (EncryptedInitiateMultipartUploadRequest)((AmazonWebServiceRequest)new EncryptedInitiateMultipartUploadRequest(copyObjectRequest.getDestinationBucketName(), copyObjectRequest.getDestinationKey()).withCannedACL(copyObjectRequest.getCannedAccessControlList()).withRequesterPays(copyObjectRequest.isRequesterPays()).withAccessControlList(copyObjectRequest.getAccessControlList()).withStorageClass(copyObjectRequest.getStorageClass()).withSSECustomerKey(copyObjectRequest.getDestinationSSECustomerKey()).withSSEAwsKeyManagementParams(copyObjectRequest.getSSEAwsKeyManagementParams()).withGeneralProgressListener(copyObjectRequest.getGeneralProgressListener())).withRequestMetricCollector(copyObjectRequest.getRequestMetricCollector());
        encryptedInitiateMultipartUploadRequest.setCreateEncryptionMaterial(false);
        ObjectMetadata objectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (objectMetadata.getContentType() == null) {
            objectMetadata.setContentType(this.metadata.getContentType());
        }
        encryptedInitiateMultipartUploadRequest.setObjectMetadata(objectMetadata);
        this.populateMetadataWithEncryptionParams(this.metadata, objectMetadata);
        encryptedInitiateMultipartUploadRequest.setTagging(copyObjectRequest.getNewObjectTagging());
        encryptedInitiateMultipartUploadRequest.withObjectLockMode(copyObjectRequest.getObjectLockMode()).withObjectLockLegalHoldStatus(copyObjectRequest.getObjectLockLegalHoldStatus()).withObjectLockRetainUntilDate(copyObjectRequest.getObjectLockRetainUntilDate());
        encryptedInitiateMultipartUploadRequest.withRequestCredentialsProvider(copyObjectRequest.getRequestCredentialsProvider());
        String string = this.s3.initiateMultipartUpload(encryptedInitiateMultipartUploadRequest).getUploadId();
        log.debug("Initiated new multipart upload: " + string);
        return string;
    }

    private void populateMetadataWithEncryptionParams(ObjectMetadata objectMetadata, ObjectMetadata objectMetadata2) {
        Map<String, String> map = objectMetadata.getUserMetadata();
        Map<String, String> map2 = objectMetadata2.getUserMetadata();
        String[] stringArray = new String[]{"x-amz-cek-alg", "x-amz-iv", "x-amz-key", "x-amz-key-v2", "x-amz-wrap-alg", "x-amz-tag-len", "x-amz-matdesc", "x-amz-unencrypted-content-length", "x-amz-unencrypted-content-md5"};
        if (map != null) {
            if (map2 == null) {
                map2 = new HashMap<String, String>();
                objectMetadata2.setUserMetadata(map2);
            }
            for (String string : stringArray) {
                String string2 = map.get(string);
                if (string2 == null) continue;
                map2.put(string, string2);
            }
        }
    }

    private void abortMultipartCopy() {
        try {
            AbortMultipartUploadRequest abortMultipartUploadRequest = (AbortMultipartUploadRequest)new AbortMultipartUploadRequest(this.copyObjectRequest.getDestinationBucketName(), this.copyObjectRequest.getDestinationKey(), this.multipartUploadId).withRequesterPays(this.copyObjectRequest.isRequesterPays()).withRequestCredentialsProvider(this.copyObjectRequest.getRequestCredentialsProvider());
            this.s3.abortMultipartUpload(abortMultipartUploadRequest);
        }
        catch (Exception exception) {
            log.info("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + exception.getMessage(), exception);
        }
    }
}

