/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.SdkClientException;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListenerChain;
import com.amazonaws.event.SDKProgressPublisher;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.internal.UploadMonitor;
import com.amazonaws.services.s3.transfer.model.UploadResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CompleteMultipartUpload
implements Callable<UploadResult> {
    private final String uploadId;
    private final AmazonS3 s3;
    private final PutObjectRequest origReq;
    private final Future<List<PartETag>> partFutures;
    private final List<PartETag> eTagsBeforeResume;
    private final UploadMonitor monitor;
    private final ProgressListenerChain listener;

    public CompleteMultipartUpload(String string, AmazonS3 amazonS3, PutObjectRequest putObjectRequest, Future<List<PartETag>> future, List<PartETag> list, ProgressListenerChain progressListenerChain, UploadMonitor uploadMonitor) {
        this.uploadId = string;
        this.s3 = amazonS3;
        this.origReq = putObjectRequest;
        this.partFutures = future;
        this.eTagsBeforeResume = list;
        this.listener = progressListenerChain;
        this.monitor = uploadMonitor;
    }

    @Override
    public UploadResult call() throws Exception {
        CompleteMultipartUploadResult completeMultipartUploadResult;
        Object object;
        try {
            object = (CompleteMultipartUploadRequest)((AmazonWebServiceRequest)((AmazonWebServiceRequest)new CompleteMultipartUploadRequest(this.origReq.getBucketName(), this.origReq.getKey(), this.uploadId, this.collectPartETags()).withRequesterPays(this.origReq.isRequesterPays()).withGeneralProgressListener(this.origReq.getGeneralProgressListener())).withRequestMetricCollector(this.origReq.getRequestMetricCollector())).withRequestCredentialsProvider(this.origReq.getRequestCredentialsProvider());
            completeMultipartUploadResult = this.s3.completeMultipartUpload((CompleteMultipartUploadRequest)object);
        }
        catch (Exception exception) {
            this.monitor.setTransferStateToFailed();
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            this.partFutures.cancel(false);
            throw exception;
        }
        object = new UploadResult();
        ((UploadResult)object).setBucketName(this.origReq.getBucketName());
        ((UploadResult)object).setKey(this.origReq.getKey());
        ((UploadResult)object).setETag(completeMultipartUploadResult.getETag());
        ((UploadResult)object).setVersionId(completeMultipartUploadResult.getVersionId());
        this.monitor.setTransferStateToCompleted();
        return object;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>(this.eTagsBeforeResume);
        try {
            arrayList.addAll((Collection<PartETag>)this.partFutures.get());
        }
        catch (Exception exception) {
            throw new SdkClientException("Unable to complete multi-part upload. Individual part upload failed: " + exception.getCause().getMessage(), exception.getCause());
        }
        return arrayList;
    }
}

