/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.internal.SdkFunction;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import com.amazonaws.services.s3.transfer.TransferManagerParams;
import com.amazonaws.services.s3.transfer.internal.TransferManagerUtils;
import java.util.concurrent.ExecutorService;

@NotThreadSafe
public final class TransferManagerBuilder {
    private static final SdkFunction<TransferManagerParams, TransferManager> DEFAULT_TRANSFER_MANAGER_FACTORY = new SdkFunction<TransferManagerParams, TransferManager>(){

        @Override
        public TransferManager apply(TransferManagerParams transferManagerParams) {
            return new TransferManager(transferManagerParams);
        }
    };
    private final SdkFunction<TransferManagerParams, TransferManager> transferManagerFactory;
    private AmazonS3 s3Client;
    private ExecutorFactory executorFactory;
    private Boolean shutDownThreadPools;
    private Long minimumUploadPartSize;
    private Long multipartUploadThreshold;
    private Long multipartCopyThreshold;
    private Long multipartCopyPartSize;
    private Boolean disableParallelDownloads;
    private Boolean alwaysCalculateMultipartMd5;

    public static TransferManagerBuilder standard() {
        return new TransferManagerBuilder();
    }

    public static TransferManager defaultTransferManager() {
        return TransferManagerBuilder.standard().build();
    }

    private TransferManagerBuilder() {
        this(DEFAULT_TRANSFER_MANAGER_FACTORY);
    }

    @SdkTestInternalApi
    TransferManagerBuilder(SdkFunction<TransferManagerParams, TransferManager> sdkFunction) {
        this.transferManagerFactory = sdkFunction;
    }

    public final AmazonS3 getS3Client() {
        return this.s3Client;
    }

    public final void setS3Client(AmazonS3 amazonS3) {
        this.s3Client = amazonS3;
    }

    public final TransferManagerBuilder withS3Client(AmazonS3 amazonS3) {
        this.setS3Client(amazonS3);
        return this;
    }

    private AmazonS3 resolveS3Client() {
        return this.s3Client == null ? AmazonS3ClientBuilder.defaultClient() : this.s3Client;
    }

    public final ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public final void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public final TransferManagerBuilder withExecutorFactory(ExecutorFactory executorFactory) {
        this.setExecutorFactory(executorFactory);
        return this;
    }

    private ExecutorService resolveExecutorService() {
        return this.executorFactory == null ? TransferManagerUtils.createDefaultExecutorService() : this.executorFactory.newExecutor();
    }

    public final Boolean isShutDownThreadPools() {
        return this.shutDownThreadPools;
    }

    public final void setShutDownThreadPools(Boolean bl) {
        this.shutDownThreadPools = bl;
    }

    public final TransferManagerBuilder withShutDownThreadPools(Boolean bl) {
        this.setShutDownThreadPools(bl);
        return this;
    }

    private Boolean resolveShutDownThreadPools() {
        return this.shutDownThreadPools == null ? Boolean.TRUE : this.shutDownThreadPools;
    }

    public final Long getMinimumUploadPartSize() {
        return this.minimumUploadPartSize;
    }

    public final void setMinimumUploadPartSize(Long l) {
        this.minimumUploadPartSize = l;
    }

    public final TransferManagerBuilder withMinimumUploadPartSize(Long l) {
        this.setMinimumUploadPartSize(l);
        return this;
    }

    public final Long getMultipartUploadThreshold() {
        return this.multipartUploadThreshold;
    }

    public final void setMultipartUploadThreshold(Long l) {
        this.multipartUploadThreshold = l;
    }

    public final TransferManagerBuilder withMultipartUploadThreshold(Long l) {
        this.setMultipartUploadThreshold(l);
        return this;
    }

    public final Long getMultipartCopyThreshold() {
        return this.multipartCopyThreshold;
    }

    public final void setMultipartCopyThreshold(Long l) {
        this.multipartCopyThreshold = l;
    }

    public final TransferManagerBuilder withMultipartCopyThreshold(Long l) {
        this.setMultipartCopyThreshold(l);
        return this;
    }

    public final Long getMultipartCopyPartSize() {
        return this.multipartCopyPartSize;
    }

    public final void setMultipartCopyPartSize(Long l) {
        this.multipartCopyPartSize = l;
    }

    public final TransferManagerBuilder withMultipartCopyPartSize(Long l) {
        this.setMultipartCopyPartSize(l);
        return this;
    }

    public Boolean isDisableParallelDownloads() {
        return this.disableParallelDownloads;
    }

    public void setDisableParallelDownloads(Boolean bl) {
        this.disableParallelDownloads = bl;
    }

    public TransferManagerBuilder withDisableParallelDownloads(Boolean bl) {
        this.setDisableParallelDownloads(bl);
        return this;
    }

    public TransferManagerBuilder disableParallelDownloads() {
        return this.withDisableParallelDownloads(Boolean.TRUE);
    }

    public boolean getAlwaysCalculateMultipartMd5() {
        return this.alwaysCalculateMultipartMd5;
    }

    public void setAlwaysCalculateMultipartMd5(boolean bl) {
        this.alwaysCalculateMultipartMd5 = bl;
    }

    public TransferManagerBuilder withAlwaysCalculateMultipartMd5(boolean bl) {
        this.setAlwaysCalculateMultipartMd5(bl);
        return this;
    }

    private TransferManagerConfiguration resolveConfiguration() {
        TransferManagerConfiguration transferManagerConfiguration = new TransferManagerConfiguration();
        if (this.minimumUploadPartSize != null) {
            transferManagerConfiguration.setMinimumUploadPartSize(this.minimumUploadPartSize);
        }
        if (this.multipartCopyPartSize != null) {
            transferManagerConfiguration.setMultipartCopyPartSize(this.multipartCopyPartSize);
        }
        if (this.multipartCopyThreshold != null) {
            transferManagerConfiguration.setMultipartCopyThreshold(this.multipartCopyThreshold);
        }
        if (this.multipartUploadThreshold != null) {
            transferManagerConfiguration.setMultipartUploadThreshold(this.multipartUploadThreshold);
        }
        if (this.disableParallelDownloads != null) {
            transferManagerConfiguration.setDisableParallelDownloads(this.disableParallelDownloads);
        }
        if (this.alwaysCalculateMultipartMd5 != null) {
            transferManagerConfiguration.setAlwaysCalculateMultipartMd5(this.alwaysCalculateMultipartMd5);
        }
        return transferManagerConfiguration;
    }

    TransferManagerParams getParams() {
        return new TransferManagerParams().withS3Client(this.resolveS3Client()).withExecutorService(this.resolveExecutorService()).withShutDownThreadPools(this.resolveShutDownThreadPools()).withTransferManagerConfiguration(this.resolveConfiguration());
    }

    public final TransferManager build() {
        return this.transferManagerFactory.apply(this.getParams());
    }
}

