/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.NotificationConfiguration;
import com.amazonaws.services.s3.model.transform.FilterStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.AbstractMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

abstract class NotificationConfigurationStaxUnmarshaller<T extends NotificationConfiguration>
implements Unmarshaller<Map.Entry<String, NotificationConfiguration>, StaxUnmarshallerContext> {
    NotificationConfigurationStaxUnmarshaller() {
    }

    @Override
    public Map.Entry<String, NotificationConfiguration> unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            ++n2;
        }
        T t2 = this.createConfiguration();
        String string = null;
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return new AbstractMap.SimpleEntry<Object, T>(string, t2);
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (this.handleXmlEvent(t2, staxUnmarshallerContext, n2)) continue;
                if (staxUnmarshallerContext.testExpression("Id", n2)) {
                    string = SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext);
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("Event", n2)) {
                    ((NotificationConfiguration)t2).addEvent(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (!staxUnmarshallerContext.testExpression("Filter", n2)) continue;
                ((NotificationConfiguration)t2).setFilter(FilterStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return new AbstractMap.SimpleEntry<Object, T>(string, t2);
    }

    protected abstract T createConfiguration();

    protected abstract boolean handleXmlEvent(T var1, StaxUnmarshallerContext var2, int var3) throws Exception;
}

