/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.EventBridgeConfiguration;
import com.amazonaws.services.s3.model.transform.EventBridgeConfigurationStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.LambdaConfigurationStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.QueueConfigurationStaxUnmarshaller;
import com.amazonaws.services.s3.model.transform.TopicConfigurationStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XmlUtils;
import java.io.InputStream;
import javax.xml.stream.events.XMLEvent;

public class BucketNotificationConfigurationStaxUnmarshaller
implements Unmarshaller<BucketNotificationConfiguration, InputStream> {
    private static final BucketNotificationConfigurationStaxUnmarshaller instance = new BucketNotificationConfigurationStaxUnmarshaller();

    public static BucketNotificationConfigurationStaxUnmarshaller getInstance() {
        return instance;
    }

    private BucketNotificationConfigurationStaxUnmarshaller() {
    }

    @Override
    public BucketNotificationConfiguration unmarshall(InputStream inputStream2) throws Exception {
        StaxUnmarshallerContext staxUnmarshallerContext = new StaxUnmarshallerContext(XmlUtils.getXmlInputFactory().createXMLEventReader(inputStream2));
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            ++n2;
        }
        BucketNotificationConfiguration bucketNotificationConfiguration = new BucketNotificationConfiguration();
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return bucketNotificationConfiguration;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                Object object;
                if (staxUnmarshallerContext.testExpression("TopicConfiguration", n2)) {
                    object = TopicConfigurationStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext);
                    bucketNotificationConfiguration.addConfiguration(object.getKey(), object.getValue());
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("QueueConfiguration", n2)) {
                    object = QueueConfigurationStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext);
                    bucketNotificationConfiguration.addConfiguration(object.getKey(), object.getValue());
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("CloudFunctionConfiguration", n2)) {
                    object = LambdaConfigurationStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext);
                    bucketNotificationConfiguration.addConfiguration(object.getKey(), object.getValue());
                    continue;
                }
                if (!staxUnmarshallerContext.testExpression("EventBridgeConfiguration", n2)) continue;
                object = EventBridgeConfigurationStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext);
                bucketNotificationConfiguration.setEventBridgeConfiguration((EventBridgeConfiguration)object);
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return bucketNotificationConfiguration;
    }
}

