/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.ExpectedBucketOwnerRequest;
import com.amazonaws.services.s3.model.GlacierJobParameters;
import com.amazonaws.services.s3.model.OutputLocation;
import com.amazonaws.services.s3.model.RestoreRequestType;
import com.amazonaws.services.s3.model.SelectParameters;
import com.amazonaws.services.s3.model.Tier;
import java.io.Serializable;

public class RestoreObjectRequest
extends AmazonWebServiceRequest
implements ExpectedBucketOwnerRequest,
Serializable,
Cloneable {
    private int expirationInDays;
    private String bucketName;
    private String key;
    private String versionId;
    private boolean isRequesterPays;
    private GlacierJobParameters glacierJobParameters;
    private String type;
    private String tier;
    private String description;
    private SelectParameters selectParameters;
    private OutputLocation outputLocation;
    private String expectedBucketOwner;

    public RestoreObjectRequest(String string, String string2) {
        this(string, string2, -1);
    }

    public RestoreObjectRequest(String string, String string2, int n) {
        this.bucketName = string;
        this.key = string2;
        this.expirationInDays = n;
    }

    @Override
    public String getExpectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    @Override
    public RestoreObjectRequest withExpectedBucketOwner(String string) {
        this.expectedBucketOwner = string;
        return this;
    }

    @Override
    public void setExpectedBucketOwner(String string) {
        this.withExpectedBucketOwner(string);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public RestoreObjectRequest withBucketName(String string) {
        this.bucketName = string;
        return this;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public RestoreObjectRequest withKey(String string) {
        this.key = string;
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String string) {
        this.versionId = string;
    }

    public RestoreObjectRequest withVersionId(String string) {
        this.versionId = string;
        return this;
    }

    public void setExpirationInDays(int n) {
        this.expirationInDays = n;
    }

    public int getExpirationInDays() {
        return this.expirationInDays;
    }

    public RestoreObjectRequest withExpirationInDays(int n) {
        this.expirationInDays = n;
        return this;
    }

    public boolean isRequesterPays() {
        return this.isRequesterPays;
    }

    public void setRequesterPays(boolean bl) {
        this.isRequesterPays = bl;
    }

    public RestoreObjectRequest withRequesterPays(boolean bl) {
        this.setRequesterPays(bl);
        return this;
    }

    public GlacierJobParameters getGlacierJobParameters() {
        return this.glacierJobParameters;
    }

    public void setGlacierJobParameters(GlacierJobParameters glacierJobParameters) {
        this.glacierJobParameters = glacierJobParameters;
    }

    public RestoreObjectRequest withGlacierJobParameters(GlacierJobParameters glacierJobParameters) {
        this.setGlacierJobParameters(glacierJobParameters);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public RestoreObjectRequest withType(String string) {
        this.setType(string);
        return this;
    }

    public RestoreObjectRequest withType(RestoreRequestType restoreRequestType) {
        this.setType(restoreRequestType == null ? null : restoreRequestType.toString());
        return this;
    }

    public String getTier() {
        return this.tier;
    }

    public void setTier(String string) {
        this.tier = string;
    }

    public RestoreObjectRequest withTier(String string) {
        this.tier = string;
        return this;
    }

    public RestoreObjectRequest withTier(Tier tier) {
        this.tier = tier == null ? null : tier.toString();
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public RestoreObjectRequest withDescription(String string) {
        this.description = string;
        return this;
    }

    public SelectParameters getSelectParameters() {
        return this.selectParameters;
    }

    public void setSelectParameters(SelectParameters selectParameters) {
        this.selectParameters = selectParameters;
    }

    public RestoreObjectRequest withSelectParameters(SelectParameters selectParameters) {
        this.selectParameters = selectParameters;
        return this;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(OutputLocation outputLocation) {
        this.outputLocation = outputLocation;
    }

    public RestoreObjectRequest withOutputLocation(OutputLocation outputLocation) {
        this.outputLocation = outputLocation;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof RestoreObjectRequest)) {
            return false;
        }
        RestoreObjectRequest restoreObjectRequest = (RestoreObjectRequest)object;
        if (restoreObjectRequest.getExpirationInDays() != this.getExpirationInDays()) {
            return false;
        }
        if (restoreObjectRequest.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (restoreObjectRequest.getBucketName() != null && !restoreObjectRequest.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (restoreObjectRequest.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (restoreObjectRequest.getKey() != null && !restoreObjectRequest.getKey().equals(this.getKey())) {
            return false;
        }
        if (restoreObjectRequest.getVersionId() == null ^ this.getVersionId() == null) {
            return false;
        }
        if (restoreObjectRequest.getVersionId() != null && !restoreObjectRequest.getVersionId().equals(this.getVersionId())) {
            return false;
        }
        if (restoreObjectRequest.getGlacierJobParameters() == null ^ this.getGlacierJobParameters() == null) {
            return false;
        }
        if (restoreObjectRequest.getGlacierJobParameters() != null && !restoreObjectRequest.getGlacierJobParameters().equals(this.getGlacierJobParameters())) {
            return false;
        }
        if (restoreObjectRequest.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (restoreObjectRequest.getType() != null && !restoreObjectRequest.getType().equals(this.getType())) {
            return false;
        }
        if (restoreObjectRequest.getTier() == null ^ this.getTier() == null) {
            return false;
        }
        if (restoreObjectRequest.getTier() != null && !restoreObjectRequest.getTier().equals(this.getTier())) {
            return false;
        }
        if (restoreObjectRequest.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (restoreObjectRequest.getDescription() != null && !restoreObjectRequest.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (restoreObjectRequest.getSelectParameters() == null ^ this.getSelectParameters() == null) {
            return false;
        }
        if (restoreObjectRequest.getSelectParameters() != null && !restoreObjectRequest.getSelectParameters().equals(this.getSelectParameters())) {
            return false;
        }
        if (restoreObjectRequest.getOutputLocation() == null ^ this.getOutputLocation() == null) {
            return false;
        }
        if (restoreObjectRequest.getOutputLocation() != null && !restoreObjectRequest.getOutputLocation().equals(this.getOutputLocation())) {
            return false;
        }
        return restoreObjectRequest.isRequesterPays() == this.isRequesterPays();
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        n2 = 31 * n2 + (this.getKey() == null ? 0 : this.getKey().hashCode());
        n2 = 31 * n2 + (this.getVersionId() == null ? 0 : this.getVersionId().hashCode());
        n2 = 31 * n2 + (this.getGlacierJobParameters() == null ? 0 : this.getGlacierJobParameters().hashCode());
        n2 = 31 * n2 + (this.getType() == null ? 0 : this.getType().hashCode());
        n2 = 31 * n2 + (this.getTier() != null ? this.getTier().hashCode() : 0);
        n2 = 31 * n2 + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        n2 = 31 * n2 + (this.getSelectParameters() != null ? this.getSelectParameters().hashCode() : 0);
        n2 = 31 * n2 + (this.getOutputLocation() != null ? this.getOutputLocation().hashCode() : 0);
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("ExpirationInDays: ").append(this.expirationInDays).append(",");
        stringBuilder.append("IsRequesterPays").append(this.isRequesterPays()).append(",");
        if (this.getBucketName() != null) {
            stringBuilder.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getKey() != null) {
            stringBuilder.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getVersionId() != null) {
            stringBuilder.append("VersionId: ").append(this.getVersionId()).append(",");
        }
        if (this.getGlacierJobParameters() != null) {
            stringBuilder.append("GlacierJobParameters: ").append(this.getGlacierJobParameters()).append(",");
        }
        if (this.getType() != null) {
            stringBuilder.append("RestoreRequestType: ").append(this.getType()).append(",");
        }
        if (this.getTier() != null) {
            stringBuilder.append("Tier: ").append(this.getTier()).append(",");
        }
        if (this.getDescription() != null) {
            stringBuilder.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getSelectParameters() != null) {
            stringBuilder.append("SelectParameters: ").append(this.getSelectParameters()).append(",");
        }
        if (this.getOutputLocation() != null) {
            stringBuilder.append("OutputLocation").append(this.getOutputLocation());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public RestoreObjectRequest clone() {
        return (RestoreObjectRequest)super.clone();
    }
}

