/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsFactory;
import com.amazonaws.services.s3.model.InstructionFileId;
import com.amazonaws.services.s3.model.MaterialsDescriptionProvider;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.StorageClass;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class PutInstructionFileRequest
extends AmazonWebServiceRequest
implements EncryptionMaterialsFactory,
MaterialsDescriptionProvider {
    private final S3ObjectId s3ObjectId;
    private final EncryptionMaterials encryptionMaterials;
    private final Map<String, String> matDesc;
    private final String suffix;
    private CannedAccessControlList cannedAcl;
    private AccessControlList accessControlList;
    private String redirectLocation;
    private String storageClass;

    public PutInstructionFileRequest(S3ObjectId s3ObjectId, Map<String, String> map, String string) {
        if (s3ObjectId == null || s3ObjectId instanceof InstructionFileId) {
            throw new IllegalArgumentException("Invalid s3 object id");
        }
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("suffix must be specified");
        }
        this.s3ObjectId = s3ObjectId;
        Map<String, String> map2 = map == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap<String, String>(map));
        this.matDesc = map2;
        this.suffix = string;
        this.encryptionMaterials = null;
    }

    public PutInstructionFileRequest(S3ObjectId s3ObjectId, EncryptionMaterials encryptionMaterials, String string) {
        if (s3ObjectId == null || s3ObjectId instanceof InstructionFileId) {
            throw new IllegalArgumentException("Invalid s3 object id");
        }
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("suffix must be specified");
        }
        if (encryptionMaterials == null) {
            throw new IllegalArgumentException("encryption materials must be specified");
        }
        this.s3ObjectId = s3ObjectId;
        this.suffix = string;
        this.encryptionMaterials = encryptionMaterials;
        this.matDesc = null;
    }

    public S3ObjectId getS3ObjectId() {
        return this.s3ObjectId;
    }

    @Override
    public Map<String, String> getMaterialsDescription() {
        return this.matDesc == null ? this.encryptionMaterials.getMaterialsDescription() : this.matDesc;
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials() {
        return this.encryptionMaterials;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAccessControlList) {
        this.cannedAcl = cannedAccessControlList;
    }

    public PutInstructionFileRequest withCannedAcl(CannedAccessControlList cannedAccessControlList) {
        this.setCannedAcl(cannedAccessControlList);
        return this;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public PutInstructionFileRequest withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        return this;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public void setRedirectLocation(String string) {
        this.redirectLocation = string;
    }

    public PutInstructionFileRequest withRedirectLocation(String string) {
        this.redirectLocation = string;
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String string) {
        this.storageClass = string;
    }

    public PutInstructionFileRequest withStorageClass(String string) {
        this.setStorageClass(string);
        return this;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    public PutInstructionFileRequest withStorageClass(StorageClass storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    @Deprecated
    public PutObjectRequest createPutObjectRequest(S3Object s3Object) {
        if (!s3Object.getBucketName().equals(this.s3ObjectId.getBucket()) || !s3Object.getKey().equals(this.s3ObjectId.getKey())) {
            throw new IllegalArgumentException("s3Object passed inconsistent with the instruction file being created");
        }
        InstructionFileId instructionFileId = this.s3ObjectId.instructionFileId(this.suffix);
        return (PutObjectRequest)((AmazonWebServiceRequest)new PutObjectRequest(instructionFileId.getBucket(), instructionFileId.getKey(), this.redirectLocation).withAccessControlList(this.accessControlList).withCannedAcl(this.cannedAcl).withStorageClass(this.storageClass).withGeneralProgressListener(this.getGeneralProgressListener())).withRequestMetricCollector(this.getRequestMetricCollector());
    }

    public PutObjectRequest createPutObjectRequest(S3ObjectId s3ObjectId) {
        if (!s3ObjectId.getBucket().equals(this.s3ObjectId.getBucket()) || !s3ObjectId.getKey().equals(this.s3ObjectId.getKey())) {
            throw new IllegalArgumentException("s3Object passed inconsistent with the instruction file being created");
        }
        InstructionFileId instructionFileId = this.s3ObjectId.instructionFileId(this.suffix);
        return (PutObjectRequest)((AmazonWebServiceRequest)new PutObjectRequest(instructionFileId.getBucket(), instructionFileId.getKey(), this.redirectLocation).withAccessControlList(this.accessControlList).withCannedAcl(this.cannedAcl).withStorageClass(this.storageClass).withGeneralProgressListener(this.getGeneralProgressListener())).withRequestMetricCollector(this.getRequestMetricCollector());
    }
}

