/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.Filter;
import com.amazonaws.services.s3.model.S3Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class NotificationConfiguration {
    private Set<String> events = new HashSet<String>();
    @Deprecated
    private List<String> objectPrefixes = new ArrayList<String>();
    private Filter filter;

    protected NotificationConfiguration() {
    }

    protected NotificationConfiguration(EnumSet<S3Event> enumSet) {
        if (enumSet != null) {
            for (S3Event s3Event : enumSet) {
                this.events.add(s3Event.toString());
            }
        }
    }

    protected NotificationConfiguration(String ... stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                this.events.add(string);
            }
        }
    }

    public Set<String> getEvents() {
        return this.events;
    }

    public void setEvents(Set<String> set) {
        this.events = set;
    }

    @Deprecated
    public List<String> getObjectPrefixes() {
        return this.objectPrefixes;
    }

    @Deprecated
    public void setObjectPrefixes(List<String> list) {
        this.objectPrefixes = list;
    }

    public NotificationConfiguration withEvents(Set<String> set) {
        this.events.clear();
        this.events.addAll(set);
        return this;
    }

    @Deprecated
    public NotificationConfiguration withObjectPrefixes(String ... stringArray) {
        this.objectPrefixes.clear();
        if (stringArray != null && stringArray.length > 0) {
            this.objectPrefixes.addAll(Arrays.asList(stringArray));
        }
        return this;
    }

    public void addEvent(String string) {
        this.events.add(string);
    }

    public void addEvent(S3Event s3Event) {
        this.events.add(s3Event.toString());
    }

    @Deprecated
    public void addObjectPrefix(String string) {
        this.objectPrefixes.add(string);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public NotificationConfiguration withFilter(Filter filter) {
        this.setFilter(filter);
        return this;
    }
}

