/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.ExpectedBucketOwnerRequest;
import com.amazonaws.services.s3.model.ExpectedSourceBucketOwnerRequest;
import com.amazonaws.services.s3.model.MetadataDirective;
import com.amazonaws.services.s3.model.ObjectLockLegalHoldStatus;
import com.amazonaws.services.s3.model.ObjectLockMode;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.S3AccelerateUnsupported;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParamsProvider;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CopyObjectRequest
extends AmazonWebServiceRequest
implements ExpectedBucketOwnerRequest,
ExpectedSourceBucketOwnerRequest,
S3AccelerateUnsupported,
SSEAwsKeyManagementParamsProvider,
Serializable {
    private String expectedBucketOwner;
    private String expectedSourceBucketOwner;
    private String sourceBucketName;
    private String sourceKey;
    private String sourceVersionId;
    private String destinationBucketName;
    private String destinationKey;
    private String storageClass;
    private ObjectMetadata newObjectMetadata;
    private CannedAccessControlList cannedACL;
    private AccessControlList accessControlList;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private String redirectLocation;
    private SSECustomerKey sourceSSECustomerKey;
    private SSECustomerKey destinationSSECustomerKey;
    private SSEAwsKeyManagementParams sseAwsKeyManagementParams;
    private boolean isRequesterPays;
    private ObjectTagging newObjectTagging;
    private String metadataDirective;
    private String objectLockMode;
    private Date objectLockRetainUntilDate;
    private String objectLockLegalHoldStatus;
    private Boolean bucketKeyEnabled;

    @Override
    public String getExpectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    @Override
    public CopyObjectRequest withExpectedBucketOwner(String string) {
        this.expectedBucketOwner = string;
        return this;
    }

    @Override
    public void setExpectedBucketOwner(String string) {
        this.withExpectedBucketOwner(string);
    }

    @Override
    public String getExpectedSourceBucketOwner() {
        return this.expectedSourceBucketOwner;
    }

    @Override
    public CopyObjectRequest withExpectedSourceBucketOwner(String string) {
        this.expectedSourceBucketOwner = string;
        return this;
    }

    @Override
    public void setExpectedSourceBucketOwner(String string) {
        this.withExpectedSourceBucketOwner(string);
    }

    public CopyObjectRequest() {
    }

    public CopyObjectRequest(String string, String string2, String string3, String string4) {
        this(string, string2, null, string3, string4);
    }

    public CopyObjectRequest(String string, String string2, String string3, String string4, String string5) {
        this.sourceBucketName = string;
        this.sourceKey = string2;
        this.sourceVersionId = string3;
        this.destinationBucketName = string4;
        this.destinationKey = string5;
    }

    public String getSourceBucketName() {
        return this.sourceBucketName;
    }

    public void setSourceBucketName(String string) {
        this.sourceBucketName = string;
    }

    public CopyObjectRequest withSourceBucketName(String string) {
        this.setSourceBucketName(string);
        return this;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setSourceKey(String string) {
        this.sourceKey = string;
    }

    public CopyObjectRequest withSourceKey(String string) {
        this.setSourceKey(string);
        return this;
    }

    public String getSourceVersionId() {
        return this.sourceVersionId;
    }

    public void setSourceVersionId(String string) {
        this.sourceVersionId = string;
    }

    public CopyObjectRequest withSourceVersionId(String string) {
        this.setSourceVersionId(string);
        return this;
    }

    public String getDestinationBucketName() {
        return this.destinationBucketName;
    }

    public void setDestinationBucketName(String string) {
        this.destinationBucketName = string;
    }

    public CopyObjectRequest withDestinationBucketName(String string) {
        this.setDestinationBucketName(string);
        return this;
    }

    public String getDestinationKey() {
        return this.destinationKey;
    }

    public void setDestinationKey(String string) {
        this.destinationKey = string;
    }

    public CopyObjectRequest withDestinationKey(String string) {
        this.setDestinationKey(string);
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String string) {
        this.storageClass = string;
    }

    public CopyObjectRequest withStorageClass(String string) {
        this.setStorageClass(string);
        return this;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    public CopyObjectRequest withStorageClass(StorageClass storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public CannedAccessControlList getCannedAccessControlList() {
        return this.cannedACL;
    }

    public void setCannedAccessControlList(CannedAccessControlList cannedAccessControlList) {
        this.cannedACL = cannedAccessControlList;
    }

    public CopyObjectRequest withCannedAccessControlList(CannedAccessControlList cannedAccessControlList) {
        this.setCannedAccessControlList(cannedAccessControlList);
        return this;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public CopyObjectRequest withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        return this;
    }

    public ObjectMetadata getNewObjectMetadata() {
        return this.newObjectMetadata;
    }

    public void setNewObjectMetadata(ObjectMetadata objectMetadata) {
        this.newObjectMetadata = objectMetadata;
    }

    public CopyObjectRequest withNewObjectMetadata(ObjectMetadata objectMetadata) {
        this.setNewObjectMetadata(objectMetadata);
        return this;
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> list) {
        this.matchingETagConstraints = list;
    }

    public CopyObjectRequest withMatchingETagConstraint(String string) {
        this.matchingETagConstraints.add(string);
        return this;
    }

    public List<String> getNonmatchingETagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingETagConstraints(List<String> list) {
        this.nonmatchingEtagConstraints = list;
    }

    public CopyObjectRequest withNonmatchingETagConstraint(String string) {
        this.nonmatchingEtagConstraints.add(string);
        return this;
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date date) {
        this.unmodifiedSinceConstraint = date;
    }

    public CopyObjectRequest withUnmodifiedSinceConstraint(Date date) {
        this.setUnmodifiedSinceConstraint(date);
        return this;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date date) {
        this.modifiedSinceConstraint = date;
    }

    public CopyObjectRequest withModifiedSinceConstraint(Date date) {
        this.setModifiedSinceConstraint(date);
        return this;
    }

    public void setRedirectLocation(String string) {
        this.redirectLocation = string;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public CopyObjectRequest withRedirectLocation(String string) {
        this.redirectLocation = string;
        return this;
    }

    public SSECustomerKey getSourceSSECustomerKey() {
        return this.sourceSSECustomerKey;
    }

    public void setSourceSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.sourceSSECustomerKey = sSECustomerKey;
    }

    public CopyObjectRequest withSourceSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.setSourceSSECustomerKey(sSECustomerKey);
        return this;
    }

    public SSECustomerKey getDestinationSSECustomerKey() {
        return this.destinationSSECustomerKey;
    }

    public void setDestinationSSECustomerKey(SSECustomerKey sSECustomerKey) {
        if (sSECustomerKey != null && this.sseAwsKeyManagementParams != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSEAwsKeyManagementParams must not be set at the same time.");
        }
        this.destinationSSECustomerKey = sSECustomerKey;
    }

    public CopyObjectRequest withDestinationSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.setDestinationSSECustomerKey(sSECustomerKey);
        return this;
    }

    @Override
    public SSEAwsKeyManagementParams getSSEAwsKeyManagementParams() {
        return this.sseAwsKeyManagementParams;
    }

    public void setSSEAwsKeyManagementParams(SSEAwsKeyManagementParams sSEAwsKeyManagementParams) {
        if (sSEAwsKeyManagementParams != null && this.destinationSSECustomerKey != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSEAwsKeyManagementParams must not be set at the same time.");
        }
        this.sseAwsKeyManagementParams = sSEAwsKeyManagementParams;
    }

    public CopyObjectRequest withSSEAwsKeyManagementParams(SSEAwsKeyManagementParams sSEAwsKeyManagementParams) {
        this.setSSEAwsKeyManagementParams(sSEAwsKeyManagementParams);
        return this;
    }

    public boolean isRequesterPays() {
        return this.isRequesterPays;
    }

    public void setRequesterPays(boolean bl) {
        this.isRequesterPays = bl;
    }

    public CopyObjectRequest withRequesterPays(boolean bl) {
        this.setRequesterPays(bl);
        return this;
    }

    public ObjectTagging getNewObjectTagging() {
        return this.newObjectTagging;
    }

    public void setNewObjectTagging(ObjectTagging objectTagging) {
        this.newObjectTagging = objectTagging;
    }

    public CopyObjectRequest withNewObjectTagging(ObjectTagging objectTagging) {
        this.setNewObjectTagging(objectTagging);
        return this;
    }

    public String getMetadataDirective() {
        return this.metadataDirective;
    }

    public void setMetadataDirective(String string) {
        this.metadataDirective = string;
    }

    public CopyObjectRequest withMetadataDirective(String string) {
        this.setMetadataDirective(string);
        return this;
    }

    public CopyObjectRequest withMetadataDirective(MetadataDirective metadataDirective) {
        return this.withMetadataDirective(metadataDirective == null ? null : metadataDirective.toString());
    }

    public String getObjectLockMode() {
        return this.objectLockMode;
    }

    public CopyObjectRequest withObjectLockMode(String string) {
        this.objectLockMode = string;
        return this;
    }

    public CopyObjectRequest withObjectLockMode(ObjectLockMode objectLockMode) {
        return this.withObjectLockMode(objectLockMode.toString());
    }

    public void setObjectLockMode(String string) {
        this.withObjectLockMode(string);
    }

    public void setObjectLockMode(ObjectLockMode objectLockMode) {
        this.setObjectLockMode(objectLockMode.toString());
    }

    public Date getObjectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public CopyObjectRequest withObjectLockRetainUntilDate(Date date) {
        this.objectLockRetainUntilDate = date;
        return this;
    }

    public void setObjectLockRetainUntilDate(Date date) {
        this.withObjectLockRetainUntilDate(date);
    }

    public String getObjectLockLegalHoldStatus() {
        return this.objectLockLegalHoldStatus;
    }

    public CopyObjectRequest withObjectLockLegalHoldStatus(String string) {
        this.objectLockLegalHoldStatus = string;
        return this;
    }

    public CopyObjectRequest withObjectLockLegalHoldStatus(ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
        return this.withObjectLockLegalHoldStatus(objectLockLegalHoldStatus.toString());
    }

    public void setObjectLockLegalHoldStatus(String string) {
        this.withObjectLockLegalHoldStatus(string);
    }

    public void setObjectLockLegalHoldStatus(ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
        this.setObjectLockLegalHoldStatus(objectLockLegalHoldStatus.toString());
    }

    public Boolean getBucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    public void setBucketKeyEnabled(Boolean bl) {
        this.bucketKeyEnabled = bl;
    }

    public CopyObjectRequest withBucketKeyEnabled(Boolean bl) {
        this.setBucketKeyEnabled(bl);
        return this;
    }
}

