/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.ReplicationRule;
import com.amazonaws.util.json.Jackson;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BucketReplicationConfiguration
implements Serializable {
    private String roleARN;
    private Map<String, ReplicationRule> rules = new HashMap<String, ReplicationRule>();

    public String getRoleARN() {
        return this.roleARN;
    }

    public void setRoleARN(String string) {
        this.roleARN = string;
    }

    public BucketReplicationConfiguration withRoleARN(String string) {
        this.setRoleARN(string);
        return this;
    }

    public Map<String, ReplicationRule> getRules() {
        return this.rules;
    }

    public ReplicationRule getRule(String string) {
        return this.rules.get(string);
    }

    public void setRules(Map<String, ReplicationRule> map) {
        if (map == null) {
            throw new IllegalArgumentException("Replication rules cannot be null");
        }
        this.rules = new HashMap<String, ReplicationRule>(map);
    }

    public BucketReplicationConfiguration withRules(Map<String, ReplicationRule> map) {
        this.setRules(map);
        return this;
    }

    public BucketReplicationConfiguration addRule(String string, ReplicationRule replicationRule) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("Rule id cannot be null or empty.");
        }
        if (replicationRule == null) {
            throw new IllegalArgumentException("Replication rule cannot be null");
        }
        this.rules.put(string, replicationRule);
        return this;
    }

    public BucketReplicationConfiguration removeRule(String string) {
        this.rules.remove(string);
        return this;
    }

    public String toString() {
        return Jackson.toJsonString(this);
    }
}

