/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.services.s3.model.EventBridgeConfiguration;
import com.amazonaws.services.s3.model.NotificationConfiguration;
import com.amazonaws.util.json.Jackson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class BucketNotificationConfiguration
implements Serializable {
    private Map<String, NotificationConfiguration> configurations = new HashMap<String, NotificationConfiguration>();
    private EventBridgeConfiguration eventBridgeConfiguration;

    public BucketNotificationConfiguration() {
    }

    public BucketNotificationConfiguration(String string, NotificationConfiguration notificationConfiguration) {
        this.addConfiguration(string, notificationConfiguration);
    }

    public BucketNotificationConfiguration withNotificationConfiguration(Map<String, NotificationConfiguration> map) {
        this.configurations.clear();
        this.configurations.putAll(map);
        return this;
    }

    public BucketNotificationConfiguration addConfiguration(String string, NotificationConfiguration notificationConfiguration) {
        this.configurations.put(string, notificationConfiguration);
        return this;
    }

    public Map<String, NotificationConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, NotificationConfiguration> map) {
        this.configurations = map;
    }

    public NotificationConfiguration getConfigurationByName(String string) {
        return this.configurations.get(string);
    }

    public NotificationConfiguration removeConfiguration(String string) {
        return this.configurations.remove(string);
    }

    public BucketNotificationConfiguration(Collection<TopicConfiguration> collection) {
        if (collection != null) {
            for (TopicConfiguration topicConfiguration : collection) {
                this.addConfiguration(UUID.randomUUID().toString(), topicConfiguration);
            }
        }
    }

    public BucketNotificationConfiguration withTopicConfigurations(TopicConfiguration ... topicConfigurationArray) {
        this.setTopicConfigurations(Arrays.asList(topicConfigurationArray));
        return this;
    }

    public void setTopicConfigurations(Collection<TopicConfiguration> collection) {
        this.configurations.clear();
        if (collection != null) {
            for (TopicConfiguration topicConfiguration : collection) {
                this.addConfiguration(UUID.randomUUID().toString(), topicConfiguration);
            }
        }
    }

    public List<TopicConfiguration> getTopicConfigurations() {
        ArrayList<TopicConfiguration> arrayList = new ArrayList<TopicConfiguration>();
        for (Map.Entry<String, NotificationConfiguration> entry : this.configurations.entrySet()) {
            if (!(entry.getValue() instanceof TopicConfiguration)) continue;
            arrayList.add((TopicConfiguration)entry.getValue());
        }
        return arrayList;
    }

    public EventBridgeConfiguration getEventBridgeConfiguration() {
        return this.eventBridgeConfiguration;
    }

    public void setEventBridgeConfiguration(EventBridgeConfiguration eventBridgeConfiguration) {
        this.eventBridgeConfiguration = eventBridgeConfiguration;
    }

    public BucketNotificationConfiguration withEventBridgeConfiguration(EventBridgeConfiguration eventBridgeConfiguration) {
        this.eventBridgeConfiguration = eventBridgeConfiguration;
        return this;
    }

    public String toString() {
        return Jackson.toJsonString(this.getConfigurations());
    }

    @Deprecated
    public static class TopicConfiguration
    extends com.amazonaws.services.s3.model.TopicConfiguration {
        public TopicConfiguration(String string, String string2) {
            super(string, new String[]{string2});
        }

        public String getTopic() {
            return this.getTopicARN();
        }

        public String getEvent() {
            Set<String> set = this.getEvents();
            String[] stringArray = set.toArray(new String[set.size()]);
            return stringArray[0];
        }

        public String toString() {
            return Jackson.toJsonString(this);
        }
    }
}

