/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.LegacyS3ProgressListener;
import com.amazonaws.services.s3.model.ObjectLockLegalHoldStatus;
import com.amazonaws.services.s3.model.ObjectLockMode;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.ObjectTagging;
import com.amazonaws.services.s3.model.ProgressListener;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3DataSource;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParamsProvider;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SSECustomerKeyProvider;
import com.amazonaws.services.s3.model.StorageClass;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;

public abstract class AbstractPutObjectRequest
extends AmazonWebServiceRequest
implements S3DataSource,
SSEAwsKeyManagementParamsProvider,
SSECustomerKeyProvider,
Serializable,
Cloneable {
    private String bucketName;
    private String key;
    private File file;
    private transient InputStream inputStream;
    private ObjectMetadata metadata;
    private CannedAccessControlList cannedAcl;
    private AccessControlList accessControlList;
    private String storageClass;
    private String redirectLocation;
    private SSECustomerKey sseCustomerKey;
    private SSEAwsKeyManagementParams sseAwsKeyManagementParams;
    private ObjectTagging tagging;
    private String objectLockMode;
    private Date objectLockRetainUntilDate;
    private String objectLockLegalHoldStatus;
    private Boolean bucketKeyEnabled;

    public AbstractPutObjectRequest(String string, String string2, File file) {
        this.bucketName = string;
        this.key = string2;
        this.file = file;
    }

    public AbstractPutObjectRequest(String string, String string2, String string3) {
        this.bucketName = string;
        this.key = string2;
        this.redirectLocation = string3;
    }

    protected AbstractPutObjectRequest(String string, String string2, InputStream inputStream2, ObjectMetadata objectMetadata) {
        this.bucketName = string;
        this.key = string2;
        this.inputStream = inputStream2;
        this.metadata = objectMetadata;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String string) {
        this.bucketName = string;
    }

    public <T extends AbstractPutObjectRequest> T withBucketName(String string) {
        this.setBucketName(string);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public <T extends AbstractPutObjectRequest> T withKey(String string) {
        this.setKey(string);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String string) {
        this.storageClass = string;
    }

    public <T extends AbstractPutObjectRequest> T withStorageClass(String string) {
        this.setStorageClass(string);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    public <T extends AbstractPutObjectRequest> T withStorageClass(StorageClass storageClass) {
        this.setStorageClass(storageClass);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    public <T extends AbstractPutObjectRequest> T withFile(File file) {
        this.setFile(file);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public ObjectMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMetadata objectMetadata) {
        this.metadata = objectMetadata;
    }

    public <T extends AbstractPutObjectRequest> T withMetadata(ObjectMetadata objectMetadata) {
        this.setMetadata(objectMetadata);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public CannedAccessControlList getCannedAcl() {
        return this.cannedAcl;
    }

    public void setCannedAcl(CannedAccessControlList cannedAccessControlList) {
        this.cannedAcl = cannedAccessControlList;
    }

    public <T extends AbstractPutObjectRequest> T withCannedAcl(CannedAccessControlList cannedAccessControlList) {
        this.setCannedAcl(cannedAccessControlList);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public <T extends AbstractPutObjectRequest> T withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream inputStream2) {
        this.inputStream = inputStream2;
    }

    public <T extends AbstractPutObjectRequest> T withInputStream(InputStream inputStream2) {
        this.setInputStream(inputStream2);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public void setRedirectLocation(String string) {
        this.redirectLocation = string;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public <T extends AbstractPutObjectRequest> T withRedirectLocation(String string) {
        this.redirectLocation = string;
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sSECustomerKey) {
        if (sSECustomerKey != null && this.sseAwsKeyManagementParams != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSEAwsKeyManagementParams must not be set at the same time.");
        }
        this.sseCustomerKey = sSECustomerKey;
    }

    public <T extends AbstractPutObjectRequest> T withSSECustomerKey(SSECustomerKey sSECustomerKey) {
        this.setSSECustomerKey(sSECustomerKey);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public ObjectTagging getTagging() {
        return this.tagging;
    }

    public void setTagging(ObjectTagging objectTagging) {
        this.tagging = objectTagging;
    }

    public <T extends PutObjectRequest> T withTagging(ObjectTagging objectTagging) {
        this.setTagging(objectTagging);
        PutObjectRequest putObjectRequest = (PutObjectRequest)this;
        return (T)putObjectRequest;
    }

    public String getObjectLockMode() {
        return this.objectLockMode;
    }

    public <T extends PutObjectRequest> T withObjectLockMode(String string) {
        this.objectLockMode = string;
        return (T)((PutObjectRequest)this);
    }

    public <T extends PutObjectRequest> T withObjectLockMode(ObjectLockMode objectLockMode) {
        return this.withObjectLockMode(objectLockMode.toString());
    }

    public void setObjectLockMode(String string) {
        this.withObjectLockMode(string);
    }

    public void setObjectLockMode(ObjectLockMode objectLockMode) {
        this.setObjectLockMode(objectLockMode.toString());
    }

    public Date getObjectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public <T extends PutObjectRequest> T withObjectLockRetainUntilDate(Date date) {
        this.objectLockRetainUntilDate = date;
        return (T)((PutObjectRequest)this);
    }

    public void setObjectLockRetainUntilDate(Date date) {
        this.withObjectLockRetainUntilDate(date);
    }

    public String getObjectLockLegalHoldStatus() {
        return this.objectLockLegalHoldStatus;
    }

    public <T extends PutObjectRequest> T withObjectLockLegalHoldStatus(String string) {
        this.objectLockLegalHoldStatus = string;
        return (T)((PutObjectRequest)this);
    }

    public <T extends PutObjectRequest> T withObjectLockLegalHoldStatus(ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
        return this.withObjectLockLegalHoldStatus(objectLockLegalHoldStatus.toString());
    }

    public void setObjectLockLegalHoldStatus(String string) {
        this.withObjectLockLegalHoldStatus(string);
    }

    public void setObjectLockLegalHoldStatus(ObjectLockLegalHoldStatus objectLockLegalHoldStatus) {
        this.setObjectLockLegalHoldStatus(objectLockLegalHoldStatus.toString());
    }

    @Deprecated
    public void setProgressListener(ProgressListener progressListener) {
        this.setGeneralProgressListener(new LegacyS3ProgressListener(progressListener));
    }

    @Deprecated
    public ProgressListener getProgressListener() {
        com.amazonaws.event.ProgressListener progressListener = this.getGeneralProgressListener();
        if (progressListener instanceof LegacyS3ProgressListener) {
            return ((LegacyS3ProgressListener)progressListener).unwrap();
        }
        return null;
    }

    @Deprecated
    public <T extends AbstractPutObjectRequest> T withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public SSEAwsKeyManagementParams getSSEAwsKeyManagementParams() {
        return this.sseAwsKeyManagementParams;
    }

    public void setSSEAwsKeyManagementParams(SSEAwsKeyManagementParams sSEAwsKeyManagementParams) {
        if (sSEAwsKeyManagementParams != null && this.sseCustomerKey != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSEAwsKeyManagementParams must not be set at the same time.");
        }
        this.sseAwsKeyManagementParams = sSEAwsKeyManagementParams;
    }

    public <T extends AbstractPutObjectRequest> T withSSEAwsKeyManagementParams(SSEAwsKeyManagementParams sSEAwsKeyManagementParams) {
        this.setSSEAwsKeyManagementParams(sSEAwsKeyManagementParams);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    public Boolean getBucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    public void setBucketKeyEnabled(Boolean bl) {
        this.bucketKeyEnabled = bl;
    }

    public <T extends AbstractPutObjectRequest> T withBucketKeyEnabled(Boolean bl) {
        this.setBucketKeyEnabled(bl);
        AbstractPutObjectRequest abstractPutObjectRequest = this;
        return (T)abstractPutObjectRequest;
    }

    @Override
    public AbstractPutObjectRequest clone() {
        return (AbstractPutObjectRequest)super.clone();
    }

    protected final <T extends AbstractPutObjectRequest> T copyPutObjectBaseTo(T t2) {
        this.copyBaseTo(t2);
        ObjectMetadata objectMetadata = this.getMetadata();
        return ((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)((AbstractPutObjectRequest)t2.withAccessControlList(this.getAccessControlList())).withCannedAcl(this.getCannedAcl())).withInputStream(this.getInputStream())).withMetadata(objectMetadata == null ? null : objectMetadata.clone())).withRedirectLocation(this.getRedirectLocation())).withStorageClass(this.getStorageClass())).withSSEAwsKeyManagementParams(this.getSSEAwsKeyManagementParams())).withSSECustomerKey(this.getSSECustomerKey());
    }
}

