/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v2;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.SdkClientException;
import com.amazonaws.internal.ReleasableInputStream;
import com.amazonaws.internal.ResettableInputStream;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.GenerateDataKeyRequest;
import com.amazonaws.services.kms.model.GenerateDataKeyResult;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.S3RequesterChargedResult;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.RenewableCipherLiteInputStream;
import com.amazonaws.services.s3.internal.crypto.keywrap.InternalKeyWrapAlgorithm;
import com.amazonaws.services.s3.internal.crypto.v2.ContentCryptoMaterial;
import com.amazonaws.services.s3.internal.crypto.v2.KMSMaterialsHandler;
import com.amazonaws.services.s3.internal.crypto.v2.MultipartUploadContext;
import com.amazonaws.services.s3.internal.crypto.v2.MultipartUploadCryptoContext;
import com.amazonaws.services.s3.internal.crypto.v2.S3CryptoModule;
import com.amazonaws.services.s3.internal.crypto.v2.S3ObjectWrapper;
import com.amazonaws.services.s3.internal.crypto.v2.SecuredCEK;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AbstractPutObjectRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazonaws.services.s3.model.CryptoStorageMode;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsFactory;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.InstructionFileId;
import com.amazonaws.services.s3.model.KMSEncryptionMaterials;
import com.amazonaws.services.s3.model.MaterialsDescriptionProvider;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutInstructionFileRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3DataSource;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.UploadObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.LengthCheckInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.Throwables;
import com.amazonaws.util.json.Jackson;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class S3CryptoModuleBase<T extends MultipartUploadCryptoContext>
extends S3CryptoModule<T> {
    private static final boolean IS_MULTI_PART = true;
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterialsProvider kekMaterialsProvider;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final ContentCryptoScheme contentCryptoScheme;
    protected final CryptoConfigurationV2 cryptoConfig;
    protected final Map<String, T> multipartUploadContexts = Collections.synchronizedMap(new HashMap());
    protected final S3Direct s3;
    protected final AWSKMS kms;

    protected S3CryptoModuleBase(AWSKMS aWSKMS, S3Direct s3Direct, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfigurationV2 cryptoConfigurationV2) {
        if (!cryptoConfigurationV2.isReadOnly()) {
            throw new IllegalArgumentException("The crypto configuration parameter is required to be read-only");
        }
        this.kekMaterialsProvider = encryptionMaterialsProvider;
        this.s3 = s3Direct;
        this.cryptoConfig = cryptoConfigurationV2;
        this.contentCryptoScheme = ContentCryptoScheme.AES_GCM;
        this.kms = aWSKMS;
    }

    protected abstract long ciphertextLength(long var1);

    @Override
    public CryptoConfigurationV2 getCryptoConfiguration() {
        return this.cryptoConfig;
    }

    @Override
    public EncryptionMaterialsProvider getEncryptionMaterialsProvider() {
        return this.kekMaterialsProvider;
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) {
        return this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile ? this.putObjectUsingInstructionFile(putObjectRequest) : this.putObjectUsingMetadata(putObjectRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PutObjectResult putObjectUsingMetadata(PutObjectRequest putObjectRequest) {
        ContentCryptoMaterial contentCryptoMaterial = this.createContentCryptoMaterial(putObjectRequest);
        File file = putObjectRequest.getFile();
        InputStream inputStream2 = putObjectRequest.getInputStream();
        PutObjectRequest putObjectRequest2 = this.wrapWithCipher(putObjectRequest, contentCryptoMaterial);
        putObjectRequest.setMetadata(this.updateMetadataWithContentCryptoMaterial(putObjectRequest.getMetadata(), putObjectRequest.getFile(), contentCryptoMaterial));
        try {
            PutObjectResult putObjectResult = this.s3.putObject(putObjectRequest2);
            return putObjectResult;
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(putObjectRequest, file, inputStream2, putObjectRequest2.getInputStream(), this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PutObjectResult putObjectUsingInstructionFile(PutObjectRequest putObjectRequest) {
        PutObjectResult putObjectResult;
        File file = putObjectRequest.getFile();
        InputStream inputStream2 = putObjectRequest.getInputStream();
        PutObjectRequest putObjectRequest2 = putObjectRequest.clone().withFile(null).withInputStream(null);
        putObjectRequest2.setKey(putObjectRequest2.getKey() + "." + "instruction");
        ContentCryptoMaterial contentCryptoMaterial = this.createContentCryptoMaterial(putObjectRequest);
        PutObjectRequest putObjectRequest3 = this.wrapWithCipher(putObjectRequest, contentCryptoMaterial);
        try {
            putObjectResult = this.s3.putObject(putObjectRequest3);
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(putObjectRequest, file, inputStream2, putObjectRequest3.getInputStream(), this.log);
        }
        this.s3.putObject(this.updateInstructionPutRequest(putObjectRequest2, contentCryptoMaterial));
        return putObjectResult;
    }

    @Override
    public final void abortMultipartUploadSecurely(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        this.s3.abortMultipartUpload(abortMultipartUploadRequest);
        this.multipartUploadContexts.remove(abortMultipartUploadRequest.getUploadId());
    }

    @Override
    public final CopyPartResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        String string = copyPartRequest.getUploadId();
        MultipartUploadCryptoContext multipartUploadCryptoContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(string);
        CopyPartResult copyPartResult = this.s3.copyPart(copyPartRequest);
        if (multipartUploadCryptoContext != null && !multipartUploadCryptoContext.hasFinalPartBeenSeen()) {
            multipartUploadCryptoContext.setHasFinalPartBeenSeen(true);
        }
        return copyPartResult;
    }

    abstract T newUploadContext(InitiateMultipartUploadRequest var1, ContentCryptoMaterial var2);

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        S3RequesterChargedResult s3RequesterChargedResult;
        ContentCryptoMaterial contentCryptoMaterial = this.createContentCryptoMaterial(initiateMultipartUploadRequest);
        if (this.cryptoConfig.getStorageMode() == CryptoStorageMode.ObjectMetadata) {
            s3RequesterChargedResult = initiateMultipartUploadRequest.getObjectMetadata();
            if (s3RequesterChargedResult == null) {
                s3RequesterChargedResult = new ObjectMetadata();
            }
            initiateMultipartUploadRequest.setObjectMetadata(this.updateMetadataWithContentCryptoMaterial((ObjectMetadata)s3RequesterChargedResult, null, contentCryptoMaterial));
        }
        s3RequesterChargedResult = this.s3.initiateMultipartUpload(initiateMultipartUploadRequest);
        T t2 = this.newUploadContext(initiateMultipartUploadRequest, contentCryptoMaterial);
        if (initiateMultipartUploadRequest instanceof MaterialsDescriptionProvider) {
            MaterialsDescriptionProvider materialsDescriptionProvider = (MaterialsDescriptionProvider)((Object)initiateMultipartUploadRequest);
            ((MultipartUploadContext)t2).setMaterialsDescription(materialsDescriptionProvider.getMaterialsDescription());
        }
        this.multipartUploadContexts.put(((InitiateMultipartUploadResult)s3RequesterChargedResult).getUploadId(), t2);
        return s3RequesterChargedResult;
    }

    abstract CipherLite cipherLiteForNextPart(T var1);

    abstract long computeLastPartSize(UploadPartRequest var1);

    abstract <I extends CipherLiteInputStream> SdkFilterInputStream wrapForMultipart(I var1, long var2);

    abstract void updateUploadContext(T var1, SdkFilterInputStream var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest uploadPartRequest) {
        UploadPartResult uploadPartResult;
        boolean bl;
        int n = this.contentCryptoScheme.getBlockSizeInBytes();
        boolean bl2 = uploadPartRequest.isLastPart();
        String string = uploadPartRequest.getUploadId();
        long l = uploadPartRequest.getPartSize();
        boolean bl3 = bl = 0L == l % (long)n;
        if (!bl2 && !bl) {
            throw new SdkClientException("Invalid part size: part sizes for encrypted multipart uploads must be multiples of the cipher block size (" + n + ") with the exception of the last part.");
        }
        MultipartUploadCryptoContext multipartUploadCryptoContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(string);
        if (multipartUploadCryptoContext == null) {
            throw new SdkClientException("No client-side information available on upload ID " + string);
        }
        multipartUploadCryptoContext.beginPartUpload(uploadPartRequest.getPartNumber());
        CipherLite cipherLite = this.cipherLiteForNextPart(multipartUploadCryptoContext);
        File file = uploadPartRequest.getFile();
        InputStream inputStream2 = uploadPartRequest.getInputStream();
        SdkFilterInputStream sdkFilterInputStream = null;
        try {
            CipherLiteInputStream cipherLiteInputStream;
            sdkFilterInputStream = cipherLiteInputStream = this.newMultipartS3CipherInputStream(uploadPartRequest, cipherLite);
            sdkFilterInputStream = this.wrapForMultipart(cipherLiteInputStream, l);
            uploadPartRequest.setInputStream(sdkFilterInputStream);
            uploadPartRequest.setFile(null);
            uploadPartRequest.setFileOffset(0L);
            if (bl2) {
                long l2 = this.computeLastPartSize(uploadPartRequest);
                if (l2 > -1L) {
                    uploadPartRequest.setPartSize(l2);
                }
                if (multipartUploadCryptoContext.hasFinalPartBeenSeen()) {
                    throw new SdkClientException("This part was specified as the last part in a multipart upload, but a previous part was already marked as the last part.  Only the last part of the upload should be marked as the last part.");
                }
            }
            uploadPartResult = this.s3.uploadPart(uploadPartRequest);
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(uploadPartRequest, file, inputStream2, sdkFilterInputStream, this.log);
            multipartUploadCryptoContext.endPartUpload();
        }
        if (bl2) {
            multipartUploadCryptoContext.setHasFinalPartBeenSeen(true);
        }
        this.updateUploadContext(multipartUploadCryptoContext, sdkFilterInputStream);
        return uploadPartResult;
    }

    protected final CipherLiteInputStream newMultipartS3CipherInputStream(UploadPartRequest uploadPartRequest, CipherLite cipherLite) {
        File file = uploadPartRequest.getFile();
        InputStream inputStream2 = uploadPartRequest.getInputStream();
        InputStream inputStream3 = null;
        try {
            if (file == null) {
                if (inputStream2 == null) {
                    throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
                }
                inputStream3 = inputStream2;
            } else {
                inputStream3 = new ResettableInputStream(file);
            }
            inputStream3 = new InputSubstream(inputStream3, uploadPartRequest.getFileOffset(), uploadPartRequest.getPartSize(), uploadPartRequest.isLastPart());
            return cipherLite.markSupported() ? new CipherLiteInputStream(inputStream3, cipherLite, 2048, true, uploadPartRequest.isLastPart()) : new RenewableCipherLiteInputStream(inputStream3, cipherLite, 2048, true, uploadPartRequest.isLastPart());
        }
        catch (Exception exception) {
            S3DataSource.Utils.cleanupDataSource(uploadPartRequest, file, inputStream2, inputStream3, this.log);
            throw Throwables.failure(exception, "Unable to create cipher input stream");
        }
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        String string = completeMultipartUploadRequest.getUploadId();
        MultipartUploadCryptoContext multipartUploadCryptoContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(string);
        if (multipartUploadCryptoContext != null && !multipartUploadCryptoContext.hasFinalPartBeenSeen()) {
            throw new SdkClientException("Unable to complete an encrypted multipart upload without being told which part was the last.  Without knowing which part was the last, the encrypted data in Amazon S3 is incomplete and corrupt.");
        }
        CompleteMultipartUploadResult completeMultipartUploadResult = this.s3.completeMultipartUpload(completeMultipartUploadRequest);
        if (multipartUploadCryptoContext != null && this.cryptoConfig.getStorageMode() == CryptoStorageMode.InstructionFile) {
            this.s3.putObject(this.createInstructionPutRequest(multipartUploadCryptoContext.getBucketName(), multipartUploadCryptoContext.getKey(), multipartUploadCryptoContext.getContentCryptoMaterial()));
        }
        this.multipartUploadContexts.remove(string);
        return completeMultipartUploadResult;
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata objectMetadata, File file, ContentCryptoMaterial contentCryptoMaterial) {
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        if (file != null) {
            Mimetypes mimetypes = Mimetypes.getInstance();
            objectMetadata.setContentType(mimetypes.getMimetype(file));
        }
        return contentCryptoMaterial.toObjectMetadata(objectMetadata);
    }

    protected final ContentCryptoMaterial createContentCryptoMaterial(AmazonWebServiceRequest amazonWebServiceRequest) {
        Object object;
        Map<String, String> map;
        if (amazonWebServiceRequest instanceof EncryptionMaterialsFactory && (map = (object = (EncryptionMaterialsFactory)((Object)amazonWebServiceRequest)).getEncryptionMaterials()) != null) {
            return this.buildContentCryptoMaterial((EncryptionMaterials)((Object)map), amazonWebServiceRequest);
        }
        if (amazonWebServiceRequest instanceof MaterialsDescriptionProvider) {
            EncryptionMaterials encryptionMaterials;
            object = (MaterialsDescriptionProvider)((Object)amazonWebServiceRequest);
            map = object.getMaterialsDescription();
            ContentCryptoMaterial contentCryptoMaterial = this.newContentCryptoMaterial(this.kekMaterialsProvider, map, this.cryptoConfig.getCryptoProvider(), amazonWebServiceRequest);
            if (contentCryptoMaterial != null) {
                return contentCryptoMaterial;
            }
            if (!(map == null || (encryptionMaterials = this.kekMaterialsProvider.getEncryptionMaterials()) != null && encryptionMaterials.isKMSEnabled())) {
                throw new SdkClientException("No material available from the encryption material provider for description " + map);
            }
        }
        return this.newContentCryptoMaterial(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), amazonWebServiceRequest);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider encryptionMaterialsProvider, Map<String, String> map, Provider provider, AmazonWebServiceRequest amazonWebServiceRequest) {
        EncryptionMaterials encryptionMaterials = encryptionMaterialsProvider.getEncryptionMaterials(map);
        if (encryptionMaterials == null) {
            return null;
        }
        return this.buildContentCryptoMaterial(encryptionMaterials, amazonWebServiceRequest);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider encryptionMaterialsProvider, Provider provider, AmazonWebServiceRequest amazonWebServiceRequest) {
        EncryptionMaterials encryptionMaterials = encryptionMaterialsProvider.getEncryptionMaterials();
        if (encryptionMaterials == null) {
            throw new SdkClientException("No material available from the encryption material provider");
        }
        return this.buildContentCryptoMaterial(encryptionMaterials, amazonWebServiceRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void putLocalObjectSecurely(UploadObjectRequest uploadObjectRequest, String string, OutputStream outputStream2) throws IOException {
        UploadObjectRequest uploadObjectRequest2 = uploadObjectRequest.clone();
        File file = uploadObjectRequest2.getFile();
        InputStream inputStream2 = uploadObjectRequest2.getInputStream();
        MultipartUploadCryptoContext multipartUploadCryptoContext = (MultipartUploadCryptoContext)this.multipartUploadContexts.get(string);
        ContentCryptoMaterial contentCryptoMaterial = multipartUploadCryptoContext.getContentCryptoMaterial();
        uploadObjectRequest2 = this.wrapWithCipher(uploadObjectRequest2, contentCryptoMaterial);
        try {
            IOUtils.copy(uploadObjectRequest2.getInputStream(), outputStream2);
            multipartUploadCryptoContext.setHasFinalPartBeenSeen(true);
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(uploadObjectRequest2, file, inputStream2, uploadObjectRequest2.getInputStream(), this.log);
            IOUtils.closeQuietly(outputStream2, this.log);
        }
    }

    private ContentCryptoMaterial buildContentCryptoMaterial(EncryptionMaterials encryptionMaterials, AmazonWebServiceRequest amazonWebServiceRequest) {
        byte[] byArray = new byte[this.contentCryptoScheme.getIVLengthInBytes()];
        this.cryptoConfig.getSecureRandom().nextBytes(byArray);
        if (encryptionMaterials.isKMSEnabled()) {
            String string = this.contentCryptoScheme.getCipherAlgorithm();
            Map<String, String> map = KMSMaterialsHandler.createKMSContextMaterialsDescription(KMSMaterialsHandler.mergeMaterialsDescription((KMSEncryptionMaterials)encryptionMaterials, amazonWebServiceRequest), string);
            GenerateDataKeyRequest generateDataKeyRequest = new GenerateDataKeyRequest().withEncryptionContext(map).withKeyId(encryptionMaterials.getCustomerMasterKeyId()).withKeySpec(this.contentCryptoScheme.getKeySpec());
            ((AmazonWebServiceRequest)generateDataKeyRequest.withGeneralProgressListener(amazonWebServiceRequest.getGeneralProgressListener())).withRequestMetricCollector(amazonWebServiceRequest.getRequestMetricCollector());
            GenerateDataKeyResult generateDataKeyResult = this.kms.generateDataKey(generateDataKeyRequest);
            SecretKeySpec secretKeySpec = new SecretKeySpec(BinaryUtils.copyAllBytesFrom(generateDataKeyResult.getPlaintext()), this.contentCryptoScheme.getKeyGeneratorAlgorithm());
            byte[] byArray2 = BinaryUtils.copyAllBytesFrom(generateDataKeyResult.getCiphertextBlob());
            return ContentCryptoMaterial.wrap(secretKeySpec, byArray, this.contentCryptoScheme, this.cryptoConfig.getCryptoProvider(), this.cryptoConfig.getAlwaysUseCryptoProvider(), new SecuredCEK(byArray2, InternalKeyWrapAlgorithm.KMS, map));
        }
        return ContentCryptoMaterial.create(this.generateCEK(encryptionMaterials), byArray, encryptionMaterials, this.contentCryptoScheme, this.cryptoConfig, this.kms, amazonWebServiceRequest);
    }

    protected final SecretKey generateCEK(EncryptionMaterials encryptionMaterials) {
        String string = this.contentCryptoScheme.getKeyGeneratorAlgorithm();
        try {
            Serializable serializable;
            KeyGenerator keyGenerator = this.cryptoConfig.getCryptoProvider() == null ? KeyGenerator.getInstance(string) : KeyGenerator.getInstance(string, this.cryptoConfig.getCryptoProvider());
            keyGenerator.init(this.contentCryptoScheme.getKeyLengthInBits(), this.cryptoConfig.getSecureRandom());
            boolean bl = false;
            KeyPair keyPair = encryptionMaterials.getKeyPair();
            if (keyPair != null) {
                serializable = keyGenerator.getProvider();
                String string2 = serializable == null ? null : ((Provider)serializable).getName();
                bl = "BC".equals(string2);
            }
            serializable = keyGenerator.generateKey();
            if (!bl || serializable.getEncoded()[0] != 0) {
                return serializable;
            }
            for (int i = 0; i < 9; ++i) {
                serializable = keyGenerator.generateKey();
                if (serializable.getEncoded()[0] == 0) continue;
                return serializable;
            }
            throw new SdkClientException("Failed to generate secret key");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SdkClientException("Unable to generate envelope symmetric key:" + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    protected final <R extends AbstractPutObjectRequest> R wrapWithCipher(R r, ContentCryptoMaterial contentCryptoMaterial) {
        ObjectMetadata objectMetadata = r.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
        }
        objectMetadata.setContentMD5(null);
        long l = this.plaintextLength(r, objectMetadata);
        if (l >= 0L) {
            objectMetadata.addUserMetadata("x-amz-unencrypted-content-length", Long.toString(l));
            objectMetadata.setContentLength(this.ciphertextLength(l));
        }
        r.setMetadata(objectMetadata);
        r.setInputStream(this.newS3CipherLiteInputStream(r, contentCryptoMaterial, l));
        r.setFile(null);
        return r;
    }

    private CipherLiteInputStream newS3CipherLiteInputStream(AbstractPutObjectRequest abstractPutObjectRequest, ContentCryptoMaterial contentCryptoMaterial, long l) {
        File file = abstractPutObjectRequest.getFile();
        InputStream inputStream2 = abstractPutObjectRequest.getInputStream();
        SdkFilterInputStream sdkFilterInputStream = null;
        try {
            CipherLite cipherLite;
            sdkFilterInputStream = file == null ? (inputStream2 == null ? null : ReleasableInputStream.wrap(inputStream2)) : new ResettableInputStream(file);
            if (l > -1L) {
                sdkFilterInputStream = new LengthCheckInputStream(sdkFilterInputStream, l, false);
            }
            if ((cipherLite = contentCryptoMaterial.getCipherLite()).markSupported()) {
                return new CipherLiteInputStream(sdkFilterInputStream, cipherLite, 2048);
            }
            return new RenewableCipherLiteInputStream(sdkFilterInputStream, cipherLite, 2048);
        }
        catch (Exception exception) {
            S3DataSource.Utils.cleanupDataSource(abstractPutObjectRequest, file, inputStream2, sdkFilterInputStream, this.log);
            throw Throwables.failure(exception, "Unable to create cipher input stream");
        }
    }

    protected final long plaintextLength(AbstractPutObjectRequest abstractPutObjectRequest, ObjectMetadata objectMetadata) {
        if (abstractPutObjectRequest.getFile() != null) {
            return abstractPutObjectRequest.getFile().length();
        }
        if (abstractPutObjectRequest.getInputStream() != null && objectMetadata.getRawMetadataValue("Content-Length") != null) {
            return objectMetadata.getContentLength();
        }
        return -1L;
    }

    protected final PutObjectRequest updateInstructionPutRequest(PutObjectRequest putObjectRequest, ContentCryptoMaterial contentCryptoMaterial) {
        byte[] byArray = contentCryptoMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ObjectMetadata objectMetadata = putObjectRequest.getMetadata();
        if (objectMetadata == null) {
            objectMetadata = new ObjectMetadata();
            putObjectRequest.setMetadata(objectMetadata);
        }
        objectMetadata.setContentMD5(null);
        objectMetadata.setContentLength(byArray.length);
        objectMetadata.addUserMetadata("x-amz-crypto-instr-file", "");
        putObjectRequest.setMetadata(objectMetadata);
        putObjectRequest.setInputStream(new ByteArrayInputStream(byArray));
        return putObjectRequest;
    }

    protected final PutObjectRequest createInstructionPutRequest(String string, String string2, ContentCryptoMaterial contentCryptoMaterial) {
        byte[] byArray = contentCryptoMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength(byArray.length);
        objectMetadata.addUserMetadata("x-amz-crypto-instr-file", "");
        InstructionFileId instructionFileId = new S3ObjectId(string, string2).instructionFileId();
        return new PutObjectRequest(instructionFileId.getBucket(), instructionFileId.getKey(), byteArrayInputStream, objectMetadata);
    }

    protected void securityCheck(ContentCryptoMaterial contentCryptoMaterial, S3ObjectId s3ObjectId, boolean bl) {
    }

    final S3ObjectWrapper fetchInstructionFile(S3ObjectId s3ObjectId, String string) {
        try {
            S3Object s3Object = this.s3.getObject(this.createInstructionGetRequest(s3ObjectId, string));
            return s3Object == null ? null : new S3ObjectWrapper(s3Object, s3ObjectId);
        }
        catch (AmazonServiceException amazonServiceException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unable to retrieve instruction file : " + amazonServiceException.getMessage());
            }
            return null;
        }
    }

    @Override
    public final PutObjectResult putInstructionFileSecurely(PutInstructionFileRequest putInstructionFileRequest) {
        S3ObjectId s3ObjectId = putInstructionFileRequest.getS3ObjectId();
        ObjectMetadata objectMetadata = this.getObjectMetadata(s3ObjectId);
        Map<String, String> map = this.getUserMetadata(s3ObjectId, objectMetadata);
        ContentCryptoMaterial contentCryptoMaterial = this.contentCryptoMaterialOf(map, objectMetadata);
        this.securityCheck(contentCryptoMaterial, s3ObjectId, false);
        String string = map.get("x-amz-wrap-alg");
        ContentCryptoMaterial contentCryptoMaterial2 = contentCryptoMaterial.recreate(this.kekMaterialsProvider, this.cryptoConfig, string, this.kms, putInstructionFileRequest);
        PutObjectRequest putObjectRequest = putInstructionFileRequest.createPutObjectRequest(s3ObjectId);
        return this.s3.putObject(this.updateInstructionPutRequest(putObjectRequest, contentCryptoMaterial2));
    }

    private ContentCryptoMaterial contentCryptoMaterialOf(Map<String, String> map, ObjectMetadata objectMetadata) {
        if (this.storesMetadataInObjectHeader(objectMetadata)) {
            return ContentCryptoMaterial.fromObjectMetadata(map, this.kekMaterialsProvider, this.cryptoConfig, false, this.kms);
        }
        return ContentCryptoMaterial.fromInstructionFile(map, this.kekMaterialsProvider, this.cryptoConfig, false, this.kms);
    }

    private ObjectMetadata getObjectMetadata(S3ObjectId s3ObjectId) {
        GetObjectMetadataRequest getObjectMetadataRequest = new GetObjectMetadataRequest(s3ObjectId.getBucket(), s3ObjectId.getKey());
        ObjectMetadata objectMetadata = this.s3.getObjectMetadata(getObjectMetadataRequest);
        if (objectMetadata == null) {
            throw new IllegalArgumentException("The specified S3 object (" + s3ObjectId + ") doesn't exist.");
        }
        return objectMetadata;
    }

    private Map<String, String> getUserMetadata(S3ObjectId s3ObjectId, ObjectMetadata objectMetadata) {
        if (this.storesMetadataInObjectHeader(objectMetadata)) {
            return objectMetadata.getUserMetadata();
        }
        return this.getInstructionFileMetadata(s3ObjectId);
    }

    private boolean storesMetadataInObjectHeader(ObjectMetadata objectMetadata) {
        Map<String, String> map = objectMetadata.getUserMetadata();
        if (map == null) {
            return false;
        }
        return map.containsKey("x-amz-iv") && (map.containsKey("x-amz-key-v2") || map.containsKey("x-amz-key"));
    }

    private Map<String, String> getInstructionFileMetadata(S3ObjectId s3ObjectId) {
        S3ObjectWrapper s3ObjectWrapper = this.fetchInstructionFile(s3ObjectId, null);
        if (s3ObjectWrapper == null) {
            throw new IllegalArgumentException("S3 object is not encrypted: " + s3ObjectId);
        }
        String string = s3ObjectWrapper.toJsonString();
        return Collections.unmodifiableMap(Jackson.stringMapFromJsonString(string));
    }

    final GetObjectRequest createInstructionGetRequest(S3ObjectId s3ObjectId) {
        return this.createInstructionGetRequest(s3ObjectId, null);
    }

    final GetObjectRequest createInstructionGetRequest(S3ObjectId s3ObjectId, String string) {
        return new GetObjectRequest(s3ObjectId.instructionFileId(string));
    }

    static long[] getAdjustedCryptoRange(long[] lArray) {
        if (lArray == null || lArray[0] > lArray[1]) {
            return null;
        }
        long[] lArray2 = new long[]{S3CryptoModuleBase.getCipherBlockLowerBound(lArray[0]), S3CryptoModuleBase.getCipherBlockUpperBound(lArray[1])};
        return lArray2;
    }

    private static long getCipherBlockLowerBound(long l) {
        long l2 = 16L;
        long l3 = l % l2;
        long l4 = l - l3 - l2;
        return l4 < 0L ? 0L : l4;
    }

    private static long getCipherBlockUpperBound(long l) {
        long l2 = 16L;
        long l3 = l2 - l % l2;
        long l4 = l + l3 + l2;
        return l4 < 0L ? Long.MAX_VALUE : l4;
    }
}

