/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.KMSEncryptionMaterials;
import com.amazonaws.services.s3.model.MaterialsDescriptionProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class KMSMaterialsHandler {
    public static Map<String, String> createKMSContextMaterialsDescription(Map<String, String> map, String string) {
        if (map.containsKey("aws:x-amz-cek-alg")) {
            throw new SecurityException("Conflict in reserved KMS Encryption Context key aws:x-amz-cek-alg. This value is reserved for the S3 Encryption Client and cannot be set by the user.");
        }
        map.put("aws:x-amz-cek-alg", string);
        map.remove("kms_cmk_id");
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> mergeMaterialsDescription(KMSEncryptionMaterials kMSEncryptionMaterials, AmazonWebServiceRequest amazonWebServiceRequest) {
        MaterialsDescriptionProvider materialsDescriptionProvider;
        Map<String, String> map;
        Map<String, String> map2 = kMSEncryptionMaterials.getMaterialsDescription();
        if (amazonWebServiceRequest instanceof MaterialsDescriptionProvider && (map = (materialsDescriptionProvider = (MaterialsDescriptionProvider)((Object)amazonWebServiceRequest)).getMaterialsDescription()) != null) {
            map2 = new TreeMap<String, String>(map2);
            map2.putAll(map);
        }
        return map2;
    }

    public static boolean isValidV2Description(Map<String, String> map, Map<String, String> map2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(map2);
        hashMap.remove("kms_cmk_id");
        hashMap2.remove("aws:x-amz-cek-alg");
        return hashMap.equals(hashMap2);
    }

    public static boolean isValidV1Description(Map<String, String> map, Map<String, String> map2) {
        return map.equals(map2);
    }
}

