/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.s3.KeyWrapException;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.CryptoUtils;
import com.amazonaws.services.s3.internal.crypto.keywrap.InternalKeyWrapAlgorithm;
import com.amazonaws.services.s3.internal.crypto.keywrap.KMSKeyWrapperContext;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapAlgorithmResolver;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapper;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapperContext;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapperFactory;
import com.amazonaws.services.s3.internal.crypto.v2.KMSMaterialsHandler;
import com.amazonaws.services.s3.internal.crypto.v2.SecuredCEK;
import com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazonaws.services.s3.model.CryptoKeyWrapAlgorithm;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.CryptoRangeGetMode;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ExtraMaterialsDescription;
import com.amazonaws.services.s3.model.KMSEncryptionMaterials;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutInstructionFileRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.Throwables;
import com.amazonaws.util.json.Jackson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ContentCryptoMaterial {
    private final InternalKeyWrapAlgorithm keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;

    ContentCryptoMaterial(Map<String, String> map, byte[] byArray, InternalKeyWrapAlgorithm internalKeyWrapAlgorithm, CipherLite cipherLite) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = internalKeyWrapAlgorithm;
        this.encryptedCEK = (byte[])byArray.clone();
        this.kekMaterialsDescription = map;
    }

    InternalKeyWrapAlgorithm getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata objectMetadata) {
        InternalKeyWrapAlgorithm internalKeyWrapAlgorithm;
        byte[] byArray = this.getEncryptedCEK();
        objectMetadata.addUserMetadata("x-amz-key-v2", Base64.encodeAsString(byArray));
        byte[] byArray2 = this.cipherLite.getIV();
        objectMetadata.addUserMetadata("x-amz-iv", Base64.encodeAsString(byArray2));
        objectMetadata.addUserMetadata("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme contentCryptoScheme = this.getContentCryptoScheme();
        objectMetadata.addUserMetadata("x-amz-cek-alg", contentCryptoScheme.getCipherAlgorithm());
        int n = contentCryptoScheme.getTagLengthInBits();
        if (n > 0) {
            objectMetadata.addUserMetadata("x-amz-tag-len", String.valueOf(n));
        }
        if ((internalKeyWrapAlgorithm = this.getKeyWrappingAlgorithm()) != null) {
            objectMetadata.addUserMetadata("x-amz-wrap-alg", internalKeyWrapAlgorithm.algorithmName());
        }
        return objectMetadata;
    }

    String toJsonString() {
        InternalKeyWrapAlgorithm internalKeyWrapAlgorithm;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte[] byArray = this.getEncryptedCEK();
        hashMap.put("x-amz-key-v2", Base64.encodeAsString(byArray));
        byte[] byArray2 = this.cipherLite.getIV();
        hashMap.put("x-amz-iv", Base64.encodeAsString(byArray2));
        hashMap.put("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme contentCryptoScheme = this.getContentCryptoScheme();
        hashMap.put("x-amz-cek-alg", contentCryptoScheme.getCipherAlgorithm());
        int n = contentCryptoScheme.getTagLengthInBits();
        if (n > 0) {
            hashMap.put("x-amz-tag-len", String.valueOf(n));
        }
        if ((internalKeyWrapAlgorithm = this.getKeyWrappingAlgorithm()) != null) {
            hashMap.put("x-amz-wrap-alg", internalKeyWrapAlgorithm.algorithmName());
        }
        return Jackson.toJsonString(hashMap);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> map = this.getKEKMaterialsDescription();
        if (map == null) {
            map = Collections.emptyMap();
        }
        return Jackson.toJsonString(map);
    }

    private static Map<String, String> matdescFromJson(String string) {
        Map<String, String> map = Jackson.stringMapFromJsonString(string);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey decryptCEK(KeyWrapperContext keyWrapperContext) {
        if (ContentCryptoMaterial.isV1DecryptContext(keyWrapperContext)) {
            return ContentCryptoMaterial.decryptV1CEK(keyWrapperContext);
        }
        if (keyWrapperContext.internalKeyWrapAlgorithm().isKMS()) {
            ContentCryptoMaterial.validateKMSParameters(keyWrapperContext);
        }
        Key key = ContentCryptoMaterial.getDecryptionKeyFrom(keyWrapperContext.materials());
        String string = keyWrapperContext.internalKeyWrapAlgorithm().isKMS() ? keyWrapperContext.contentCryptoScheme().getKeyGeneratorAlgorithm() : key.getAlgorithm();
        KeyWrapper keyWrapper = KeyWrapperFactory.defaultInstance().createKeyWrapper(keyWrapperContext);
        return new SecretKeySpec(keyWrapper.unwrapCek(keyWrapperContext.cekSecured(), key), string);
    }

    private static boolean isV1DecryptContext(KeyWrapperContext keyWrapperContext) {
        InternalKeyWrapAlgorithm internalKeyWrapAlgorithm = keyWrapperContext.internalKeyWrapAlgorithm();
        return internalKeyWrapAlgorithm == null || internalKeyWrapAlgorithm.isV1Algorithm();
    }

    private static void validateKMSParameters(KeyWrapperContext keyWrapperContext) {
        KMSKeyWrapperContext kMSKeyWrapperContext = keyWrapperContext.kmsKeyWrapperContext();
        if (kMSKeyWrapperContext == null) {
            throw new IllegalStateException("Missing KMS parameters");
        }
        Map<String, String> map = kMSKeyWrapperContext.kmsMaterialsDescription();
        if (map == null) {
            throw new IllegalStateException("Key materials from KMS must contain description entries");
        }
        String string = map.get("aws:x-amz-cek-alg");
        if (string == null) {
            throw new IllegalStateException("Could not find required description in key material: aws:x-amz-cek-alg");
        }
        String string2 = CryptoUtils.normalizeContentAlgorithmForValidation(keyWrapperContext.contentCryptoScheme().getCipherAlgorithm());
        if (!string.equals(string2)) {
            throw new IllegalStateException("Algorithm values from materials and metadata/instruction file don't match:" + string + ", " + string2);
        }
    }

    private static SecretKey decryptV1CEK(KeyWrapperContext keyWrapperContext) {
        InternalKeyWrapAlgorithm internalKeyWrapAlgorithm = keyWrapperContext.internalKeyWrapAlgorithm();
        if (internalKeyWrapAlgorithm != null && internalKeyWrapAlgorithm.isKMS()) {
            return ContentCryptoMaterial.decryptV1CEKByKMS(keyWrapperContext);
        }
        String string = internalKeyWrapAlgorithm != null ? internalKeyWrapAlgorithm.algorithmName() : null;
        Key key = keyWrapperContext.materials().getKeyPair() != null ? keyWrapperContext.materials().getKeyPair().getPrivate() : keyWrapperContext.materials().getSymmetricKey();
        if (key == null) {
            throw new SdkClientException("Key encrypting key not available");
        }
        Provider provider = keyWrapperContext.cryptoProvider();
        try {
            if (string != null) {
                Cipher cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
                cipher.init(4, key);
                return (SecretKey)cipher.unwrap(keyWrapperContext.cekSecured(), string, 3);
            }
            Cipher cipher = provider != null ? Cipher.getInstance(key.getAlgorithm(), provider) : Cipher.getInstance(key.getAlgorithm());
            cipher.init(2, key);
            byte[] byArray = cipher.doFinal(keyWrapperContext.cekSecured());
            return new SecretKeySpec(byArray, "AES");
        }
        catch (Exception exception) {
            throw Throwables.failure(exception, "Unable to decrypt symmetric key from object metadata");
        }
    }

    private static SecretKey decryptV1CEKByKMS(KeyWrapperContext keyWrapperContext) {
        KMSKeyWrapperContext kMSKeyWrapperContext = keyWrapperContext.kmsKeyWrapperContext();
        if (kMSKeyWrapperContext == null) {
            throw new IllegalStateException("Missing KMS parameters");
        }
        String string = keyWrapperContext.materials().getCustomerMasterKeyId();
        if (null == string || string.isEmpty()) {
            throw new IllegalArgumentException("The CMK must be specified to decrypt KMS protected objects");
        }
        DecryptRequest decryptRequest = new DecryptRequest().withEncryptionContext(keyWrapperContext.materials().getMaterialsDescription()).withCiphertextBlob(ByteBuffer.wrap(keyWrapperContext.cekSecured())).withKeyId(string);
        DecryptResult decryptResult = kMSKeyWrapperContext.kms().decrypt(decryptRequest);
        return new SecretKeySpec(BinaryUtils.copyAllBytesFrom(decryptResult.getPlaintext()), keyWrapperContext.contentCryptoScheme().getKeyGeneratorAlgorithm());
    }

    static ContentCryptoMaterial fromObjectMetadata(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, CryptoConfigurationV2 cryptoConfigurationV2, boolean bl, AWSKMS aWSKMS) {
        return ContentCryptoMaterial.fromObjectMetadata0(map, encryptionMaterialsAccessor, cryptoConfigurationV2, null, ExtraMaterialsDescription.NONE, bl, aWSKMS);
    }

    static ContentCryptoMaterial fromObjectMetadata(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, CryptoConfigurationV2 cryptoConfigurationV2, long[] lArray, ExtraMaterialsDescription extraMaterialsDescription, boolean bl, AWSKMS aWSKMS) {
        return ContentCryptoMaterial.fromObjectMetadata0(map, encryptionMaterialsAccessor, cryptoConfigurationV2, lArray, extraMaterialsDescription, bl, aWSKMS);
    }

    private static ContentCryptoMaterial fromObjectMetadata0(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, CryptoConfigurationV2 cryptoConfigurationV2, long[] lArray, ExtraMaterialsDescription extraMaterialsDescription, boolean bl, AWSKMS aWSKMS) {
        Object object;
        int n;
        Map<String, String> map2;
        String string = map.get("x-amz-key-v2");
        if (string == null && (string = map.get("x-amz-key")) == null) {
            throw new SdkClientException("Content encrypting key not found.");
        }
        byte[] byArray = Base64.decode(string);
        byte[] byArray2 = Base64.decode(map.get("x-amz-iv"));
        if (byArray == null || byArray2 == null) {
            throw new SdkClientException("Content encrypting key or IV not found.");
        }
        String string2 = map.get("x-amz-matdesc");
        String string3 = map.get("x-amz-wrap-alg");
        Map<String, String> map3 = ContentCryptoMaterial.matdescFromJson(string2);
        InternalKeyWrapAlgorithm internalKeyWrapAlgorithm = InternalKeyWrapAlgorithm.fromAlgorithmName(string3);
        ContentCryptoMaterial.validateKeyWrapAlgorithmForDecrypt(internalKeyWrapAlgorithm, bl, cryptoConfigurationV2.getCryptoMode());
        boolean bl2 = internalKeyWrapAlgorithm != null && internalKeyWrapAlgorithm.isKMS();
        Map<String, String> map4 = map2 = bl2 || extraMaterialsDescription == null ? map3 : extraMaterialsDescription.mergeInto(map3);
        EncryptionMaterials encryptionMaterials = bl2 ? (encryptionMaterialsAccessor instanceof EncryptionMaterialsProvider ? ((EncryptionMaterialsProvider)encryptionMaterialsAccessor).getEncryptionMaterials() : null) : encryptionMaterialsAccessor.getEncryptionMaterials(map2);
        ContentCryptoMaterial.validateMaterialsForDecrypt(encryptionMaterials, map2, cryptoConfigurationV2.getCryptoMode(), internalKeyWrapAlgorithm);
        String string4 = map.get("x-amz-cek-alg");
        boolean bl3 = lArray != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(string4, bl3);
        if (bl3) {
            ContentCryptoMaterial.assertCryptoSchemeAllowedForRangeGet(contentCryptoScheme, cryptoConfigurationV2.getCryptoMode(), cryptoConfigurationV2.getRangeGetMode());
            byArray2 = contentCryptoScheme.adjustIV(byArray2, lArray[0]);
        } else {
            int n2 = contentCryptoScheme.getTagLengthInBits();
            if (n2 > 0 && n2 != (n = Integer.parseInt((String)(object = map.get("x-amz-tag-len"))))) {
                throw new SdkClientException("Unsupported tag length: " + (int)n + ", expected: " + n2);
            }
        }
        SecretKey secretKey = ContentCryptoMaterial.decryptCEK(KeyWrapperContext.builder().cekSecured(byArray).internalKeyWrapAlgorithm(internalKeyWrapAlgorithm).materials(encryptionMaterials).cryptoProvider(cryptoConfigurationV2.getCryptoProvider()).secureRandom(cryptoConfigurationV2.getSecureRandom()).contentCryptoScheme(contentCryptoScheme).kmsKeyWrapperContext(KMSKeyWrapperContext.builder().kms(aWSKMS).kmsMaterialsDescription(map2).build()).build());
        object = cryptoConfigurationV2.getCryptoProvider();
        n = cryptoConfigurationV2.getAlwaysUseCryptoProvider() ? 1 : 0;
        return new ContentCryptoMaterial(map2, byArray, internalKeyWrapAlgorithm, contentCryptoScheme.createCipherLite(secretKey, byArray2, 2, (Provider)object, n != 0));
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, CryptoConfigurationV2 cryptoConfigurationV2, boolean bl, AWSKMS aWSKMS) {
        return ContentCryptoMaterial.fromInstructionFile0(map, encryptionMaterialsAccessor, cryptoConfigurationV2, null, ExtraMaterialsDescription.NONE, bl, aWSKMS);
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, CryptoConfigurationV2 cryptoConfigurationV2, long[] lArray, ExtraMaterialsDescription extraMaterialsDescription, boolean bl, AWSKMS aWSKMS) {
        return ContentCryptoMaterial.fromInstructionFile0(map, encryptionMaterialsAccessor, cryptoConfigurationV2, lArray, extraMaterialsDescription, bl, aWSKMS);
    }

    private static ContentCryptoMaterial fromInstructionFile0(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, CryptoConfigurationV2 cryptoConfigurationV2, long[] lArray, ExtraMaterialsDescription extraMaterialsDescription, boolean bl, AWSKMS aWSKMS) {
        Map<String, String> map2;
        String string = map.get("x-amz-key-v2");
        if (string == null && (string = map.get("x-amz-key")) == null) {
            throw new SdkClientException("Content encrypting key not found.");
        }
        byte[] byArray = Base64.decode(string);
        byte[] byArray2 = Base64.decode(map.get("x-amz-iv"));
        if (byArray == null || byArray2 == null) {
            throw new SdkClientException("Necessary encryption info not found in the instruction file " + map);
        }
        String string2 = map.get("x-amz-wrap-alg");
        InternalKeyWrapAlgorithm internalKeyWrapAlgorithm = InternalKeyWrapAlgorithm.fromAlgorithmName(string2);
        ContentCryptoMaterial.validateKeyWrapAlgorithmForDecrypt(internalKeyWrapAlgorithm, bl, cryptoConfigurationV2.getCryptoMode());
        boolean bl2 = internalKeyWrapAlgorithm != null && internalKeyWrapAlgorithm.isKMS();
        String string3 = map.get("x-amz-matdesc");
        Map<String, String> map3 = ContentCryptoMaterial.matdescFromJson(string3);
        Map<String, String> map4 = map2 = extraMaterialsDescription == null || bl2 ? map3 : extraMaterialsDescription.mergeInto(map3);
        EncryptionMaterials encryptionMaterials = bl2 ? (encryptionMaterialsAccessor instanceof EncryptionMaterialsProvider ? ((EncryptionMaterialsProvider)encryptionMaterialsAccessor).getEncryptionMaterials() : null) : encryptionMaterialsAccessor.getEncryptionMaterials(map2);
        ContentCryptoMaterial.validateMaterialsForDecrypt(encryptionMaterials, map2, cryptoConfigurationV2.getCryptoMode(), internalKeyWrapAlgorithm);
        String string4 = map.get("x-amz-cek-alg");
        boolean bl3 = lArray != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(string4, bl3);
        if (bl3) {
            ContentCryptoMaterial.assertCryptoSchemeAllowedForRangeGet(contentCryptoScheme, cryptoConfigurationV2.getCryptoMode(), cryptoConfigurationV2.getRangeGetMode());
            byArray2 = contentCryptoScheme.adjustIV(byArray2, lArray[0]);
        } else {
            String string5;
            int n;
            int n2 = contentCryptoScheme.getTagLengthInBits();
            if (n2 > 0 && n2 != (n = Integer.parseInt(string5 = map.get("x-amz-tag-len")))) {
                throw new SdkClientException("Unsupported tag length: " + n + ", expected: " + n2);
            }
        }
        SecretKey secretKey = ContentCryptoMaterial.decryptCEK(KeyWrapperContext.builder().cekSecured(byArray).internalKeyWrapAlgorithm(internalKeyWrapAlgorithm).materials(encryptionMaterials).cryptoProvider(cryptoConfigurationV2.getCryptoProvider()).secureRandom(cryptoConfigurationV2.getSecureRandom()).contentCryptoScheme(contentCryptoScheme).kmsKeyWrapperContext(KMSKeyWrapperContext.builder().kms(aWSKMS).kmsMaterialsDescription(map2).build()).build());
        return new ContentCryptoMaterial(map2, byArray, internalKeyWrapAlgorithm, contentCryptoScheme.createCipherLite(secretKey, byArray2, 2, cryptoConfigurationV2.getCryptoProvider(), cryptoConfigurationV2.getAlwaysUseCryptoProvider()));
    }

    static String parseInstructionFile(S3Object s3Object) {
        try {
            return ContentCryptoMaterial.convertStreamToString(s3Object.getObjectContent());
        }
        catch (Exception exception) {
            throw Throwables.failure(exception, "Error parsing JSON instruction file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream2) throws IOException {
        if (inputStream2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, StringUtils.UTF8));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        finally {
            inputStream2.close();
        }
        return stringBuilder.toString();
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }

    ContentCryptoMaterial recreate(EncryptionMaterialsAccessor encryptionMaterialsAccessor, CryptoConfigurationV2 cryptoConfigurationV2, String string, AWSKMS aWSKMS, PutInstructionFileRequest putInstructionFileRequest) {
        EncryptionMaterials encryptionMaterials = this.getNewEncryptionMaterials(putInstructionFileRequest, encryptionMaterialsAccessor);
        if (!InternalKeyWrapAlgorithm.KMS.equals((Object)this.keyWrappingAlgorithm) && encryptionMaterials.getMaterialsDescription().equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        if (InternalKeyWrapAlgorithm.KMS.equals((Object)this.keyWrappingAlgorithm)) {
            throw new SdkClientException("Recreating KMS encrypted CEK is not supported.");
        }
        EncryptionMaterials encryptionMaterials2 = encryptionMaterialsAccessor.getEncryptionMaterials(this.kekMaterialsDescription);
        ContentCryptoMaterial.validateKeyWrapAlgorithmForDecrypt(this.keyWrappingAlgorithm, cryptoConfigurationV2.getCryptoMode());
        InternalKeyWrapAlgorithm internalKeyWrapAlgorithm = InternalKeyWrapAlgorithm.fromAlgorithmName(string);
        SecretKey secretKey = ContentCryptoMaterial.decryptCEK(KeyWrapperContext.builder().cekSecured(this.encryptedCEK).internalKeyWrapAlgorithm(internalKeyWrapAlgorithm).materials(encryptionMaterials2).cryptoProvider(cryptoConfigurationV2.getCryptoProvider()).secureRandom(cryptoConfigurationV2.getSecureRandom()).contentCryptoScheme(this.getContentCryptoScheme()).kmsKeyWrapperContext(KMSKeyWrapperContext.builder().kms(aWSKMS).build()).build());
        ContentCryptoMaterial contentCryptoMaterial = ContentCryptoMaterial.create(secretKey, this.cipherLite.getIV(), encryptionMaterials, this.getContentCryptoScheme(), cryptoConfigurationV2, aWSKMS, putInstructionFileRequest);
        if (Arrays.equals(contentCryptoMaterial.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return contentCryptoMaterial;
    }

    private EncryptionMaterials getNewEncryptionMaterials(PutInstructionFileRequest putInstructionFileRequest, EncryptionMaterialsAccessor encryptionMaterialsAccessor) {
        EncryptionMaterials encryptionMaterials = putInstructionFileRequest.getEncryptionMaterials();
        if (encryptionMaterials == null) {
            Map<String, String> map = putInstructionFileRequest.getMaterialsDescription();
            encryptionMaterials = encryptionMaterialsAccessor.getEncryptionMaterials(map);
        }
        if (encryptionMaterials == null) {
            throw new SdkClientException("No material available with the description " + putInstructionFileRequest.getMaterialsDescription() + " from the encryption material provider");
        }
        return encryptionMaterials;
    }

    static ContentCryptoMaterial create(SecretKey secretKey, byte[] byArray, EncryptionMaterials encryptionMaterials, ContentCryptoScheme contentCryptoScheme, CryptoConfigurationV2 cryptoConfigurationV2, AWSKMS aWSKMS, AmazonWebServiceRequest amazonWebServiceRequest) {
        KeyWrapperContext keyWrapperContext = ContentCryptoMaterial.createEncryptionKeyWrapperContext(encryptionMaterials, contentCryptoScheme, cryptoConfigurationV2, aWSKMS, amazonWebServiceRequest);
        SecuredCEK securedCEK = ContentCryptoMaterial.encryptCEK(secretKey, keyWrapperContext);
        return ContentCryptoMaterial.wrap(secretKey, byArray, contentCryptoScheme, cryptoConfigurationV2.getCryptoProvider(), cryptoConfigurationV2.getAlwaysUseCryptoProvider(), securedCEK);
    }

    private static KeyWrapperContext createEncryptionKeyWrapperContext(EncryptionMaterials encryptionMaterials, ContentCryptoScheme contentCryptoScheme, CryptoConfigurationV2 cryptoConfigurationV2, AWSKMS aWSKMS, AmazonWebServiceRequest amazonWebServiceRequest) {
        CryptoKeyWrapAlgorithm cryptoKeyWrapAlgorithm = KeyWrapAlgorithmResolver.getDefaultKeyWrapAlgorithm(encryptionMaterials);
        InternalKeyWrapAlgorithm internalKeyWrapAlgorithm = InternalKeyWrapAlgorithm.fromExternal(cryptoKeyWrapAlgorithm);
        if (encryptionMaterials.isKMSEnabled()) {
            Map<String, String> map = KMSMaterialsHandler.createKMSContextMaterialsDescription(KMSMaterialsHandler.mergeMaterialsDescription((KMSEncryptionMaterials)encryptionMaterials, amazonWebServiceRequest), contentCryptoScheme.getCipherAlgorithm());
            KMSKeyWrapperContext kMSKeyWrapperContext = KMSKeyWrapperContext.builder().kms(aWSKMS).kmsMaterialsDescription(map).originalRequest(amazonWebServiceRequest).build();
            return KeyWrapperContext.builder().cryptoProvider(cryptoConfigurationV2.getCryptoProvider()).secureRandom(cryptoConfigurationV2.getSecureRandom()).materials(encryptionMaterials).internalKeyWrapAlgorithm(internalKeyWrapAlgorithm).kmsKeyWrapperContext(kMSKeyWrapperContext).contentCryptoScheme(contentCryptoScheme).build();
        }
        return KeyWrapperContext.builder().cryptoProvider(cryptoConfigurationV2.getCryptoProvider()).secureRandom(cryptoConfigurationV2.getSecureRandom()).materials(encryptionMaterials).internalKeyWrapAlgorithm(internalKeyWrapAlgorithm).contentCryptoScheme(contentCryptoScheme).build();
    }

    static ContentCryptoMaterial wrap(SecretKey secretKey, byte[] byArray, ContentCryptoScheme contentCryptoScheme, Provider provider, boolean bl, SecuredCEK securedCEK) {
        return new ContentCryptoMaterial(securedCEK.getMaterialDescription(), securedCEK.getEncrypted(), securedCEK.getKeyWrapAlgorithm(), contentCryptoScheme.createCipherLite(secretKey, byArray, 1, provider, bl));
    }

    private static SecuredCEK encryptCEK(SecretKey secretKey, KeyWrapperContext keyWrapperContext) {
        EncryptionMaterials encryptionMaterials = keyWrapperContext.materials();
        ContentCryptoMaterial.validateKeyWrapAlgorithmForEncrypt(encryptionMaterials, keyWrapperContext.internalKeyWrapAlgorithm());
        Key key = ContentCryptoMaterial.getEncryptionKeyFrom(encryptionMaterials);
        Map<String, String> map = encryptionMaterials.isKMSEnabled() ? keyWrapperContext.kmsKeyWrapperContext().kmsMaterialsDescription() : encryptionMaterials.getMaterialsDescription();
        KeyWrapper keyWrapper = KeyWrapperFactory.defaultInstance().createKeyWrapper(keyWrapperContext);
        return new SecuredCEK(keyWrapper.wrapCek(secretKey.getEncoded(), key), keyWrapperContext.internalKeyWrapAlgorithm(), map);
    }

    private static Key getEncryptionKeyFrom(EncryptionMaterials encryptionMaterials) {
        if (encryptionMaterials.isKMSEnabled()) {
            return null;
        }
        return encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPublic() : encryptionMaterials.getSymmetricKey();
    }

    private static Key getDecryptionKeyFrom(EncryptionMaterials encryptionMaterials) {
        if (encryptionMaterials.isKMSEnabled()) {
            return null;
        }
        return encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPrivate() : encryptionMaterials.getSymmetricKey();
    }

    private static void validateKeyWrapAlgorithmForEncrypt(EncryptionMaterials encryptionMaterials, InternalKeyWrapAlgorithm internalKeyWrapAlgorithm) {
        if (encryptionMaterials.isKMSEnabled()) {
            ContentCryptoMaterial.validateKMSKeyWrapAlgorithmForEncrypt(encryptionMaterials, internalKeyWrapAlgorithm);
            return;
        }
        if (encryptionMaterials.getKeyPair() != null && !internalKeyWrapAlgorithm.isAsymmetric()) {
            throw new IllegalStateException(String.format("Encryption materials with asymmetric keys are not consistent with selected key wrap algorithm %s.", new Object[]{internalKeyWrapAlgorithm}));
        }
        if (encryptionMaterials.getSymmetricKey() != null && !internalKeyWrapAlgorithm.isSymmetric()) {
            throw new IllegalStateException(String.format("Encryption materials with a symmetric key are not consistent with selected key wrap algorithm %s.", new Object[]{internalKeyWrapAlgorithm}));
        }
    }

    private static void validateKMSKeyWrapAlgorithmForEncrypt(EncryptionMaterials encryptionMaterials, InternalKeyWrapAlgorithm internalKeyWrapAlgorithm) {
        if (!InternalKeyWrapAlgorithm.KMS.equals((Object)internalKeyWrapAlgorithm)) {
            throw new IllegalStateException(String.format("KMS enabled encryption materials are not consistent with selected key wrap algorithm %s.", new Object[]{internalKeyWrapAlgorithm}));
        }
    }

    private static void validateKeyWrapAlgorithmForDecrypt(InternalKeyWrapAlgorithm internalKeyWrapAlgorithm, CryptoMode cryptoMode) {
        ContentCryptoMaterial.validateKeyWrapAlgorithmForDecrypt(internalKeyWrapAlgorithm, false, cryptoMode);
    }

    private static void validateKeyWrapAlgorithmForDecrypt(InternalKeyWrapAlgorithm internalKeyWrapAlgorithm, boolean bl, CryptoMode cryptoMode) {
        if (CryptoMode.StrictAuthenticatedEncryption.equals((Object)cryptoMode)) {
            if (internalKeyWrapAlgorithm == null) {
                throw new KeyWrapException("No key wrap algorithm detected. Use crypto mode " + (Object)((Object)CryptoMode.AuthenticatedEncryption) + " to decrypt object.");
            }
            if (internalKeyWrapAlgorithm.isV1Algorithm()) {
                throw new KeyWrapException("Detected key wrap algorithm used with previous version of client. Use crypto mode " + (Object)((Object)CryptoMode.AuthenticatedEncryption) + " to decrypt object.");
            }
        } else if (bl && internalKeyWrapAlgorithm == null) {
            throw new KeyWrapException("Key wrap expected, but no key wrap algorithm was found.");
        }
    }

    private static void validateMaterialsForDecrypt(EncryptionMaterials encryptionMaterials, Map<String, String> map, CryptoMode cryptoMode, InternalKeyWrapAlgorithm internalKeyWrapAlgorithm) {
        if (encryptionMaterials == null) {
            throw new SdkClientException("Unable to retrieve the client encryption materials");
        }
        if (internalKeyWrapAlgorithm == null || !internalKeyWrapAlgorithm.isKMS()) {
            return;
        }
        if (!internalKeyWrapAlgorithm.isV1Algorithm() && KMSMaterialsHandler.isValidV2Description(encryptionMaterials.getMaterialsDescription(), map)) {
            return;
        }
        boolean bl = KMSMaterialsHandler.isValidV1Description(encryptionMaterials.getMaterialsDescription(), map);
        if (internalKeyWrapAlgorithm.isV1Algorithm() && bl) {
            if (CryptoMode.AuthenticatedEncryption.equals((Object)cryptoMode)) {
                return;
            }
            throw new IllegalStateException("A previous version of the client may have been used to encrypt key via KMS. Use crypto mode " + (Object)((Object)CryptoMode.AuthenticatedEncryption) + " to decrypt object.");
        }
        throw new IllegalStateException("Provided encryption materials do not match information retrieved from the encrypted object");
    }

    private static void assertCryptoSchemeAllowedForRangeGet(ContentCryptoScheme contentCryptoScheme, CryptoMode cryptoMode, CryptoRangeGetMode cryptoRangeGetMode) {
        if (!cryptoRangeGetMode.permitsCipherAlgorithm(cryptoMode, contentCryptoScheme.getCipherAlgorithm())) {
            if (CryptoRangeGetMode.DISABLED.equals((Object)cryptoRangeGetMode)) {
                throw new SecurityException("Unable to perform range get request: Range get support has been disabled. See https://docs.aws.amazon.com/general/latest/gr/aws_sdk_cryptography.html");
            }
            throw new SecurityException("Range get support is not enabled for this content encryption type. Use " + (Object)((Object)CryptoMode.AuthenticatedEncryption) + " instead. See https://docs.aws.amazon.com/general/latest/gr/aws_sdk_cryptography.html");
        }
    }
}

