/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v1;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.internal.SdkFilterInputStream;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.ByteRangeCapturingInputStream;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import com.amazonaws.services.s3.internal.crypto.v1.ContentCryptoMaterial;
import com.amazonaws.services.s3.internal.crypto.v1.MultipartUploadCbcContext;
import com.amazonaws.services.s3.internal.crypto.v1.S3CryptoModuleBase;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.File;

class S3CryptoModuleEO
extends S3CryptoModuleBase<MultipartUploadCbcContext> {
    S3CryptoModuleEO(AWSKMS aWSKMS, S3Direct s3Direct, AWSCredentialsProvider aWSCredentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        super(aWSKMS, s3Direct, aWSCredentialsProvider, encryptionMaterialsProvider, cryptoConfiguration);
        if (cryptoConfiguration.getCryptoMode() != CryptoMode.EncryptionOnly) {
            throw new IllegalArgumentException();
        }
    }

    S3CryptoModuleEO(S3Direct s3Direct, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        this(null, s3Direct, new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, cryptoConfiguration);
    }

    S3CryptoModuleEO(AWSKMS aWSKMS, S3Direct s3Direct, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfiguration) {
        this(aWSKMS, s3Direct, new DefaultAWSCredentialsProviderChain(), encryptionMaterialsProvider, cryptoConfiguration);
    }

    @Override
    public S3Object getObjectSecurely(GetObjectRequest getObjectRequest) {
        throw new IllegalStateException();
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File file) {
        throw new IllegalStateException();
    }

    @Override
    final MultipartUploadCbcContext newUploadContext(InitiateMultipartUploadRequest initiateMultipartUploadRequest, ContentCryptoMaterial contentCryptoMaterial) {
        MultipartUploadCbcContext multipartUploadCbcContext = new MultipartUploadCbcContext(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), contentCryptoMaterial);
        byte[] byArray = contentCryptoMaterial.getCipherLite().getIV();
        multipartUploadCbcContext.setNextInitializationVector(byArray);
        return multipartUploadCbcContext;
    }

    @Override
    final void updateUploadContext(MultipartUploadCbcContext multipartUploadCbcContext, SdkFilterInputStream sdkFilterInputStream) {
        ByteRangeCapturingInputStream byteRangeCapturingInputStream = (ByteRangeCapturingInputStream)sdkFilterInputStream;
        multipartUploadCbcContext.setNextInitializationVector(byteRangeCapturingInputStream.getBlock());
    }

    final ByteRangeCapturingInputStream wrapForMultipart(CipherLiteInputStream cipherLiteInputStream, long l) {
        int n = this.contentCryptoScheme.getBlockSizeInBytes();
        return new ByteRangeCapturingInputStream(cipherLiteInputStream, l - (long)n, l);
    }

    @Override
    final long computeLastPartSize(UploadPartRequest uploadPartRequest) {
        long l;
        if (uploadPartRequest.getFile() != null) {
            l = uploadPartRequest.getPartSize() > 0L ? uploadPartRequest.getPartSize() : uploadPartRequest.getFile().length();
        } else if (uploadPartRequest.getInputStream() != null) {
            l = uploadPartRequest.getPartSize();
        } else {
            return -1L;
        }
        long l2 = this.contentCryptoScheme.getBlockSizeInBytes();
        long l3 = l2 - l % l2;
        return l + l3;
    }

    @Override
    final CipherLite cipherLiteForNextPart(MultipartUploadCbcContext multipartUploadCbcContext) {
        CipherLite cipherLite = multipartUploadCbcContext.getCipherLite();
        byte[] byArray = multipartUploadCbcContext.getNextInitializationVector();
        return cipherLite.createUsingIV(byArray);
    }

    @Override
    protected final long ciphertextLength(long l) {
        long l2 = this.contentCryptoScheme.getBlockSizeInBytes();
        long l3 = l2 - l % l2;
        return l + l3;
    }
}

