/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto.v1;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.SdkClientException;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.model.DecryptRequest;
import com.amazonaws.services.kms.model.DecryptResult;
import com.amazonaws.services.kms.model.EncryptRequest;
import com.amazonaws.services.kms.model.EncryptResult;
import com.amazonaws.services.s3.KeyWrapException;
import com.amazonaws.services.s3.internal.crypto.CipherLite;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.CryptoUtils;
import com.amazonaws.services.s3.internal.crypto.keywrap.InternalKeyWrapAlgorithm;
import com.amazonaws.services.s3.internal.crypto.keywrap.KMSKeyWrapperContext;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapper;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapperContext;
import com.amazonaws.services.s3.internal.crypto.keywrap.KeyWrapperFactory;
import com.amazonaws.services.s3.internal.crypto.v1.KMSMaterialsHandler;
import com.amazonaws.services.s3.internal.crypto.v1.KMSSecuredCEK;
import com.amazonaws.services.s3.internal.crypto.v1.S3CryptoScheme;
import com.amazonaws.services.s3.internal.crypto.v1.S3KeyWrapScheme;
import com.amazonaws.services.s3.internal.crypto.v1.SecuredCEK;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.ExtraMaterialsDescription;
import com.amazonaws.services.s3.model.KMSEncryptionMaterials;
import com.amazonaws.services.s3.model.MaterialsDescriptionProvider;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.util.Base64;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.Throwables;
import com.amazonaws.util.json.Jackson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ContentCryptoMaterial {
    private final String keyWrappingAlgorithm;
    private final CipherLite cipherLite;
    private final Map<String, String> kekMaterialsDescription;
    private final byte[] encryptedCEK;

    ContentCryptoMaterial(Map<String, String> map, byte[] byArray, String string, CipherLite cipherLite) {
        this.cipherLite = cipherLite;
        this.keyWrappingAlgorithm = string;
        this.encryptedCEK = (byte[])byArray.clone();
        this.kekMaterialsDescription = map;
    }

    String getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    private boolean usesKMSKey() {
        return KMSSecuredCEK.isKMSKeyWrapped(this.keyWrappingAlgorithm);
    }

    ContentCryptoScheme getContentCryptoScheme() {
        return this.cipherLite.getContentCryptoScheme();
    }

    ObjectMetadata toObjectMetadata(ObjectMetadata objectMetadata, CryptoMode cryptoMode) {
        return cryptoMode == CryptoMode.EncryptionOnly && !this.usesKMSKey() ? this.toObjectMetadataEO(objectMetadata) : this.toObjectMetadata(objectMetadata);
    }

    private ObjectMetadata toObjectMetadata(ObjectMetadata objectMetadata) {
        String string;
        byte[] byArray = this.getEncryptedCEK();
        objectMetadata.addUserMetadata("x-amz-key-v2", Base64.encodeAsString(byArray));
        byte[] byArray2 = this.cipherLite.getIV();
        objectMetadata.addUserMetadata("x-amz-iv", Base64.encodeAsString(byArray2));
        objectMetadata.addUserMetadata("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme contentCryptoScheme = this.getContentCryptoScheme();
        objectMetadata.addUserMetadata("x-amz-cek-alg", contentCryptoScheme.getCipherAlgorithm());
        int n = contentCryptoScheme.getTagLengthInBits();
        if (n > 0) {
            objectMetadata.addUserMetadata("x-amz-tag-len", String.valueOf(n));
        }
        if ((string = this.getKeyWrappingAlgorithm()) != null) {
            objectMetadata.addUserMetadata("x-amz-wrap-alg", string);
        }
        return objectMetadata;
    }

    private ObjectMetadata toObjectMetadataEO(ObjectMetadata objectMetadata) {
        byte[] byArray = this.getEncryptedCEK();
        objectMetadata.addUserMetadata("x-amz-key", Base64.encodeAsString(byArray));
        byte[] byArray2 = this.cipherLite.getIV();
        objectMetadata.addUserMetadata("x-amz-iv", Base64.encodeAsString(byArray2));
        objectMetadata.addUserMetadata("x-amz-matdesc", this.kekMaterialDescAsJson());
        return objectMetadata;
    }

    String toJsonString(CryptoMode cryptoMode) {
        return cryptoMode == CryptoMode.EncryptionOnly && !this.usesKMSKey() ? this.toJsonStringEO() : this.toJsonString();
    }

    private String toJsonString() {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte[] byArray = this.getEncryptedCEK();
        hashMap.put("x-amz-key-v2", Base64.encodeAsString(byArray));
        byte[] byArray2 = this.cipherLite.getIV();
        hashMap.put("x-amz-iv", Base64.encodeAsString(byArray2));
        hashMap.put("x-amz-matdesc", this.kekMaterialDescAsJson());
        ContentCryptoScheme contentCryptoScheme = this.getContentCryptoScheme();
        hashMap.put("x-amz-cek-alg", contentCryptoScheme.getCipherAlgorithm());
        int n = contentCryptoScheme.getTagLengthInBits();
        if (n > 0) {
            hashMap.put("x-amz-tag-len", String.valueOf(n));
        }
        if ((string = this.getKeyWrappingAlgorithm()) != null) {
            hashMap.put("x-amz-wrap-alg", string);
        }
        return Jackson.toJsonString(hashMap);
    }

    private String toJsonStringEO() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte[] byArray = this.getEncryptedCEK();
        hashMap.put("x-amz-key", Base64.encodeAsString(byArray));
        byte[] byArray2 = this.cipherLite.getIV();
        hashMap.put("x-amz-iv", Base64.encodeAsString(byArray2));
        hashMap.put("x-amz-matdesc", this.kekMaterialDescAsJson());
        return Jackson.toJsonString(hashMap);
    }

    private String kekMaterialDescAsJson() {
        Map<String, String> map = this.getKEKMaterialsDescription();
        if (map == null) {
            map = Collections.emptyMap();
        }
        return Jackson.toJsonString(map);
    }

    private static Map<String, String> matdescFromJson(String string) {
        Map<String, String> map = Jackson.stringMapFromJsonString(string);
        return map == null ? null : Collections.unmodifiableMap(map);
    }

    private static SecretKey cek(byte[] byArray, String string, EncryptionMaterials encryptionMaterials, Provider provider, ContentCryptoScheme contentCryptoScheme, AWSKMS aWSKMS) {
        Key key;
        InternalKeyWrapAlgorithm internalKeyWrapAlgorithm = InternalKeyWrapAlgorithm.fromAlgorithmName(string);
        if (internalKeyWrapAlgorithm != null && !internalKeyWrapAlgorithm.isV1Algorithm()) {
            Object object;
            KMSKeyWrapperContext kMSKeyWrapperContext = null;
            if (internalKeyWrapAlgorithm.isKMS()) {
                object = KMSMaterialsHandler.createKMSContextMaterialsDescription(encryptionMaterials.getMaterialsDescription(), contentCryptoScheme.getCipherAlgorithm());
                kMSKeyWrapperContext = KMSKeyWrapperContext.builder().kms(aWSKMS).kmsMaterialsDescription((Map<String, String>)object).build();
            }
            object = KeyWrapperContext.builder().cryptoProvider(provider).internalKeyWrapAlgorithm(internalKeyWrapAlgorithm).materials(encryptionMaterials).cekSecured(byArray).contentCryptoScheme(contentCryptoScheme).kmsKeyWrapperContext(kMSKeyWrapperContext).build();
            return ContentCryptoMaterial.cekV2((KeyWrapperContext)object);
        }
        if (KMSSecuredCEK.isKMSKeyWrapped(string)) {
            return ContentCryptoMaterial.cekByKMS(byArray, string, encryptionMaterials, contentCryptoScheme, aWSKMS);
        }
        if (encryptionMaterials.getKeyPair() != null ? (key = encryptionMaterials.getKeyPair().getPrivate()) == null : (key = encryptionMaterials.getSymmetricKey()) == null) {
            throw new SdkClientException("Key encrypting key not available");
        }
        try {
            if (string != null) {
                Cipher cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
                cipher.init(4, key);
                return (SecretKey)cipher.unwrap(byArray, string, 3);
            }
            Cipher cipher = provider != null ? Cipher.getInstance(key.getAlgorithm(), provider) : Cipher.getInstance(key.getAlgorithm());
            cipher.init(2, key);
            byte[] byArray2 = cipher.doFinal(byArray);
            return new SecretKeySpec(byArray2, "AES");
        }
        catch (Exception exception) {
            throw Throwables.failure(exception, "Unable to decrypt symmetric key from object metadata");
        }
    }

    private static SecretKey cekV2(KeyWrapperContext keyWrapperContext) {
        if (keyWrapperContext.internalKeyWrapAlgorithm().isKMS()) {
            ContentCryptoMaterial.validateKMSParameters(keyWrapperContext);
        }
        Key key = ContentCryptoMaterial.getDecryptionKeyFrom(keyWrapperContext.materials());
        String string = keyWrapperContext.internalKeyWrapAlgorithm().isKMS() ? keyWrapperContext.contentCryptoScheme().getKeyGeneratorAlgorithm() : key.getAlgorithm();
        KeyWrapper keyWrapper = KeyWrapperFactory.defaultInstance().createKeyWrapper(keyWrapperContext);
        return new SecretKeySpec(keyWrapper.unwrapCek(keyWrapperContext.cekSecured(), key), string);
    }

    private static void validateKMSParameters(KeyWrapperContext keyWrapperContext) {
        KMSKeyWrapperContext kMSKeyWrapperContext = keyWrapperContext.kmsKeyWrapperContext();
        if (kMSKeyWrapperContext == null) {
            throw new IllegalStateException("Missing KMS parameters");
        }
        Map<String, String> map = kMSKeyWrapperContext.kmsMaterialsDescription();
        if (map == null) {
            throw new IllegalStateException("Key materials from KMS must contain description entries");
        }
        String string = map.get("aws:x-amz-cek-alg");
        if (string == null) {
            throw new IllegalStateException("Could not find required description in key material: aws:x-amz-cek-alg");
        }
        String string2 = CryptoUtils.normalizeContentAlgorithmForValidation(keyWrapperContext.contentCryptoScheme().getCipherAlgorithm());
        if (!string.equals(string2)) {
            throw new IllegalStateException("Algorithm values from materials and metadata/instruction file don't match:" + string + ", " + string2);
        }
    }

    private static Key getDecryptionKeyFrom(EncryptionMaterials encryptionMaterials) {
        if (encryptionMaterials.isKMSEnabled()) {
            return null;
        }
        return encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPrivate() : encryptionMaterials.getSymmetricKey();
    }

    private static SecretKey cekByKMS(byte[] byArray, String string, EncryptionMaterials encryptionMaterials, ContentCryptoScheme contentCryptoScheme, AWSKMS aWSKMS) {
        DecryptRequest decryptRequest = new DecryptRequest().withEncryptionContext(encryptionMaterials.getMaterialsDescription()).withCiphertextBlob(ByteBuffer.wrap(byArray));
        DecryptResult decryptResult = aWSKMS.decrypt(decryptRequest);
        return new SecretKeySpec(BinaryUtils.copyAllBytesFrom(decryptResult.getPlaintext()), contentCryptoScheme.getKeyGeneratorAlgorithm());
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata objectMetadata, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, boolean bl, boolean bl2, AWSKMS aWSKMS) {
        return ContentCryptoMaterial.fromObjectMetadata0(objectMetadata, encryptionMaterialsAccessor, provider, bl, null, ExtraMaterialsDescription.NONE, bl2, aWSKMS);
    }

    static ContentCryptoMaterial fromObjectMetadata(ObjectMetadata objectMetadata, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, boolean bl, long[] lArray, ExtraMaterialsDescription extraMaterialsDescription, boolean bl2, AWSKMS aWSKMS) {
        return ContentCryptoMaterial.fromObjectMetadata0(objectMetadata, encryptionMaterialsAccessor, provider, bl, lArray, extraMaterialsDescription, bl2, aWSKMS);
    }

    private static ContentCryptoMaterial fromObjectMetadata0(ObjectMetadata objectMetadata, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, boolean bl, long[] lArray, ExtraMaterialsDescription extraMaterialsDescription, boolean bl2, AWSKMS aWSKMS) {
        Map<String, String> map = objectMetadata.getUserMetadata();
        String string = map.get("x-amz-key-v2");
        if (string == null && (string = map.get("x-amz-key")) == null) {
            throw new SdkClientException("Content encrypting key not found.");
        }
        byte[] byArray = Base64.decode(string);
        byte[] byArray2 = Base64.decode(map.get("x-amz-iv"));
        if (byArray == null || byArray2 == null) {
            throw new SdkClientException("Content encrypting key or IV not found.");
        }
        String string2 = map.get("x-amz-matdesc");
        String string3 = map.get("x-amz-wrap-alg");
        Map<String, String> map2 = ContentCryptoMaterial.matdescFromJson(string2);
        boolean bl3 = KMSSecuredCEK.isKMSV1KeyWrapped(string3);
        boolean bl4 = KMSSecuredCEK.isKMSV2KeyWrapped(string3);
        Map<String, String> map3 = bl3 || bl4 || extraMaterialsDescription == null ? map2 : extraMaterialsDescription.mergeInto(map2);
        EncryptionMaterials encryptionMaterials = null;
        if (bl3) {
            if (encryptionMaterials == null) {
                encryptionMaterials = new KMSEncryptionMaterials(map2.get("kms_cmk_id"));
                encryptionMaterials.addDescriptions(map2);
            }
        } else if (bl4) {
            EncryptionMaterials encryptionMaterials2 = encryptionMaterials = encryptionMaterialsAccessor instanceof EncryptionMaterialsProvider ? ((EncryptionMaterialsProvider)encryptionMaterialsAccessor).getEncryptionMaterials() : null;
            if (!(encryptionMaterials instanceof KMSEncryptionMaterials)) {
                throw new SdkClientException("Retrieved materials not of expected type KMSEncryptionMaterials");
            }
        } else {
            encryptionMaterials = encryptionMaterialsAccessor.getEncryptionMaterials(map3);
        }
        if (encryptionMaterials == null) {
            throw new SdkClientException("Unable to retrieve the client encryption materials");
        }
        String string4 = map.get("x-amz-cek-alg");
        boolean bl5 = lArray != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(string4, bl5);
        if (bl5) {
            byArray2 = contentCryptoScheme.adjustIV(byArray2, lArray[0]);
        } else {
            String string5;
            int n;
            int n2 = contentCryptoScheme.getTagLengthInBits();
            if (n2 > 0 && n2 != (n = Integer.parseInt(string5 = map.get("x-amz-tag-len")))) {
                throw new SdkClientException("Unsupported tag length: " + n + ", expected: " + n2);
            }
        }
        if (bl2 && string3 == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey secretKey = ContentCryptoMaterial.cek(byArray, string3, encryptionMaterials, provider, contentCryptoScheme, aWSKMS);
        return new ContentCryptoMaterial(map3, byArray, string3, contentCryptoScheme.createCipherLite(secretKey, byArray2, 2, provider, bl));
    }

    private static KeyWrapException newKeyWrapException() {
        return new KeyWrapException("Missing key-wrap for the content-encrypting-key");
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, boolean bl, boolean bl2, AWSKMS aWSKMS) {
        return ContentCryptoMaterial.fromInstructionFile0(map, encryptionMaterialsAccessor, provider, bl, null, ExtraMaterialsDescription.NONE, bl2, aWSKMS);
    }

    static ContentCryptoMaterial fromInstructionFile(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, boolean bl, long[] lArray, ExtraMaterialsDescription extraMaterialsDescription, boolean bl2, AWSKMS aWSKMS) {
        return ContentCryptoMaterial.fromInstructionFile0(map, encryptionMaterialsAccessor, provider, bl, lArray, extraMaterialsDescription, bl2, aWSKMS);
    }

    private static ContentCryptoMaterial fromInstructionFile0(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, Provider provider, boolean bl, long[] lArray, ExtraMaterialsDescription extraMaterialsDescription, boolean bl2, AWSKMS aWSKMS) {
        String string = map.get("x-amz-key-v2");
        if (string == null && (string = map.get("x-amz-key")) == null) {
            throw new SdkClientException("Content encrypting key not found.");
        }
        byte[] byArray = Base64.decode(string);
        byte[] byArray2 = Base64.decode(map.get("x-amz-iv"));
        if (byArray == null || byArray2 == null) {
            throw new SdkClientException("Necessary encryption info not found in the instruction file " + map);
        }
        String string2 = map.get("x-amz-matdesc");
        String string3 = map.get("x-amz-wrap-alg");
        Map<String, String> map2 = ContentCryptoMaterial.matdescFromJson(string2);
        boolean bl3 = KMSSecuredCEK.isKMSV1KeyWrapped(string3);
        boolean bl4 = KMSSecuredCEK.isKMSV2KeyWrapped(string3);
        Map<String, String> map3 = bl3 || bl4 || extraMaterialsDescription == null ? map2 : extraMaterialsDescription.mergeInto(map2);
        EncryptionMaterials encryptionMaterials = null;
        if (bl3) {
            if (encryptionMaterials == null) {
                encryptionMaterials = new KMSEncryptionMaterials(map2.get("kms_cmk_id"));
                encryptionMaterials.addDescriptions(map2);
            }
        } else if (bl4) {
            EncryptionMaterials encryptionMaterials2 = encryptionMaterials = encryptionMaterialsAccessor instanceof EncryptionMaterialsProvider ? ((EncryptionMaterialsProvider)encryptionMaterialsAccessor).getEncryptionMaterials() : null;
            if (!(encryptionMaterials instanceof KMSEncryptionMaterials)) {
                throw new SdkClientException("Retrieved materials not of expected type KMSEncryptionMaterials");
            }
        } else {
            encryptionMaterials = encryptionMaterialsAccessor.getEncryptionMaterials(map3);
        }
        if (encryptionMaterials == null) {
            throw new SdkClientException("Unable to retrieve the encryption materials that originally encrypted object corresponding to instruction file " + map);
        }
        String string4 = map.get("x-amz-cek-alg");
        boolean bl5 = lArray != null;
        ContentCryptoScheme contentCryptoScheme = ContentCryptoScheme.fromCEKAlgo(string4, bl5);
        if (bl5) {
            byArray2 = contentCryptoScheme.adjustIV(byArray2, lArray[0]);
        } else {
            String string5;
            int n;
            int n2 = contentCryptoScheme.getTagLengthInBits();
            if (n2 > 0 && n2 != (n = Integer.parseInt(string5 = map.get("x-amz-tag-len")))) {
                throw new SdkClientException("Unsupported tag length: " + n + ", expected: " + n2);
            }
        }
        if (bl2 && string3 == null) {
            throw ContentCryptoMaterial.newKeyWrapException();
        }
        SecretKey secretKey = ContentCryptoMaterial.cek(byArray, string3, encryptionMaterials, provider, contentCryptoScheme, aWSKMS);
        return new ContentCryptoMaterial(map3, byArray, string3, contentCryptoScheme.createCipherLite(secretKey, byArray2, 2, provider, bl));
    }

    static String parseInstructionFile(S3Object s3Object) {
        try {
            return ContentCryptoMaterial.convertStreamToString(s3Object.getObjectContent());
        }
        catch (Exception exception) {
            throw Throwables.failure(exception, "Error parsing JSON instruction file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream2) throws IOException {
        if (inputStream2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2, StringUtils.UTF8));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        finally {
            inputStream2.close();
        }
        return stringBuilder.toString();
    }

    CipherLite getCipherLite() {
        return this.cipherLite;
    }

    Map<String, String> getKEKMaterialsDescription() {
        return this.kekMaterialsDescription;
    }

    byte[] getEncryptedCEK() {
        return (byte[])this.encryptedCEK.clone();
    }

    ContentCryptoMaterial recreate(Map<String, String> map, EncryptionMaterialsAccessor encryptionMaterialsAccessor, S3CryptoScheme s3CryptoScheme, CryptoConfiguration cryptoConfiguration, AWSKMS aWSKMS, AmazonWebServiceRequest amazonWebServiceRequest) {
        if (!this.usesKMSKey() && map.equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        EncryptionMaterials encryptionMaterials = this.usesKMSKey() ? new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id")) : encryptionMaterialsAccessor.getEncryptionMaterials(this.kekMaterialsDescription);
        EncryptionMaterials encryptionMaterials2 = encryptionMaterialsAccessor.getEncryptionMaterials(map);
        if (encryptionMaterials2 == null) {
            throw new SdkClientException("No material available with the description " + map + " from the encryption material provider");
        }
        SecretKey secretKey = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, encryptionMaterials, cryptoConfiguration.getCryptoProvider(), this.getContentCryptoScheme(), aWSKMS);
        ContentCryptoMaterial contentCryptoMaterial = ContentCryptoMaterial.create(secretKey, this.cipherLite.getIV(), encryptionMaterials2, this.getContentCryptoScheme(), s3CryptoScheme, cryptoConfiguration, aWSKMS, amazonWebServiceRequest);
        if (Arrays.equals(contentCryptoMaterial.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return contentCryptoMaterial;
    }

    ContentCryptoMaterial recreate(EncryptionMaterials encryptionMaterials, EncryptionMaterialsAccessor encryptionMaterialsAccessor, S3CryptoScheme s3CryptoScheme, CryptoConfiguration cryptoConfiguration, AWSKMS aWSKMS, AmazonWebServiceRequest amazonWebServiceRequest) {
        if (!this.usesKMSKey() && encryptionMaterials.getMaterialsDescription().equals(this.kekMaterialsDescription)) {
            throw new SecurityException("Material description of the new KEK must differ from the current one");
        }
        EncryptionMaterials encryptionMaterials2 = this.usesKMSKey() ? new KMSEncryptionMaterials(this.kekMaterialsDescription.get("kms_cmk_id")) : encryptionMaterialsAccessor.getEncryptionMaterials(this.kekMaterialsDescription);
        SecretKey secretKey = ContentCryptoMaterial.cek(this.encryptedCEK, this.keyWrappingAlgorithm, encryptionMaterials2, cryptoConfiguration.getCryptoProvider(), this.getContentCryptoScheme(), aWSKMS);
        ContentCryptoMaterial contentCryptoMaterial = ContentCryptoMaterial.create(secretKey, this.cipherLite.getIV(), encryptionMaterials, this.getContentCryptoScheme(), s3CryptoScheme, cryptoConfiguration, aWSKMS, amazonWebServiceRequest);
        if (Arrays.equals(contentCryptoMaterial.encryptedCEK, this.encryptedCEK)) {
            throw new SecurityException("The new KEK must differ from the original");
        }
        return contentCryptoMaterial;
    }

    static ContentCryptoMaterial create(SecretKey secretKey, byte[] byArray, EncryptionMaterials encryptionMaterials, ContentCryptoScheme contentCryptoScheme, S3CryptoScheme s3CryptoScheme, CryptoConfiguration cryptoConfiguration, AWSKMS aWSKMS, AmazonWebServiceRequest amazonWebServiceRequest) {
        return ContentCryptoMaterial.doCreate(secretKey, byArray, encryptionMaterials, contentCryptoScheme, s3CryptoScheme, cryptoConfiguration, aWSKMS, amazonWebServiceRequest);
    }

    static ContentCryptoMaterial create(SecretKey secretKey, byte[] byArray, EncryptionMaterials encryptionMaterials, S3CryptoScheme s3CryptoScheme, CryptoConfiguration cryptoConfiguration, AWSKMS aWSKMS, AmazonWebServiceRequest amazonWebServiceRequest) {
        return ContentCryptoMaterial.doCreate(secretKey, byArray, encryptionMaterials, s3CryptoScheme.getContentCryptoScheme(), s3CryptoScheme, cryptoConfiguration, aWSKMS, amazonWebServiceRequest);
    }

    private static ContentCryptoMaterial doCreate(SecretKey secretKey, byte[] byArray, EncryptionMaterials encryptionMaterials, ContentCryptoScheme contentCryptoScheme, S3CryptoScheme s3CryptoScheme, CryptoConfiguration cryptoConfiguration, AWSKMS aWSKMS, AmazonWebServiceRequest amazonWebServiceRequest) {
        SecuredCEK securedCEK = ContentCryptoMaterial.secureCEK(secretKey, encryptionMaterials, s3CryptoScheme.getKeyWrapScheme(), cryptoConfiguration, aWSKMS, amazonWebServiceRequest);
        return ContentCryptoMaterial.wrap(secretKey, byArray, contentCryptoScheme, cryptoConfiguration.getCryptoProvider(), cryptoConfiguration.getAlwaysUseCryptoProvider(), securedCEK);
    }

    public static ContentCryptoMaterial wrap(SecretKey secretKey, byte[] byArray, ContentCryptoScheme contentCryptoScheme, Provider provider, boolean bl, SecuredCEK securedCEK) {
        return new ContentCryptoMaterial(securedCEK.getMaterialDescription(), securedCEK.getEncrypted(), securedCEK.getKeyWrapAlgorithm(), contentCryptoScheme.createCipherLite(secretKey, byArray, 1, provider, bl));
    }

    private static SecuredCEK secureCEK(SecretKey secretKey, EncryptionMaterials encryptionMaterials, S3KeyWrapScheme s3KeyWrapScheme, CryptoConfiguration cryptoConfiguration, AWSKMS aWSKMS, AmazonWebServiceRequest amazonWebServiceRequest) {
        if (encryptionMaterials.isKMSEnabled()) {
            Map<String, String> map = ContentCryptoMaterial.mergeMaterialDescriptions(encryptionMaterials, amazonWebServiceRequest);
            EncryptRequest encryptRequest = new EncryptRequest().withEncryptionContext(map).withKeyId(encryptionMaterials.getCustomerMasterKeyId()).withPlaintext(ByteBuffer.wrap(secretKey.getEncoded()));
            ((AmazonWebServiceRequest)encryptRequest.withGeneralProgressListener(amazonWebServiceRequest.getGeneralProgressListener())).withRequestMetricCollector(amazonWebServiceRequest.getRequestMetricCollector());
            EncryptResult encryptResult = aWSKMS.encrypt(encryptRequest);
            byte[] byArray = BinaryUtils.copyAllBytesFrom(encryptResult.getCiphertextBlob());
            return new KMSSecuredCEK(byArray, map);
        }
        Map<String, String> map = encryptionMaterials.getMaterialsDescription();
        Key key = encryptionMaterials.getKeyPair() != null ? encryptionMaterials.getKeyPair().getPublic() : encryptionMaterials.getSymmetricKey();
        String string = s3KeyWrapScheme.getKeyWrapAlgorithm(key);
        Provider provider = cryptoConfiguration.getCryptoProvider();
        SecureRandom secureRandom = cryptoConfiguration.getSecureRandom();
        try {
            if (string != null) {
                Cipher cipher = provider == null ? Cipher.getInstance(string) : Cipher.getInstance(string, provider);
                cipher.init(3, key, secureRandom);
                return new SecuredCEK(cipher.wrap(secretKey), string, map);
            }
            byte[] byArray = secretKey.getEncoded();
            String string2 = key.getAlgorithm();
            Cipher cipher = provider != null ? Cipher.getInstance(string2, provider) : Cipher.getInstance(string2);
            cipher.init(1, key);
            return new SecuredCEK(cipher.doFinal(byArray), null, map);
        }
        catch (Exception exception) {
            throw Throwables.failure(exception, "Unable to encrypt symmetric key");
        }
    }

    static Map<String, String> mergeMaterialDescriptions(EncryptionMaterials encryptionMaterials, AmazonWebServiceRequest amazonWebServiceRequest) {
        MaterialsDescriptionProvider materialsDescriptionProvider;
        Map<String, String> map;
        Map<String, String> map2 = encryptionMaterials.getMaterialsDescription();
        if (amazonWebServiceRequest instanceof MaterialsDescriptionProvider && (map = (materialsDescriptionProvider = (MaterialsDescriptionProvider)((Object)amazonWebServiceRequest)).getMaterialsDescription()) != null) {
            map2 = new TreeMap<String, String>(map2);
            map2.putAll(map);
        }
        return map2;
    }
}

