/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.auth;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.auth.RegionAwareSigner;
import com.amazonaws.auth.ServiceAwareSigner;
import com.amazonaws.auth.Signer;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.internal.auth.SignerProviderContext;
import com.amazonaws.regions.EndpointToRegion;
import com.amazonaws.services.s3.internal.ServiceUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3SignerProvider
extends SignerProvider {
    private static Log log = LogFactory.getLog(S3SignerProvider.class);
    private final AmazonWebServiceClient awsClient;
    private Signer signer;

    public S3SignerProvider(AmazonWebServiceClient amazonWebServiceClient, Signer signer) {
        this.awsClient = amazonWebServiceClient;
        this.signer = signer;
    }

    @Override
    public Signer getSigner(SignerProviderContext signerProviderContext) {
        Object object;
        URI uRI = signerProviderContext.getUri();
        if (uRI == null || ServiceUtils.isS3AccelerateEndpoint(uRI.getHost()) || this.isSignerRegionOverrideSet()) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner && !this.isAccessPointUri(uRI)) {
            object = (RegionAwareSigner)this.signer;
            try {
                object.setRegionName(EndpointToRegion.guessRegionNameForEndpoint(uRI.getHost(), "s3"));
            }
            catch (RuntimeException runtimeException) {
                log.warn("Failed to parse the endpoint " + uRI + ", and skip re-assigning the signer region", runtimeException);
            }
        }
        object = signerProviderContext.getRequest();
        if (!this.isSignerOverridden() && object != null && object.getHandlerContext(HandlerContextKey.SIGNING_NAME) != null) {
            String string = object.getHandlerContext(HandlerContextKey.SIGNING_NAME);
            if (this.signer instanceof ServiceAwareSigner) {
                ((ServiceAwareSigner)this.signer).setServiceName(string);
            }
        }
        return this.signer;
    }

    private boolean isAccessPointUri(URI uRI) {
        String string = uRI.toASCIIString();
        return string.contains(".s3-accesspoint.") || string.contains(".s3-outposts.") || string.contains(".s3-object-lambda.");
    }

    private boolean isSignerRegionOverrideSet() {
        return this.awsClient != null && this.awsClient.getSignerRegionOverride() != null;
    }

    private boolean isSignerOverridden() {
        return this.awsClient.getSignerOverride() != null;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }
}

