/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.AwsProfileNameLoader;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.profile.path.AwsProfileFileLocationProvider;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
@SdkInternalApi
public final class UseArnRegionResolver {
    private static final Log log = LogFactory.getLog(UseArnRegionResolver.class);
    private static final String ENV_VAR = "AWS_S3_USE_ARN_REGION";
    private static final String PROFILE_PROPERTY = "s3_use_arn_region";
    private final AwsProfileFileLocationProvider configFileLocationProvider;
    private final boolean useArnRegion;
    private volatile String profileName;
    private volatile ProfilesConfigFile configFile;
    private volatile boolean profileLoadAttempted;

    public UseArnRegionResolver() {
        this(AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER);
    }

    public UseArnRegionResolver(AwsProfileFileLocationProvider awsProfileFileLocationProvider) {
        this.configFileLocationProvider = awsProfileFileLocationProvider;
        this.useArnRegion = this.resolveUseArnRegion();
    }

    public boolean useArnRegion() {
        return this.useArnRegion;
    }

    private boolean resolveUseArnRegion() {
        String string = this.envVar();
        if (string == null) {
            string = this.profile();
        }
        return Boolean.valueOf(string);
    }

    private String envVar() {
        return System.getenv(ENV_VAR);
    }

    private String profile() {
        String string = this.getProfileName();
        BasicProfile basicProfile = this.getProfile(string);
        if (basicProfile == null) {
            return null;
        }
        String string2 = basicProfile.getPropertyValue(PROFILE_PROPERTY);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProfileName() {
        if (this.profileName == null) {
            UseArnRegionResolver useArnRegionResolver = this;
            synchronized (useArnRegionResolver) {
                if (this.profileName == null) {
                    this.profileName = AwsProfileNameLoader.INSTANCE.loadProfileName();
                }
            }
        }
        return this.profileName;
    }

    private BasicProfile getProfile(String string) {
        ProfilesConfigFile profilesConfigFile = this.getProfilesConfigFile();
        if (profilesConfigFile != null) {
            return profilesConfigFile.getAllBasicProfiles().get(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfilesConfigFile getProfilesConfigFile() {
        if (!this.profileLoadAttempted) {
            UseArnRegionResolver useArnRegionResolver = this;
            synchronized (useArnRegionResolver) {
                if (!this.profileLoadAttempted) {
                    File file = null;
                    try {
                        file = this.configFileLocationProvider.getLocation();
                        if (file != null) {
                            this.configFile = new ProfilesConfigFile(file);
                        }
                    }
                    catch (Exception exception) {
                        if (log.isWarnEnabled()) {
                            log.warn("Unable to load config file " + file, exception);
                        }
                    }
                    finally {
                        this.profileLoadAttempted = true;
                    }
                }
            }
        }
        return this.configFile;
    }
}

