/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.internal.ServiceEndpointBuilder;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.internal.BucketNameUtils;
import com.amazonaws.util.SdkHttpUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class S3RequestEndpointResolver {
    private final ServiceEndpointBuilder endpointBuilder;
    private final boolean isPathStyleAccess;
    private final String bucketName;
    private final String key;

    public S3RequestEndpointResolver(ServiceEndpointBuilder serviceEndpointBuilder, boolean bl, String string, String string2) {
        this.endpointBuilder = serviceEndpointBuilder;
        this.isPathStyleAccess = bl;
        this.bucketName = string;
        this.key = string2;
    }

    static boolean isValidIpV4Address(String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = string.split("\\.");
        if (stringArray.length != 4) {
            return false;
        }
        for (String string2 : stringArray) {
            try {
                int n = Integer.parseInt(string2);
                if (n >= 0 && n <= 255) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    private static URI convertToVirtualHostEndpoint(URI uRI, String string) {
        try {
            return new URI(String.format("%s://%s.%s", uRI.getScheme(), string, uRI.getAuthority()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Invalid bucket name: " + string, uRISyntaxException);
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void resolveRequestEndpoint(Request<?> request) {
        this.resolveRequestEndpoint(request, null);
    }

    public void resolveRequestEndpoint(Request<?> request, String string) {
        Object object;
        if (string != null) {
            object = RegionUtils.getRegion(string);
            if (object == null) {
                throw new SdkClientException("Not able to determine region for " + string + ".Please upgrade to a newer version of the SDK");
            }
            this.endpointBuilder.withRegion((Region)object);
        }
        if (((URI)(object = this.endpointBuilder.getServiceEndpoint())).getHost() == null) {
            throw new IllegalArgumentException("Endpoint does not contain a valid host name: " + request.getEndpoint());
        }
        if (this.shouldUseVirtualAddressing((URI)object)) {
            request.setEndpoint(S3RequestEndpointResolver.convertToVirtualHostEndpoint((URI)object, this.bucketName));
            request.setResourcePath(SdkHttpUtils.urlEncode(this.getHostStyleResourcePath(), true));
        } else {
            request.setEndpoint((URI)object);
            request.setResourcePath(SdkHttpUtils.urlEncode(this.getPathStyleResourcePath(), true));
        }
    }

    private boolean shouldUseVirtualAddressing(URI uRI) {
        return !this.isPathStyleAccess && BucketNameUtils.isDNSBucketName(this.bucketName) && !S3RequestEndpointResolver.isValidIpV4Address(uRI.getHost());
    }

    private String getHostStyleResourcePath() {
        String string = this.key;
        if (this.key != null && this.key.startsWith("/")) {
            string = "/" + this.key;
        }
        return string;
    }

    private String getPathStyleResourcePath() {
        if (this.bucketName == null) {
            return this.key;
        }
        return this.bucketName + "/" + (this.key != null ? this.key : "");
    }
}

