/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.util.StringUtils;
import java.net.URI;

public class S3ObjectLambdaOperationEndpointBuilder {
    private String region;
    private String protocol;
    private String domain;

    private S3ObjectLambdaOperationEndpointBuilder() {
    }

    public static S3ObjectLambdaOperationEndpointBuilder create() {
        return new S3ObjectLambdaOperationEndpointBuilder();
    }

    public S3ObjectLambdaOperationEndpointBuilder withRegion(String string) {
        this.region = string;
        return this;
    }

    public S3ObjectLambdaOperationEndpointBuilder withProtocol(String string) {
        this.protocol = string;
        return this;
    }

    public S3ObjectLambdaOperationEndpointBuilder withDomain(String string) {
        this.domain = string;
        return this;
    }

    public URI toURI() {
        if (StringUtils.isNullOrEmpty(this.protocol)) {
            throw new IllegalArgumentException("protocol must not be empty");
        }
        if (StringUtils.isNullOrEmpty(this.domain)) {
            throw new IllegalArgumentException("domain must not be empty");
        }
        if (StringUtils.isNullOrEmpty(this.region)) {
            throw new IllegalArgumentException("region must not be empty");
        }
        String string = String.format("%s://s3-object-lambda.%s.%s", this.protocol, this.region, this.domain);
        return URI.create(string);
    }
}

