/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.internal.SdkInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class RepeatableInputStream
extends SdkInputStream {
    private static final Log log = LogFactory.getLog(RepeatableInputStream.class);
    private InputStream is;
    private int bufferSize;
    private int bufferOffset;
    private long bytesReadPastMark;
    private byte[] buffer;
    private boolean hasWarnedBufferOverflow;

    public RepeatableInputStream(InputStream inputStream2, int n) {
        if (inputStream2 == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.is = inputStream2;
        this.bufferSize = n;
        this.buffer = new byte[this.bufferSize];
        if (log.isDebugEnabled()) {
            log.debug("Underlying input stream will be repeatable up to " + this.buffer.length + " bytes");
        }
    }

    @Override
    public void reset() throws IOException {
        this.abortIfNeeded();
        if (this.bytesReadPastMark <= (long)this.bufferSize) {
            if (log.isDebugEnabled()) {
                log.debug("Reset after reading " + this.bytesReadPastMark + " bytes.");
            }
        } else {
            throw new IOException("Input stream cannot be reset as " + this.bytesReadPastMark + " bytes have been written, exceeding the available buffer size of " + this.bufferSize);
        }
        this.bufferOffset = 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.abortIfNeeded();
        if (log.isDebugEnabled()) {
            log.debug("Input stream marked at " + this.bytesReadPastMark + " bytes");
        }
        if (this.bytesReadPastMark <= (long)this.bufferSize && this.buffer != null) {
            byte[] byArray = new byte[this.bufferSize];
            System.arraycopy(this.buffer, this.bufferOffset, byArray, 0, (int)(this.bytesReadPastMark - (long)this.bufferOffset));
            this.buffer = byArray;
            this.bytesReadPastMark -= (long)this.bufferOffset;
            this.bufferOffset = 0;
        } else {
            this.bufferOffset = 0;
            this.bytesReadPastMark = 0L;
            this.buffer = new byte[this.bufferSize];
        }
    }

    @Override
    public int available() throws IOException {
        this.abortIfNeeded();
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
        this.abortIfNeeded();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.abortIfNeeded();
        if ((long)this.bufferOffset < this.bytesReadPastMark && this.buffer != null) {
            int n3 = n2;
            if ((long)(this.bufferOffset + n3) > this.bytesReadPastMark) {
                n3 = (int)this.bytesReadPastMark - this.bufferOffset;
            }
            System.arraycopy(this.buffer, this.bufferOffset, byArray, n, n3);
            this.bufferOffset += n3;
            return n3;
        }
        int n4 = this.is.read(byArray, n, n2);
        if (n4 <= 0) {
            return n4;
        }
        if (this.bytesReadPastMark + (long)n4 <= (long)this.bufferSize) {
            System.arraycopy(byArray, n, this.buffer, (int)this.bytesReadPastMark, n4);
            this.bufferOffset += n4;
        } else {
            if (!this.hasWarnedBufferOverflow) {
                if (log.isDebugEnabled()) {
                    log.debug("Buffer size " + this.bufferSize + " has been exceeded and the input stream will not be repeatable until the next mark. Freeing buffer memory");
                }
                this.hasWarnedBufferOverflow = true;
            }
            this.buffer = null;
        }
        this.bytesReadPastMark += (long)n4;
        return n4;
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n != -1) {
            int n2 = byArray[0] & 0xFF;
            return n2;
        }
        return n;
    }

    @Override
    public InputStream getWrappedInputStream() {
        return this.is;
    }
}

