/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.ReadLimitInfo;
import com.amazonaws.Request;
import com.amazonaws.ResetException;
import com.amazonaws.SdkClientException;
import com.amazonaws.SignableRequest;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AwsChunkedEncodingInputStream;
import com.amazonaws.auth.internal.AWS4SignerRequestParams;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.request.S3HandlerContextKeys;
import com.amazonaws.util.BinaryUtils;
import java.io.IOException;
import java.io.InputStream;

public class AWSS3V4Signer
extends AWS4Signer {
    private static final String CONTENT_SHA_256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";

    public AWSS3V4Signer() {
        super(false);
    }

    @Override
    protected void processRequestPayload(SignableRequest<?> signableRequest, byte[] byArray, byte[] byArray2, AWS4SignerRequestParams aWS4SignerRequestParams) {
        if (this.useChunkEncoding(signableRequest)) {
            AwsChunkedEncodingInputStream awsChunkedEncodingInputStream = new AwsChunkedEncodingInputStream(signableRequest.getContent(), byArray2, aWS4SignerRequestParams.getFormattedSigningDateTime(), aWS4SignerRequestParams.getScope(), BinaryUtils.toHex(byArray), this);
            signableRequest.setContent(awsChunkedEncodingInputStream);
        }
    }

    @Override
    protected String calculateContentHashPresign(SignableRequest<?> signableRequest) {
        return UNSIGNED_PAYLOAD;
    }

    @Override
    protected String calculateContentHash(SignableRequest<?> signableRequest) {
        signableRequest.addHeader("x-amz-content-sha256", "required");
        if (this.isPayloadSigningEnabled(signableRequest)) {
            if (this.useChunkEncoding(signableRequest)) {
                long l;
                String string = signableRequest.getHeaders().get("Content-Length");
                if (string != null) {
                    l = Long.parseLong(string);
                } else {
                    try {
                        l = AWSS3V4Signer.getContentLength(signableRequest);
                    }
                    catch (IOException iOException) {
                        throw new SdkClientException("Cannot get the content-length of the request content.", iOException);
                    }
                }
                signableRequest.addHeader("x-amz-decoded-content-length", Long.toString(l));
                signableRequest.addHeader("Content-Length", Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength(l)));
                return CONTENT_SHA_256;
            }
            return super.calculateContentHash(signableRequest);
        }
        return UNSIGNED_PAYLOAD;
    }

    private boolean useChunkEncoding(SignableRequest<?> signableRequest) {
        if (!this.isPayloadSigningEnabled(signableRequest) || this.isChunkedEncodingDisabled(signableRequest)) {
            return false;
        }
        return signableRequest.getOriginalRequestObject() instanceof PutObjectRequest || signableRequest.getOriginalRequestObject() instanceof UploadPartRequest;
    }

    private boolean isChunkedEncodingDisabled(SignableRequest<?> signableRequest) {
        if (signableRequest instanceof Request) {
            Request request = (Request)signableRequest;
            Boolean bl = request.getHandlerContext(S3HandlerContextKeys.IS_CHUNKED_ENCODING_DISABLED);
            return bl != null && bl != false;
        }
        return false;
    }

    private boolean isPayloadSigningEnabled(SignableRequest<?> signableRequest) {
        if (!signableRequest.getEndpoint().getScheme().equals("https")) {
            return true;
        }
        if (signableRequest instanceof Request) {
            Request request = (Request)signableRequest;
            Boolean bl = request.getHandlerContext(S3HandlerContextKeys.IS_PAYLOAD_SIGNING_ENABLED);
            return bl != null && bl != false;
        }
        return false;
    }

    static long getContentLength(SignableRequest<?> signableRequest) throws IOException {
        int n;
        InputStream inputStream2 = signableRequest.getContent();
        if (!inputStream2.markSupported()) {
            throw new IllegalStateException("Bug: request input stream must have been made mark-and-resettable at this point");
        }
        ReadLimitInfo readLimitInfo = signableRequest.getReadLimitInfo();
        int n2 = readLimitInfo.getReadLimit();
        long l = 0L;
        byte[] byArray = new byte[4096];
        inputStream2.mark(n2);
        while ((n = inputStream2.read(byArray)) != -1) {
            l += (long)n;
        }
        try {
            inputStream2.reset();
        }
        catch (IOException iOException) {
            throw new ResetException("Failed to reset the input stream", iOException);
        }
        return l;
    }
}

