/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.S3ResourceType;
import com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public final class S3BucketResource
implements S3Resource {
    private static final S3ResourceType S3_RESOURCE_TYPE = S3ResourceType.BUCKET;
    private final String partition;
    private final String region;
    private final String accountId;
    private final String bucketName;

    private S3BucketResource(Builder builder) {
        this.bucketName = ValidationUtils.assertStringNotEmpty(builder.bucketName, "bucketName");
        this.partition = builder.partition;
        this.region = builder.region;
        this.accountId = builder.accountId;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getType() {
        return S3_RESOURCE_TYPE.toString();
    }

    @Override
    public S3Resource getParentS3Resource() {
        return null;
    }

    @Override
    public String getPartition() {
        return this.partition;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        S3BucketResource s3BucketResource = (S3BucketResource)object;
        if (this.partition != null ? !this.partition.equals(s3BucketResource.partition) : s3BucketResource.partition != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(s3BucketResource.region) : s3BucketResource.region != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(s3BucketResource.accountId) : s3BucketResource.accountId != null) {
            return false;
        }
        return this.bucketName.equals(s3BucketResource.bucketName);
    }

    public int hashCode() {
        int n = this.partition != null ? this.partition.hashCode() : 0;
        n = 31 * n + (this.region != null ? this.region.hashCode() : 0);
        n = 31 * n + (this.accountId != null ? this.accountId.hashCode() : 0);
        n = 31 * n + this.bucketName.hashCode();
        return n;
    }

    public static final class Builder {
        private String partition;
        private String region;
        private String accountId;
        private String bucketName;

        public void setPartition(String string) {
            this.partition = string;
        }

        public Builder withPartition(String string) {
            this.setPartition(string);
            return this;
        }

        public void setRegion(String string) {
            this.region = string;
        }

        public Builder withRegion(String string) {
            this.setRegion(string);
            return this;
        }

        public void setAccountId(String string) {
            this.accountId = string;
        }

        public Builder withAccountId(String string) {
            this.setAccountId(string);
            return this;
        }

        public void setBucketName(String string) {
            this.bucketName = string;
        }

        public Builder withBucketName(String string) {
            this.setBucketName(string);
            return this;
        }

        public S3BucketResource build() {
            return new S3BucketResource(this);
        }
    }
}

