/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.Region;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3EncryptionClientV2Builder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientV2Params;
import com.amazonaws.services.s3.AmazonS3EncryptionV2;
import com.amazonaws.services.s3.UploadObjectObserver;
import com.amazonaws.services.s3.internal.MultiFileOutputStream;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.v2.S3CryptoModule;
import com.amazonaws.services.s3.internal.crypto.v2.S3CryptoModuleAE;
import com.amazonaws.services.s3.internal.crypto.v2.S3CryptoModuleAEStrict;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.CryptoRangeGetMode;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.EncryptedInitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.InstructionFileId;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutInstructionFileRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.services.s3.model.UploadObjectRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonS3EncryptionClientV2
extends AmazonS3Client
implements AmazonS3EncryptionV2 {
    private static final String USER_AGENT_V2 = "S3CryptoV2/" + VersionInfoUtils.getVersion();
    private static final Log log = LogFactory.getLog(AmazonS3EncryptionClientV2.class);
    private final S3CryptoModule<?> crypto;
    private final AWSKMS kmsClient;
    private final boolean isKMSClientInternal;

    public static AmazonS3EncryptionClientV2Builder encryptionBuilder() {
        return AmazonS3EncryptionClientV2Builder.standard();
    }

    @SdkInternalApi
    AmazonS3EncryptionClientV2(AmazonS3EncryptionClientV2Params amazonS3EncryptionClientV2Params) {
        super(amazonS3EncryptionClientV2Params);
        this.validateParameters(amazonS3EncryptionClientV2Params);
        CryptoConfigurationV2 cryptoConfigurationV2 = this.validateConfigAndCreateReadOnlyCopy(amazonS3EncryptionClientV2Params.getCryptoConfiguration());
        this.isKMSClientInternal = amazonS3EncryptionClientV2Params.getKmsClient() == null;
        this.kmsClient = this.isKMSClientInternal ? this.newAWSKMSClient(amazonS3EncryptionClientV2Params.getClientParams().getCredentialsProvider(), amazonS3EncryptionClientV2Params.getClientParams().getClientConfiguration(), cryptoConfigurationV2, amazonS3EncryptionClientV2Params.getClientParams().getRequestMetricCollector()) : amazonS3EncryptionClientV2Params.getKmsClient();
        this.crypto = this.createCryptoModule(cryptoConfigurationV2, this.kmsClient, amazonS3EncryptionClientV2Params.getEncryptionMaterialsProvider(), amazonS3EncryptionClientV2Params.getClientParams().getCredentialsProvider());
        AmazonS3EncryptionClientV2.warnOnLegacyCryptoMode(amazonS3EncryptionClientV2Params.getCryptoConfiguration().getCryptoMode());
        AmazonS3EncryptionClientV2.warnOnRangeGetsEnabled(amazonS3EncryptionClientV2Params);
    }

    private void validateParameters(AmazonS3EncryptionClientV2Params amazonS3EncryptionClientV2Params) {
        this.assertParameterNotNull(amazonS3EncryptionClientV2Params.getEncryptionMaterialsProvider(), "EncryptionMaterialsProvider parameter must not be null.");
        this.assertParameterNotNull(amazonS3EncryptionClientV2Params.getCryptoConfiguration(), "CryptoConfiguration parameter must not be null.");
    }

    private S3CryptoModule<?> createCryptoModule(CryptoConfigurationV2 cryptoConfigurationV2, AWSKMS aWSKMS, EncryptionMaterialsProvider encryptionMaterialsProvider, AWSCredentialsProvider aWSCredentialsProvider) {
        if (cryptoConfigurationV2.getCryptoMode() == CryptoMode.AuthenticatedEncryption) {
            return new S3CryptoModuleAE(aWSKMS, new S3DirectImpl(), aWSCredentialsProvider, encryptionMaterialsProvider, cryptoConfigurationV2);
        }
        if (cryptoConfigurationV2.getCryptoMode() == CryptoMode.StrictAuthenticatedEncryption) {
            return new S3CryptoModuleAEStrict(aWSKMS, new S3DirectImpl(), aWSCredentialsProvider, encryptionMaterialsProvider, cryptoConfigurationV2);
        }
        throw new UnsupportedOperationException("Cannot encrypt using mode " + (Object)((Object)cryptoConfigurationV2.getCryptoMode()));
    }

    private CryptoConfigurationV2 validateConfigAndCreateReadOnlyCopy(CryptoConfigurationV2 cryptoConfigurationV2) {
        CryptoConfigurationV2 cryptoConfigurationV22 = cryptoConfigurationV2.clone();
        if (cryptoConfigurationV22.getCryptoMode() == null) {
            cryptoConfigurationV22.setCryptoMode(CryptoMode.StrictAuthenticatedEncryption);
        }
        if (CryptoMode.AuthenticatedEncryption != cryptoConfigurationV22.getCryptoMode() && CryptoMode.StrictAuthenticatedEncryption != cryptoConfigurationV22.getCryptoMode()) {
            throw new IllegalArgumentException("Invalid value for CryptoMode : " + (Object)((Object)cryptoConfigurationV22.getCryptoMode()));
        }
        if (cryptoConfigurationV2.isUnsafeUndecryptableObjectPassthrough() && CryptoMode.StrictAuthenticatedEncryption == cryptoConfigurationV2.getCryptoMode()) {
            throw new IllegalArgumentException(String.format("unsafeUndecryptableObjectPassthrough must not be enabled in %s mode", new Object[]{CryptoMode.StrictAuthenticatedEncryption}));
        }
        return cryptoConfigurationV22.readOnly();
    }

    private AWSKMS newAWSKMSClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, CryptoConfigurationV2 cryptoConfigurationV2, RequestMetricCollector requestMetricCollector) {
        AWSKMSClientBuilder aWSKMSClientBuilder = (AWSKMSClientBuilder)((AWSKMSClientBuilder)((AWSKMSClientBuilder)AWSKMSClientBuilder.standard().withCredentials(aWSCredentialsProvider)).withClientConfiguration(clientConfiguration)).withMetricsCollector(requestMetricCollector);
        Region region = cryptoConfigurationV2.getAwsKmsRegion();
        if (region != null) {
            aWSKMSClientBuilder.withRegion(region.getName());
        }
        return (AWSKMS)aWSKMSClientBuilder.build();
    }

    private void assertParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(string);
        }
    }

    public AWSKMS getKmsClient() {
        return this.isKMSClientInternal ? null : this.kmsClient;
    }

    public EncryptionMaterialsProvider getEncryptionMaterialsProvider() {
        return this.crypto.getEncryptionMaterialsProvider();
    }

    public CryptoConfigurationV2 getCryptoConfiguration() {
        return this.crypto.getCryptoConfiguration();
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
        return this.crypto.putObjectSecurely(putObjectRequest.clone());
    }

    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) {
        return this.crypto.getObjectSecurely(getObjectRequest);
    }

    @Override
    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) {
        return this.crypto.getObjectSecurely(getObjectRequest, file);
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) {
        deleteObjectRequest.getRequestClientOptions().appendUserAgent(USER_AGENT_V2);
        super.deleteObject(deleteObjectRequest);
        InstructionFileId instructionFileId = new S3ObjectId(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey()).instructionFileId();
        DeleteObjectRequest deleteObjectRequest2 = (DeleteObjectRequest)deleteObjectRequest.clone();
        deleteObjectRequest2.withBucketName(instructionFileId.getBucket()).withKey(instructionFileId.getKey());
        super.deleteObject(deleteObjectRequest2);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        return this.crypto.completeMultipartUploadSecurely(completeMultipartUploadRequest);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        boolean bl = true;
        if (initiateMultipartUploadRequest instanceof EncryptedInitiateMultipartUploadRequest) {
            EncryptedInitiateMultipartUploadRequest encryptedInitiateMultipartUploadRequest = (EncryptedInitiateMultipartUploadRequest)initiateMultipartUploadRequest;
            bl = encryptedInitiateMultipartUploadRequest.isCreateEncryptionMaterial();
        }
        return bl ? this.crypto.initiateMultipartUploadSecurely(initiateMultipartUploadRequest) : super.initiateMultipartUpload(initiateMultipartUploadRequest);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
        return this.crypto.uploadPartSecurely(uploadPartRequest);
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        return this.crypto.copyPartSecurely(copyPartRequest);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        this.crypto.abortMultipartUploadSecurely(abortMultipartUploadRequest);
    }

    @Override
    public PutObjectResult putInstructionFile(PutInstructionFileRequest putInstructionFileRequest) {
        return this.crypto.putInstructionFileSecurely(putInstructionFileRequest);
    }

    @Override
    public CompleteMultipartUploadResult uploadObject(UploadObjectRequest uploadObjectRequest) throws IOException, InterruptedException, ExecutionException {
        UploadObjectObserver uploadObjectObserver;
        boolean bl;
        ExecutorService executorService = uploadObjectRequest.getExecutorService();
        boolean bl2 = bl = executorService == null;
        if (executorService == null) {
            executorService = Executors.newFixedThreadPool(this.clientConfiguration.getMaxConnections());
        }
        if ((uploadObjectObserver = uploadObjectRequest.getUploadObjectObserver()) == null) {
            uploadObjectObserver = new UploadObjectObserver();
        }
        uploadObjectObserver.init(uploadObjectRequest, new S3DirectImpl(), this, executorService);
        String string = uploadObjectObserver.onUploadInitiation(uploadObjectRequest);
        ArrayList<PartETag> arrayList = new ArrayList<PartETag>();
        MultiFileOutputStream multiFileOutputStream = uploadObjectRequest.getMultiFileOutputStream();
        if (multiFileOutputStream == null) {
            multiFileOutputStream = new MultiFileOutputStream();
        }
        try {
            multiFileOutputStream.init(uploadObjectObserver, uploadObjectRequest.getPartSize(), uploadObjectRequest.getDiskLimit());
            this.crypto.putLocalObjectSecurely(uploadObjectRequest, string, multiFileOutputStream);
            for (Future<UploadPartResult> future : uploadObjectObserver.getFutures()) {
                UploadPartResult uploadPartResult = future.get();
                arrayList.add(new PartETag(uploadPartResult.getPartNumber(), uploadPartResult.getETag()));
            }
        }
        catch (IOException iOException) {
            throw this.onAbort(uploadObjectObserver, iOException);
        }
        catch (InterruptedException interruptedException) {
            throw this.onAbort(uploadObjectObserver, interruptedException);
        }
        catch (ExecutionException executionException) {
            throw this.onAbort(uploadObjectObserver, executionException);
        }
        catch (RuntimeException runtimeException) {
            throw this.onAbort(uploadObjectObserver, runtimeException);
        }
        catch (Error error) {
            throw this.onAbort(uploadObjectObserver, error);
        }
        finally {
            if (bl) {
                executorService.shutdownNow();
            }
            multiFileOutputStream.cleanup();
        }
        return uploadObjectObserver.onCompletion(arrayList);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.isKMSClientInternal) {
            this.kmsClient.shutdown();
        }
    }

    private <T extends Throwable> T onAbort(UploadObjectObserver uploadObjectObserver, T t2) {
        uploadObjectObserver.onAbort();
        return t2;
    }

    private static void warnOnRangeGetsEnabled(AmazonS3EncryptionClientV2Params amazonS3EncryptionClientV2Params) {
        CryptoConfigurationV2 cryptoConfigurationV2 = amazonS3EncryptionClientV2Params.getCryptoConfiguration();
        CryptoRangeGetMode cryptoRangeGetMode = cryptoConfigurationV2.getRangeGetMode();
        if (cryptoRangeGetMode != CryptoRangeGetMode.DISABLED) {
            log.warn("The S3 Encryption Client is configured to support range get requests. Range gets do not provide authenticated encryption properties even when used with an authenticated mode (AES-GCM). See https://docs.aws.amazon.com/general/latest/gr/aws_sdk_cryptography.html");
        }
    }

    private static void warnOnLegacyCryptoMode(CryptoMode cryptoMode) {
        if (cryptoMode == CryptoMode.AuthenticatedEncryption) {
            log.warn("The S3 Encryption Client is configured to read encrypted data with legacy encryption modes through the CryptoMode setting. If you don't have objects encrypted with these legacy modes, you should disable support for them to enhance security. See https://docs.aws.amazon.com/general/latest/gr/aws_sdk_cryptography.html");
        }
    }

    private final class S3DirectImpl
    extends S3Direct {
        private S3DirectImpl() {
        }

        @Override
        public PutObjectResult putObject(PutObjectRequest putObjectRequest) {
            this.appendUserAgent(putObjectRequest, USER_AGENT_V2);
            return AmazonS3EncryptionClientV2.super.putObject(putObjectRequest);
        }

        @Override
        public S3Object getObject(GetObjectRequest getObjectRequest) {
            this.appendUserAgent(getObjectRequest, USER_AGENT_V2);
            return AmazonS3EncryptionClientV2.super.getObject(getObjectRequest);
        }

        @Override
        public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) {
            this.appendUserAgent(getObjectRequest, USER_AGENT_V2);
            return AmazonS3EncryptionClientV2.super.getObject(getObjectRequest, file);
        }

        @Override
        public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) {
            this.appendUserAgent(getObjectMetadataRequest, USER_AGENT_V2);
            return AmazonS3EncryptionClientV2.super.getObjectMetadata(getObjectMetadataRequest);
        }

        @Override
        public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
            this.appendUserAgent(completeMultipartUploadRequest, USER_AGENT_V2);
            return AmazonS3EncryptionClientV2.super.completeMultipartUpload(completeMultipartUploadRequest);
        }

        @Override
        public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
            this.appendUserAgent(initiateMultipartUploadRequest, USER_AGENT_V2);
            return AmazonS3EncryptionClientV2.super.initiateMultipartUpload(initiateMultipartUploadRequest);
        }

        @Override
        public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
            this.appendUserAgent(uploadPartRequest, USER_AGENT_V2);
            return AmazonS3EncryptionClientV2.super.uploadPart(uploadPartRequest);
        }

        @Override
        public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
            this.appendUserAgent(copyPartRequest, USER_AGENT_V2);
            return AmazonS3EncryptionClientV2.super.copyPart(copyPartRequest);
        }

        @Override
        public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
            this.appendUserAgent(abortMultipartUploadRequest, USER_AGENT_V2);
            AmazonS3EncryptionClientV2.super.abortMultipartUpload(abortMultipartUploadRequest);
        }

        final <X extends AmazonWebServiceRequest> X appendUserAgent(X x, String string) {
            x.getRequestClientOptions().appendUserAgent(string);
            return x;
        }
    }
}

