/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.MacAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class VerifyMacRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ByteBuffer message;
    private String keyId;
    private String macAlgorithm;
    private ByteBuffer mac;
    private SdkInternalList<String> grantTokens;

    public void setMessage(ByteBuffer byteBuffer) {
        this.message = byteBuffer;
    }

    public ByteBuffer getMessage() {
        return this.message;
    }

    public VerifyMacRequest withMessage(ByteBuffer byteBuffer) {
        this.setMessage(byteBuffer);
        return this;
    }

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public VerifyMacRequest withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setMacAlgorithm(String string) {
        this.macAlgorithm = string;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public VerifyMacRequest withMacAlgorithm(String string) {
        this.setMacAlgorithm(string);
        return this;
    }

    public VerifyMacRequest withMacAlgorithm(MacAlgorithmSpec macAlgorithmSpec) {
        this.macAlgorithm = macAlgorithmSpec.toString();
        return this;
    }

    public void setMac(ByteBuffer byteBuffer) {
        this.mac = byteBuffer;
    }

    public ByteBuffer getMac() {
        return this.mac;
    }

    public VerifyMacRequest withMac(ByteBuffer byteBuffer) {
        this.setMac(byteBuffer);
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> collection) {
        if (collection == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(collection);
    }

    public VerifyMacRequest withGrantTokens(String ... stringArray) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.grantTokens.add(string);
        }
        return this;
    }

    public VerifyMacRequest withGrantTokens(Collection<String> collection) {
        this.setGrantTokens(collection);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getMessage() != null) {
            stringBuilder.append("Message: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getMacAlgorithm() != null) {
            stringBuilder.append("MacAlgorithm: ").append(this.getMacAlgorithm()).append(",");
        }
        if (this.getMac() != null) {
            stringBuilder.append("Mac: ").append(this.getMac()).append(",");
        }
        if (this.getGrantTokens() != null) {
            stringBuilder.append("GrantTokens: ").append(this.getGrantTokens());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof VerifyMacRequest)) {
            return false;
        }
        VerifyMacRequest verifyMacRequest = (VerifyMacRequest)object;
        if (verifyMacRequest.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (verifyMacRequest.getMessage() != null && !verifyMacRequest.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (verifyMacRequest.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (verifyMacRequest.getKeyId() != null && !verifyMacRequest.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (verifyMacRequest.getMacAlgorithm() == null ^ this.getMacAlgorithm() == null) {
            return false;
        }
        if (verifyMacRequest.getMacAlgorithm() != null && !verifyMacRequest.getMacAlgorithm().equals(this.getMacAlgorithm())) {
            return false;
        }
        if (verifyMacRequest.getMac() == null ^ this.getMac() == null) {
            return false;
        }
        if (verifyMacRequest.getMac() != null && !verifyMacRequest.getMac().equals(this.getMac())) {
            return false;
        }
        if (verifyMacRequest.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        return verifyMacRequest.getGrantTokens() == null || verifyMacRequest.getGrantTokens().equals(this.getGrantTokens());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getMacAlgorithm() == null ? 0 : this.getMacAlgorithm().hashCode());
        n2 = 31 * n2 + (this.getMac() == null ? 0 : this.getMac().hashCode());
        n2 = 31 * n2 + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        return n2;
    }

    @Override
    public VerifyMacRequest clone() {
        return (VerifyMacRequest)super.clone();
    }
}

