/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.AliasListEntry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListAliasesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<AliasListEntry> aliases;
    private String nextMarker;
    private Boolean truncated;

    public List<AliasListEntry> getAliases() {
        if (this.aliases == null) {
            this.aliases = new SdkInternalList();
        }
        return this.aliases;
    }

    public void setAliases(Collection<AliasListEntry> collection) {
        if (collection == null) {
            this.aliases = null;
            return;
        }
        this.aliases = new SdkInternalList<AliasListEntry>(collection);
    }

    public ListAliasesResult withAliases(AliasListEntry ... aliasListEntryArray) {
        if (this.aliases == null) {
            this.setAliases(new SdkInternalList<AliasListEntry>(aliasListEntryArray.length));
        }
        for (AliasListEntry aliasListEntry : aliasListEntryArray) {
            this.aliases.add(aliasListEntry);
        }
        return this;
    }

    public ListAliasesResult withAliases(Collection<AliasListEntry> collection) {
        this.setAliases(collection);
        return this;
    }

    public void setNextMarker(String string) {
        this.nextMarker = string;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListAliasesResult withNextMarker(String string) {
        this.setNextMarker(string);
        return this;
    }

    public void setTruncated(Boolean bl) {
        this.truncated = bl;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public ListAliasesResult withTruncated(Boolean bl) {
        this.setTruncated(bl);
        return this;
    }

    public Boolean isTruncated() {
        return this.truncated;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getAliases() != null) {
            stringBuilder.append("Aliases: ").append(this.getAliases()).append(",");
        }
        if (this.getNextMarker() != null) {
            stringBuilder.append("NextMarker: ").append(this.getNextMarker()).append(",");
        }
        if (this.getTruncated() != null) {
            stringBuilder.append("Truncated: ").append(this.getTruncated());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ListAliasesResult)) {
            return false;
        }
        ListAliasesResult listAliasesResult = (ListAliasesResult)object;
        if (listAliasesResult.getAliases() == null ^ this.getAliases() == null) {
            return false;
        }
        if (listAliasesResult.getAliases() != null && !listAliasesResult.getAliases().equals(this.getAliases())) {
            return false;
        }
        if (listAliasesResult.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (listAliasesResult.getNextMarker() != null && !listAliasesResult.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (listAliasesResult.getTruncated() == null ^ this.getTruncated() == null) {
            return false;
        }
        return listAliasesResult.getTruncated() == null || listAliasesResult.getTruncated().equals(this.getTruncated());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getAliases() == null ? 0 : this.getAliases().hashCode());
        n2 = 31 * n2 + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        n2 = 31 * n2 + (this.getTruncated() == null ? 0 : this.getTruncated().hashCode());
        return n2;
    }

    public ListAliasesResult clone() {
        try {
            return (ListAliasesResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

