/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.CustomerMasterKeySpec;
import com.amazonaws.services.kms.model.EncryptionAlgorithmSpec;
import com.amazonaws.services.kms.model.KeySpec;
import com.amazonaws.services.kms.model.KeyUsageType;
import com.amazonaws.services.kms.model.SigningAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class GetPublicKeyResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String keyId;
    private ByteBuffer publicKey;
    @Deprecated
    private String customerMasterKeySpec;
    private String keySpec;
    private String keyUsage;
    private SdkInternalList<String> encryptionAlgorithms;
    private SdkInternalList<String> signingAlgorithms;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public GetPublicKeyResult withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setPublicKey(ByteBuffer byteBuffer) {
        this.publicKey = byteBuffer;
    }

    public ByteBuffer getPublicKey() {
        return this.publicKey;
    }

    public GetPublicKeyResult withPublicKey(ByteBuffer byteBuffer) {
        this.setPublicKey(byteBuffer);
        return this;
    }

    @Deprecated
    public void setCustomerMasterKeySpec(String string) {
        this.customerMasterKeySpec = string;
    }

    @Deprecated
    public String getCustomerMasterKeySpec() {
        return this.customerMasterKeySpec;
    }

    @Deprecated
    public GetPublicKeyResult withCustomerMasterKeySpec(String string) {
        this.setCustomerMasterKeySpec(string);
        return this;
    }

    @Deprecated
    public GetPublicKeyResult withCustomerMasterKeySpec(CustomerMasterKeySpec customerMasterKeySpec) {
        this.customerMasterKeySpec = customerMasterKeySpec.toString();
        return this;
    }

    public void setKeySpec(String string) {
        this.keySpec = string;
    }

    public String getKeySpec() {
        return this.keySpec;
    }

    public GetPublicKeyResult withKeySpec(String string) {
        this.setKeySpec(string);
        return this;
    }

    public GetPublicKeyResult withKeySpec(KeySpec keySpec) {
        this.keySpec = keySpec.toString();
        return this;
    }

    public void setKeyUsage(String string) {
        this.keyUsage = string;
    }

    public String getKeyUsage() {
        return this.keyUsage;
    }

    public GetPublicKeyResult withKeyUsage(String string) {
        this.setKeyUsage(string);
        return this;
    }

    public GetPublicKeyResult withKeyUsage(KeyUsageType keyUsageType) {
        this.keyUsage = keyUsageType.toString();
        return this;
    }

    public List<String> getEncryptionAlgorithms() {
        if (this.encryptionAlgorithms == null) {
            this.encryptionAlgorithms = new SdkInternalList();
        }
        return this.encryptionAlgorithms;
    }

    public void setEncryptionAlgorithms(Collection<String> collection) {
        if (collection == null) {
            this.encryptionAlgorithms = null;
            return;
        }
        this.encryptionAlgorithms = new SdkInternalList<String>(collection);
    }

    public GetPublicKeyResult withEncryptionAlgorithms(String ... stringArray) {
        if (this.encryptionAlgorithms == null) {
            this.setEncryptionAlgorithms(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.encryptionAlgorithms.add(string);
        }
        return this;
    }

    public GetPublicKeyResult withEncryptionAlgorithms(Collection<String> collection) {
        this.setEncryptionAlgorithms(collection);
        return this;
    }

    public GetPublicKeyResult withEncryptionAlgorithms(EncryptionAlgorithmSpec ... encryptionAlgorithmSpecArray) {
        SdkInternalList<String> sdkInternalList = new SdkInternalList<String>(encryptionAlgorithmSpecArray.length);
        for (EncryptionAlgorithmSpec encryptionAlgorithmSpec : encryptionAlgorithmSpecArray) {
            sdkInternalList.add(encryptionAlgorithmSpec.toString());
        }
        if (this.getEncryptionAlgorithms() == null) {
            this.setEncryptionAlgorithms(sdkInternalList);
        } else {
            this.getEncryptionAlgorithms().addAll(sdkInternalList);
        }
        return this;
    }

    public List<String> getSigningAlgorithms() {
        if (this.signingAlgorithms == null) {
            this.signingAlgorithms = new SdkInternalList();
        }
        return this.signingAlgorithms;
    }

    public void setSigningAlgorithms(Collection<String> collection) {
        if (collection == null) {
            this.signingAlgorithms = null;
            return;
        }
        this.signingAlgorithms = new SdkInternalList<String>(collection);
    }

    public GetPublicKeyResult withSigningAlgorithms(String ... stringArray) {
        if (this.signingAlgorithms == null) {
            this.setSigningAlgorithms(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.signingAlgorithms.add(string);
        }
        return this;
    }

    public GetPublicKeyResult withSigningAlgorithms(Collection<String> collection) {
        this.setSigningAlgorithms(collection);
        return this;
    }

    public GetPublicKeyResult withSigningAlgorithms(SigningAlgorithmSpec ... signingAlgorithmSpecArray) {
        SdkInternalList<String> sdkInternalList = new SdkInternalList<String>(signingAlgorithmSpecArray.length);
        for (SigningAlgorithmSpec signingAlgorithmSpec : signingAlgorithmSpecArray) {
            sdkInternalList.add(signingAlgorithmSpec.toString());
        }
        if (this.getSigningAlgorithms() == null) {
            this.setSigningAlgorithms(sdkInternalList);
        } else {
            this.getSigningAlgorithms().addAll(sdkInternalList);
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getPublicKey() != null) {
            stringBuilder.append("PublicKey: ").append(this.getPublicKey()).append(",");
        }
        if (this.getCustomerMasterKeySpec() != null) {
            stringBuilder.append("CustomerMasterKeySpec: ").append(this.getCustomerMasterKeySpec()).append(",");
        }
        if (this.getKeySpec() != null) {
            stringBuilder.append("KeySpec: ").append(this.getKeySpec()).append(",");
        }
        if (this.getKeyUsage() != null) {
            stringBuilder.append("KeyUsage: ").append(this.getKeyUsage()).append(",");
        }
        if (this.getEncryptionAlgorithms() != null) {
            stringBuilder.append("EncryptionAlgorithms: ").append(this.getEncryptionAlgorithms()).append(",");
        }
        if (this.getSigningAlgorithms() != null) {
            stringBuilder.append("SigningAlgorithms: ").append(this.getSigningAlgorithms());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GetPublicKeyResult)) {
            return false;
        }
        GetPublicKeyResult getPublicKeyResult = (GetPublicKeyResult)object;
        if (getPublicKeyResult.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (getPublicKeyResult.getKeyId() != null && !getPublicKeyResult.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (getPublicKeyResult.getPublicKey() == null ^ this.getPublicKey() == null) {
            return false;
        }
        if (getPublicKeyResult.getPublicKey() != null && !getPublicKeyResult.getPublicKey().equals(this.getPublicKey())) {
            return false;
        }
        if (getPublicKeyResult.getCustomerMasterKeySpec() == null ^ this.getCustomerMasterKeySpec() == null) {
            return false;
        }
        if (getPublicKeyResult.getCustomerMasterKeySpec() != null && !getPublicKeyResult.getCustomerMasterKeySpec().equals(this.getCustomerMasterKeySpec())) {
            return false;
        }
        if (getPublicKeyResult.getKeySpec() == null ^ this.getKeySpec() == null) {
            return false;
        }
        if (getPublicKeyResult.getKeySpec() != null && !getPublicKeyResult.getKeySpec().equals(this.getKeySpec())) {
            return false;
        }
        if (getPublicKeyResult.getKeyUsage() == null ^ this.getKeyUsage() == null) {
            return false;
        }
        if (getPublicKeyResult.getKeyUsage() != null && !getPublicKeyResult.getKeyUsage().equals(this.getKeyUsage())) {
            return false;
        }
        if (getPublicKeyResult.getEncryptionAlgorithms() == null ^ this.getEncryptionAlgorithms() == null) {
            return false;
        }
        if (getPublicKeyResult.getEncryptionAlgorithms() != null && !getPublicKeyResult.getEncryptionAlgorithms().equals(this.getEncryptionAlgorithms())) {
            return false;
        }
        if (getPublicKeyResult.getSigningAlgorithms() == null ^ this.getSigningAlgorithms() == null) {
            return false;
        }
        return getPublicKeyResult.getSigningAlgorithms() == null || getPublicKeyResult.getSigningAlgorithms().equals(this.getSigningAlgorithms());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getPublicKey() == null ? 0 : this.getPublicKey().hashCode());
        n2 = 31 * n2 + (this.getCustomerMasterKeySpec() == null ? 0 : this.getCustomerMasterKeySpec().hashCode());
        n2 = 31 * n2 + (this.getKeySpec() == null ? 0 : this.getKeySpec().hashCode());
        n2 = 31 * n2 + (this.getKeyUsage() == null ? 0 : this.getKeyUsage().hashCode());
        n2 = 31 * n2 + (this.getEncryptionAlgorithms() == null ? 0 : this.getEncryptionAlgorithms().hashCode());
        n2 = 31 * n2 + (this.getSigningAlgorithms() == null ? 0 : this.getSigningAlgorithms().hashCode());
        return n2;
    }

    public GetPublicKeyResult clone() {
        try {
            return (GetPublicKeyResult)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", cloneNotSupportedException);
        }
    }
}

