/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.kms.model.MacAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class GenerateMacRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ByteBuffer message;
    private String keyId;
    private String macAlgorithm;
    private SdkInternalList<String> grantTokens;

    public void setMessage(ByteBuffer byteBuffer) {
        this.message = byteBuffer;
    }

    public ByteBuffer getMessage() {
        return this.message;
    }

    public GenerateMacRequest withMessage(ByteBuffer byteBuffer) {
        this.setMessage(byteBuffer);
        return this;
    }

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public GenerateMacRequest withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public void setMacAlgorithm(String string) {
        this.macAlgorithm = string;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public GenerateMacRequest withMacAlgorithm(String string) {
        this.setMacAlgorithm(string);
        return this;
    }

    public GenerateMacRequest withMacAlgorithm(MacAlgorithmSpec macAlgorithmSpec) {
        this.macAlgorithm = macAlgorithmSpec.toString();
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> collection) {
        if (collection == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(collection);
    }

    public GenerateMacRequest withGrantTokens(String ... stringArray) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.grantTokens.add(string);
        }
        return this;
    }

    public GenerateMacRequest withGrantTokens(Collection<String> collection) {
        this.setGrantTokens(collection);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getMessage() != null) {
            stringBuilder.append("Message: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getMacAlgorithm() != null) {
            stringBuilder.append("MacAlgorithm: ").append(this.getMacAlgorithm()).append(",");
        }
        if (this.getGrantTokens() != null) {
            stringBuilder.append("GrantTokens: ").append(this.getGrantTokens());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenerateMacRequest)) {
            return false;
        }
        GenerateMacRequest generateMacRequest = (GenerateMacRequest)object;
        if (generateMacRequest.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (generateMacRequest.getMessage() != null && !generateMacRequest.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (generateMacRequest.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (generateMacRequest.getKeyId() != null && !generateMacRequest.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (generateMacRequest.getMacAlgorithm() == null ^ this.getMacAlgorithm() == null) {
            return false;
        }
        if (generateMacRequest.getMacAlgorithm() != null && !generateMacRequest.getMacAlgorithm().equals(this.getMacAlgorithm())) {
            return false;
        }
        if (generateMacRequest.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        return generateMacRequest.getGrantTokens() == null || generateMacRequest.getGrantTokens().equals(this.getGrantTokens());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getMacAlgorithm() == null ? 0 : this.getMacAlgorithm().hashCode());
        n2 = 31 * n2 + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        return n2;
    }

    @Override
    public GenerateMacRequest clone() {
        return (GenerateMacRequest)super.clone();
    }
}

