/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.kms.model.DataKeySpec;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GenerateDataKeyWithoutPlaintextRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String keyId;
    private SdkInternalMap<String, String> encryptionContext;
    private String keySpec;
    private Integer numberOfBytes;
    private SdkInternalList<String> grantTokens;

    public void setKeyId(String string) {
        this.keyId = string;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public GenerateDataKeyWithoutPlaintextRequest withKeyId(String string) {
        this.setKeyId(string);
        return this;
    }

    public Map<String, String> getEncryptionContext() {
        if (this.encryptionContext == null) {
            this.encryptionContext = new SdkInternalMap();
        }
        return this.encryptionContext;
    }

    public void setEncryptionContext(Map<String, String> map) {
        this.encryptionContext = map == null ? null : new SdkInternalMap<String, String>(map);
    }

    public GenerateDataKeyWithoutPlaintextRequest withEncryptionContext(Map<String, String> map) {
        this.setEncryptionContext(map);
        return this;
    }

    public GenerateDataKeyWithoutPlaintextRequest addEncryptionContextEntry(String string, String string2) {
        if (null == this.encryptionContext) {
            this.encryptionContext = new SdkInternalMap();
        }
        if (this.encryptionContext.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.encryptionContext.put(string, string2);
        return this;
    }

    public GenerateDataKeyWithoutPlaintextRequest clearEncryptionContextEntries() {
        this.encryptionContext = null;
        return this;
    }

    public void setKeySpec(String string) {
        this.keySpec = string;
    }

    public String getKeySpec() {
        return this.keySpec;
    }

    public GenerateDataKeyWithoutPlaintextRequest withKeySpec(String string) {
        this.setKeySpec(string);
        return this;
    }

    public void setKeySpec(DataKeySpec dataKeySpec) {
        this.withKeySpec(dataKeySpec);
    }

    public GenerateDataKeyWithoutPlaintextRequest withKeySpec(DataKeySpec dataKeySpec) {
        this.keySpec = dataKeySpec.toString();
        return this;
    }

    public void setNumberOfBytes(Integer n) {
        this.numberOfBytes = n;
    }

    public Integer getNumberOfBytes() {
        return this.numberOfBytes;
    }

    public GenerateDataKeyWithoutPlaintextRequest withNumberOfBytes(Integer n) {
        this.setNumberOfBytes(n);
        return this;
    }

    public List<String> getGrantTokens() {
        if (this.grantTokens == null) {
            this.grantTokens = new SdkInternalList();
        }
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> collection) {
        if (collection == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new SdkInternalList<String>(collection);
    }

    public GenerateDataKeyWithoutPlaintextRequest withGrantTokens(String ... stringArray) {
        if (this.grantTokens == null) {
            this.setGrantTokens(new SdkInternalList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.grantTokens.add(string);
        }
        return this;
    }

    public GenerateDataKeyWithoutPlaintextRequest withGrantTokens(Collection<String> collection) {
        this.setGrantTokens(collection);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getKeyId() != null) {
            stringBuilder.append("KeyId: ").append(this.getKeyId()).append(",");
        }
        if (this.getEncryptionContext() != null) {
            stringBuilder.append("EncryptionContext: ").append(this.getEncryptionContext()).append(",");
        }
        if (this.getKeySpec() != null) {
            stringBuilder.append("KeySpec: ").append(this.getKeySpec()).append(",");
        }
        if (this.getNumberOfBytes() != null) {
            stringBuilder.append("NumberOfBytes: ").append(this.getNumberOfBytes()).append(",");
        }
        if (this.getGrantTokens() != null) {
            stringBuilder.append("GrantTokens: ").append(this.getGrantTokens());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GenerateDataKeyWithoutPlaintextRequest)) {
            return false;
        }
        GenerateDataKeyWithoutPlaintextRequest generateDataKeyWithoutPlaintextRequest = (GenerateDataKeyWithoutPlaintextRequest)object;
        if (generateDataKeyWithoutPlaintextRequest.getKeyId() == null ^ this.getKeyId() == null) {
            return false;
        }
        if (generateDataKeyWithoutPlaintextRequest.getKeyId() != null && !generateDataKeyWithoutPlaintextRequest.getKeyId().equals(this.getKeyId())) {
            return false;
        }
        if (generateDataKeyWithoutPlaintextRequest.getEncryptionContext() == null ^ this.getEncryptionContext() == null) {
            return false;
        }
        if (generateDataKeyWithoutPlaintextRequest.getEncryptionContext() != null && !generateDataKeyWithoutPlaintextRequest.getEncryptionContext().equals(this.getEncryptionContext())) {
            return false;
        }
        if (generateDataKeyWithoutPlaintextRequest.getKeySpec() == null ^ this.getKeySpec() == null) {
            return false;
        }
        if (generateDataKeyWithoutPlaintextRequest.getKeySpec() != null && !generateDataKeyWithoutPlaintextRequest.getKeySpec().equals(this.getKeySpec())) {
            return false;
        }
        if (generateDataKeyWithoutPlaintextRequest.getNumberOfBytes() == null ^ this.getNumberOfBytes() == null) {
            return false;
        }
        if (generateDataKeyWithoutPlaintextRequest.getNumberOfBytes() != null && !generateDataKeyWithoutPlaintextRequest.getNumberOfBytes().equals(this.getNumberOfBytes())) {
            return false;
        }
        if (generateDataKeyWithoutPlaintextRequest.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        return generateDataKeyWithoutPlaintextRequest.getGrantTokens() == null || generateDataKeyWithoutPlaintextRequest.getGrantTokens().equals(this.getGrantTokens());
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.getKeyId() == null ? 0 : this.getKeyId().hashCode());
        n2 = 31 * n2 + (this.getEncryptionContext() == null ? 0 : this.getEncryptionContext().hashCode());
        n2 = 31 * n2 + (this.getKeySpec() == null ? 0 : this.getKeySpec().hashCode());
        n2 = 31 * n2 + (this.getNumberOfBytes() == null ? 0 : this.getNumberOfBytes().hashCode());
        n2 = 31 * n2 + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        return n2;
    }

    @Override
    public GenerateDataKeyWithoutPlaintextRequest clone() {
        return (GenerateDataKeyWithoutPlaintextRequest)super.clone();
    }
}

