/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry.v2;

import com.amazonaws.retry.v2.RetryCondition;
import com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RetryOnExceptionsCondition
implements RetryCondition {
    private final List<Class<? extends Exception>> exceptionsToRetryOn;

    public RetryOnExceptionsCondition(List<Class<? extends Exception>> list) {
        this.exceptionsToRetryOn = new ArrayList<Class<? extends Exception>>((Collection)ValidationUtils.assertNotNull(list, "exceptionsToRetryOn"));
    }

    @Override
    public boolean shouldRetry(RetryPolicyContext retryPolicyContext) {
        if (retryPolicyContext.exception() != null) {
            for (Class<? extends Exception> clazz : this.exceptionsToRetryOn) {
                if (this.exceptionMatches(retryPolicyContext, clazz)) {
                    return true;
                }
                if (!this.wrappedCauseMatches(retryPolicyContext, clazz)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean exceptionMatches(RetryPolicyContext retryPolicyContext, Class<? extends Exception> clazz) {
        return retryPolicyContext.exception().getClass().equals(clazz);
    }

    private boolean wrappedCauseMatches(RetryPolicyContext retryPolicyContext, Class<? extends Exception> clazz) {
        if (retryPolicyContext.exception().getCause() == null) {
            return false;
        }
        return retryPolicyContext.exception().getCause().getClass().equals(clazz);
    }
}

