/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.BasicProfileConfigFileLoader;
import com.amazonaws.profile.path.AwsProfileFileLocationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public final class MaxAttemptsResolver {
    private static final Log log = LogFactory.getLog(MaxAttemptsResolver.class);
    private static final String PROFILE_PROPERTY = "max_attempts";
    private final Integer maxAttempts;
    private final BasicProfileConfigFileLoader configFileLoader;

    public MaxAttemptsResolver() {
        this.configFileLoader = BasicProfileConfigFileLoader.INSTANCE;
        this.maxAttempts = this.resolveMaxAttempts();
    }

    @SdkTestInternalApi
    MaxAttemptsResolver(AwsProfileFileLocationProvider awsProfileFileLocationProvider) {
        this.configFileLoader = new BasicProfileConfigFileLoader(awsProfileFileLocationProvider);
        this.maxAttempts = this.resolveMaxAttempts();
    }

    public Integer maxAttempts() {
        return this.maxAttempts;
    }

    private Integer resolveMaxAttempts() {
        Integer n = this.envVar();
        if (n != null) {
            return n;
        }
        n = this.systemProperty();
        if (n != null) {
            return n;
        }
        return this.profile();
    }

    private Integer profile() {
        BasicProfile basicProfile = this.configFileLoader.getProfile();
        if (basicProfile == null) {
            return null;
        }
        String string = basicProfile.getPropertyValue(PROFILE_PROPERTY);
        return this.parseInteger(string);
    }

    private Integer systemProperty() {
        return this.parseInteger(System.getProperty("com.amazonaws.sdk.maxAttempts"));
    }

    private Integer envVar() {
        return this.parseInteger(System.getenv("AWS_MAX_ATTEMPTS"));
    }

    private Integer parseInteger(String string) {
        if (string == null) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Fail to parse com.amazonaws.sdk.maxAttempts", numberFormatException);
            return null;
        }
    }
}

