/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.retry.V2CompatibleBackoffStrategy;
import com.amazonaws.retry.V2CompatibleBackoffStrategyAdapter;
import com.amazonaws.retry.v2.BackoffStrategy;
import com.amazonaws.retry.v2.RetryPolicyContext;
import com.amazonaws.util.ValidationUtils;
import java.util.Random;

public class PredefinedBackoffStrategies {
    private static final int SDK_DEFAULT_BASE_DELAY = 100;
    static final int SDK_DEFAULT_THROTTLED_BASE_DELAY = 500;
    static final int SDK_DEFAULT_MAX_BACKOFF_IN_MILLISECONDS = 20000;
    static final int DYNAMODB_DEFAULT_BASE_DELAY = 25;
    private static final int MAX_RETRIES = 30;
    static final int STANDARD_DEFAULT_BASE_DELAY_IN_MILLISECONDS = 100;
    static final V2CompatibleBackoffStrategy STANDARD_BACKOFF_STRATEGY = new FullJitterBackoffStrategy(100, 20000);

    private static int calculateExponentialDelay(int n, int n2, int n3) {
        int n4 = Math.min(n, 30);
        return (int)Math.min((1L << n4) * (long)n2, (long)n3);
    }

    public static class SDKDefaultBackoffStrategy
    extends V2CompatibleBackoffStrategyAdapter {
        private final BackoffStrategy fullJitterBackoffStrategy;
        private final BackoffStrategy equalJitterBackoffStrategy;

        public SDKDefaultBackoffStrategy() {
            this.fullJitterBackoffStrategy = new FullJitterBackoffStrategy(100, 20000);
            this.equalJitterBackoffStrategy = new EqualJitterBackoffStrategy(500, 20000);
        }

        public SDKDefaultBackoffStrategy(int n, int n2, int n3) {
            this.fullJitterBackoffStrategy = new FullJitterBackoffStrategy(n, n3);
            this.equalJitterBackoffStrategy = new EqualJitterBackoffStrategy(n2, n3);
        }

        @Override
        public long computeDelayBeforeNextRetry(RetryPolicyContext retryPolicyContext) {
            if (RetryUtils.isThrottlingException(retryPolicyContext.exception())) {
                return this.equalJitterBackoffStrategy.computeDelayBeforeNextRetry(retryPolicyContext);
            }
            return this.fullJitterBackoffStrategy.computeDelayBeforeNextRetry(retryPolicyContext);
        }
    }

    public static class ExponentialBackoffStrategy
    extends V2CompatibleBackoffStrategyAdapter {
        private final int baseDelay;
        private final int maxBackoffTime;

        public ExponentialBackoffStrategy(int n, int n2) {
            this.baseDelay = ValidationUtils.assertIsPositive(n, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(n2, "Max backoff");
        }

        @Override
        public long computeDelayBeforeNextRetry(RetryPolicyContext retryPolicyContext) {
            return PredefinedBackoffStrategies.calculateExponentialDelay(retryPolicyContext.retriesAttempted(), this.baseDelay, this.maxBackoffTime);
        }
    }

    public static class EqualJitterBackoffStrategy
    extends V2CompatibleBackoffStrategyAdapter {
        private final int baseDelay;
        private final int maxBackoffTime;
        private final Random random = new Random();

        public EqualJitterBackoffStrategy(int n, int n2) {
            this.baseDelay = ValidationUtils.assertIsPositive(n, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(n2, "Max backoff");
        }

        @Override
        public long computeDelayBeforeNextRetry(RetryPolicyContext retryPolicyContext) {
            int n = PredefinedBackoffStrategies.calculateExponentialDelay(retryPolicyContext.retriesAttempted(), this.baseDelay, this.maxBackoffTime);
            return n / 2 + this.random.nextInt(n / 2 + 1);
        }
    }

    public static class FullJitterBackoffStrategy
    extends V2CompatibleBackoffStrategyAdapter {
        private final int baseDelay;
        private final int maxBackoffTime;
        private final Random random;

        public FullJitterBackoffStrategy(int n, int n2) {
            this(n, n2, new Random());
        }

        @SdkTestInternalApi
        FullJitterBackoffStrategy(int n, int n2, Random random) {
            this.baseDelay = ValidationUtils.assertIsPositive(n, "Base delay");
            this.maxBackoffTime = ValidationUtils.assertIsPositive(n2, "Max backoff");
            this.random = random;
        }

        @Override
        public long computeDelayBeforeNextRetry(RetryPolicyContext retryPolicyContext) {
            int n = PredefinedBackoffStrategies.calculateExponentialDelay(retryPolicyContext.retriesAttempted(), this.baseDelay, this.maxBackoffTime);
            return this.random.nextInt(n) + 1;
        }
    }
}

