/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.retry;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.Request;
import com.amazonaws.SdkBaseException;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.util.DateUtils;
import com.amazonaws.util.ValidationUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

@ThreadSafe
@SdkInternalApi
public final class ClockSkewAdjuster {
    private static final Log log = LogFactory.getLog(ClockSkewAdjuster.class);
    private static final Set<Integer> AUTHENTICATION_ERROR_STATUS_CODES;
    private static final int CLOCK_SKEW_ADJUST_THRESHOLD_IN_SECONDS = 240;
    private volatile Integer estimatedSkew;

    public Integer getEstimatedSkew() {
        return this.estimatedSkew;
    }

    public void updateEstimatedSkew(AdjustmentRequest adjustmentRequest) {
        try {
            Date date = this.getServerDate(adjustmentRequest);
            if (date != null) {
                this.estimatedSkew = this.timeSkewInSeconds(this.getCurrentDate(adjustmentRequest), date);
            }
        }
        catch (RuntimeException runtimeException) {
            log.debug("Unable to update estimated skew.", runtimeException);
        }
    }

    public ClockSkewAdjustment getAdjustment(AdjustmentRequest adjustmentRequest) {
        ValidationUtils.assertNotNull(adjustmentRequest, "adjustmentRequest");
        ValidationUtils.assertNotNull(adjustmentRequest.exception, "adjustmentRequest.exception");
        ValidationUtils.assertNotNull(adjustmentRequest.clientRequest, "adjustmentRequest.clientRequest");
        ValidationUtils.assertNotNull(adjustmentRequest.serviceResponse, "adjustmentRequest.serviceResponse");
        int n = 0;
        boolean bl = false;
        try {
            Date date;
            if (this.isAdjustmentRecommended(adjustmentRequest) && (date = this.getServerDate(adjustmentRequest)) != null) {
                n = this.timeSkewInSeconds(this.getCurrentDate(adjustmentRequest), date);
                bl = true;
            }
        }
        catch (RuntimeException runtimeException) {
            log.warn("Unable to correct for clock skew.", runtimeException);
        }
        return new ClockSkewAdjustment(bl, n);
    }

    private boolean isAdjustmentRecommended(AdjustmentRequest adjustmentRequest) {
        if (!(adjustmentRequest.exception instanceof AmazonServiceException)) {
            return false;
        }
        AmazonServiceException amazonServiceException = (AmazonServiceException)adjustmentRequest.exception;
        return this.isDefinitelyClockSkewError(amazonServiceException) || this.mayBeClockSkewError(amazonServiceException) && this.clientRequestWasSkewed(adjustmentRequest);
    }

    private boolean isDefinitelyClockSkewError(AmazonServiceException amazonServiceException) {
        return RetryUtils.isClockSkewError(amazonServiceException);
    }

    private boolean mayBeClockSkewError(AmazonServiceException amazonServiceException) {
        return AUTHENTICATION_ERROR_STATUS_CODES.contains(amazonServiceException.getStatusCode());
    }

    private boolean clientRequestWasSkewed(AdjustmentRequest adjustmentRequest) {
        Date date = this.getServerDate(adjustmentRequest);
        if (date == null) {
            return false;
        }
        int n = this.timeSkewInSeconds(this.getClientDate(adjustmentRequest), date);
        return Math.abs(n) > 240;
    }

    private int timeSkewInSeconds(Date date, Date date2) {
        ValidationUtils.assertNotNull(date, "clientTime");
        ValidationUtils.assertNotNull(date2, "serverTime");
        long l = (date.getTime() - date2.getTime()) / 1000L;
        if ((long)((int)l) != l) {
            throw new IllegalStateException("Time is too skewed to adjust: (clientTime: " + date.getTime() + ", serverTime: " + date2.getTime() + ")");
        }
        return (int)l;
    }

    private Date getCurrentDate(AdjustmentRequest adjustmentRequest) {
        return new Date(adjustmentRequest.currentTime);
    }

    private Date getClientDate(AdjustmentRequest adjustmentRequest) {
        return new Date(adjustmentRequest.currentTime - (long)(adjustmentRequest.clientRequest.getTimeOffset() * 1000));
    }

    private Date getServerDate(AdjustmentRequest adjustmentRequest) {
        String string = null;
        try {
            Header[] headerArray = adjustmentRequest.serviceResponse.getHeaders("Date");
            if (headerArray.length > 0) {
                string = headerArray[0].getValue();
                log.debug("Reported server date (from 'Date' header): " + string);
                return DateUtils.parseRFC822Date(string);
            }
            if (adjustmentRequest.exception == null) {
                return null;
            }
            String string2 = adjustmentRequest.exception.getMessage();
            string = this.getServerDateFromException(string2);
            if (string != null) {
                log.debug("Reported server date (from exception message): " + string);
                return DateUtils.parseCompressedISO8601Date(string);
            }
            log.debug("Server did not return a date, so clock skew adjustments will not be applied.");
            return null;
        }
        catch (RuntimeException runtimeException) {
            log.warn("Unable to parse clock skew offset from response: " + string, runtimeException);
            return null;
        }
    }

    private String getServerDateFromException(String string) {
        int n = string.indexOf("(");
        int n2 = string.indexOf(" + ");
        if (n2 == -1) {
            n2 = string.indexOf(" - ");
        }
        return n2 == -1 ? null : string.substring(n + 1, n2);
    }

    static {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(401);
        hashSet.add(403);
        AUTHENTICATION_ERROR_STATUS_CODES = Collections.unmodifiableSet(hashSet);
    }

    @ThreadSafe
    public static final class ClockSkewAdjustment {
        private final boolean shouldAdjustForSkew;
        private final int adjustmentInSeconds;

        private ClockSkewAdjustment(boolean bl, int n) {
            this.shouldAdjustForSkew = bl;
            this.adjustmentInSeconds = n;
        }

        public boolean shouldAdjustForSkew() {
            return this.shouldAdjustForSkew;
        }

        public int inSeconds() {
            if (!this.shouldAdjustForSkew) {
                throw new IllegalStateException("An adjustment is not recommended.");
            }
            return this.adjustmentInSeconds;
        }
    }

    @NotThreadSafe
    public static final class AdjustmentRequest {
        private Request<?> clientRequest;
        private HttpResponse serviceResponse;
        private SdkBaseException exception;
        private long currentTime = System.currentTimeMillis();

        public AdjustmentRequest clientRequest(Request<?> request) {
            this.clientRequest = request;
            return this;
        }

        public AdjustmentRequest serviceResponse(HttpResponse httpResponse) {
            this.serviceResponse = httpResponse;
            return this;
        }

        public AdjustmentRequest exception(SdkBaseException sdkBaseException) {
            this.exception = sdkBaseException;
            return this;
        }

        @SdkTestInternalApi
        public AdjustmentRequest currentTime(long l) {
            this.currentTime = l;
            return this;
        }
    }
}

