/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.regions.AwsRegionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwsRegionProviderChain
extends AwsRegionProvider {
    private static final Log LOG = LogFactory.getLog(AWSCredentialsProviderChain.class);
    private final List<AwsRegionProvider> providers;

    public AwsRegionProviderChain(AwsRegionProvider ... awsRegionProviderArray) {
        this.providers = new ArrayList<AwsRegionProvider>(awsRegionProviderArray.length);
        Collections.addAll(this.providers, awsRegionProviderArray);
    }

    @Override
    public String getRegion() throws SdkClientException {
        for (AwsRegionProvider awsRegionProvider : this.providers) {
            try {
                String string = awsRegionProvider.getRegion();
                if (string == null) continue;
                return string;
            }
            catch (Exception exception) {
                LOG.debug("Unable to load region from " + awsRegionProvider.toString() + ": " + exception.getMessage());
            }
        }
        throw new SdkClientException("Unable to load region information from any provider in the chain");
    }
}

