/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.json.internal.JsonMarshaller;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@SdkInternalApi
public class MarshallerRegistry {
    private final Map<MarshallLocation, Map<MarshallingType, JsonMarshaller<?>>> marshallers;
    private final Set<MarshallingType<?>> marshallingTypes;
    private final Map<Class<?>, MarshallingType<?>> marshallingTypeCache;

    private MarshallerRegistry(Builder builder) {
        this.marshallers = builder.marshallers;
        this.marshallingTypes = builder.marshallingTypes;
        this.marshallingTypeCache = new HashMap(this.marshallingTypes.size());
    }

    public <T> JsonMarshaller<T> getMarshaller(MarshallLocation marshallLocation, T t2) {
        return this.getMarshaller(marshallLocation, this.toMarshallingType(t2));
    }

    public <T> JsonMarshaller<T> getMarshaller(MarshallLocation marshallLocation, MarshallingType<T> marshallingType, T t2) {
        return this.getMarshaller(marshallLocation, t2 == null ? MarshallingType.NULL : marshallingType);
    }

    private <T> JsonMarshaller<T> getMarshaller(MarshallLocation marshallLocation, MarshallingType<?> marshallingType) {
        return this.marshallers.get((Object)marshallLocation).get(marshallingType);
    }

    public <T> MarshallingType<T> toMarshallingType(T t2) {
        if (t2 == null) {
            return MarshallingType.NULL;
        }
        if (t2 instanceof StructuredPojo) {
            return MarshallingType.STRUCTURED;
        }
        if (!this.marshallingTypeCache.containsKey(t2.getClass())) {
            return this.populateMarshallingTypeCache(t2.getClass());
        }
        return this.marshallingTypeCache.get(t2.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshallingType<?> populateMarshallingTypeCache(Class<?> clazz) {
        Map<Class<?>, MarshallingType<?>> map = this.marshallingTypeCache;
        synchronized (map) {
            if (!this.marshallingTypeCache.containsKey(clazz)) {
                for (MarshallingType<?> marshallingType : this.marshallingTypes) {
                    if (!marshallingType.isDefaultMarshallerForType(clazz)) continue;
                    this.marshallingTypeCache.put(clazz, marshallingType);
                    return marshallingType;
                }
                throw new SdkClientException("MarshallingType not found for class " + clazz);
            }
        }
        return this.marshallingTypeCache.get(clazz);
    }

    public MarshallerRegistry merge(Builder builder) {
        if (builder == null) {
            return this;
        }
        Builder builder2 = MarshallerRegistry.builder();
        builder2.copyMarshallersFromRegistry(this.marshallers);
        builder2.copyMarshallersFromRegistry(builder.marshallers);
        return builder2.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<MarshallLocation, Map<MarshallingType, JsonMarshaller<?>>> marshallers = new HashMap();
        private final Set<MarshallingType<?>> marshallingTypes = new HashSet();

        private Builder() {
        }

        public <T> Builder payloadMarshaller(MarshallingType<T> marshallingType, JsonMarshaller<T> jsonMarshaller) {
            return this.addMarshaller(MarshallLocation.PAYLOAD, marshallingType, jsonMarshaller);
        }

        public <T> Builder headerMarshaller(MarshallingType<T> marshallingType, JsonMarshaller<T> jsonMarshaller) {
            return this.addMarshaller(MarshallLocation.HEADER, marshallingType, jsonMarshaller);
        }

        public <T> Builder queryParamMarshaller(MarshallingType<T> marshallingType, JsonMarshaller<T> jsonMarshaller) {
            return this.addMarshaller(MarshallLocation.QUERY_PARAM, marshallingType, jsonMarshaller);
        }

        public <T> Builder pathParamMarshaller(MarshallingType<T> marshallingType, JsonMarshaller<T> jsonMarshaller) {
            return this.addMarshaller(MarshallLocation.PATH, marshallingType, jsonMarshaller);
        }

        public <T> Builder greedyPathParamMarshaller(MarshallingType<T> marshallingType, JsonMarshaller<T> jsonMarshaller) {
            return this.addMarshaller(MarshallLocation.GREEDY_PATH, marshallingType, jsonMarshaller);
        }

        public <T> Builder addMarshaller(MarshallLocation marshallLocation, MarshallingType<T> marshallingType, JsonMarshaller<T> jsonMarshaller) {
            this.marshallingTypes.add(marshallingType);
            if (!this.marshallers.containsKey((Object)marshallLocation)) {
                this.marshallers.put(marshallLocation, new HashMap());
            }
            this.marshallers.get((Object)marshallLocation).put(marshallingType, jsonMarshaller);
            return this;
        }

        public MarshallerRegistry build() {
            return new MarshallerRegistry(this);
        }

        private void copyMarshallersFromRegistry(Map<MarshallLocation, Map<MarshallingType, JsonMarshaller<?>>> map) {
            for (Map.Entry<MarshallLocation, Map<MarshallingType, JsonMarshaller<?>>> entry : map.entrySet()) {
                for (Map.Entry<MarshallingType, JsonMarshaller<?>> entry2 : entry.getValue().entrySet()) {
                    this.addMarshaller(entry.getKey(), entry2.getKey(), entry2.getValue());
                }
            }
        }
    }
}

