/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json.internal;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.OperationInfo;
import com.amazonaws.protocol.ProtocolRequestMarshaller;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.protocol.json.internal.EmptyBodyJsonMarshaller;
import com.amazonaws.protocol.json.internal.HeaderMarshallers;
import com.amazonaws.protocol.json.internal.JsonMarshaller;
import com.amazonaws.protocol.json.internal.JsonMarshallerContext;
import com.amazonaws.protocol.json.internal.MarshallerRegistry;
import com.amazonaws.protocol.json.internal.QueryParamMarshallers;
import com.amazonaws.protocol.json.internal.SimpleTypeJsonMarshallers;
import com.amazonaws.protocol.json.internal.SimpleTypePathMarshallers;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;

@SdkInternalApi
public class JsonProtocolMarshaller<OrigRequest>
implements ProtocolRequestMarshaller<OrigRequest> {
    private static final MarshallerRegistry DEFAULT_MARSHALLER_REGISTRY = JsonProtocolMarshaller.createDefaultMarshallerRegistry();
    private final StructuredJsonGenerator jsonGenerator;
    private final Request<OrigRequest> request;
    private final String contentType;
    private final boolean hasExplicitPayloadMember;
    private final JsonMarshallerContext marshallerContext;
    private final MarshallerRegistry marshallerRegistry;

    public JsonProtocolMarshaller(StructuredJsonGenerator structuredJsonGenerator, String string, OperationInfo operationInfo, OrigRequest OrigRequest, MarshallerRegistry.Builder builder, EmptyBodyJsonMarshaller emptyBodyJsonMarshaller) {
        this.jsonGenerator = structuredJsonGenerator;
        this.contentType = string;
        this.hasExplicitPayloadMember = operationInfo.hasExplicitPayloadMember();
        this.request = this.fillBasicRequestParams(operationInfo, OrigRequest);
        this.marshallerRegistry = DEFAULT_MARSHALLER_REGISTRY.merge(builder);
        this.marshallerContext = JsonMarshallerContext.builder().jsonGenerator(structuredJsonGenerator).marshallerRegistry(this.marshallerRegistry).protocolHandler(this).request(this.request).emptyBodyJsonMarshaller(emptyBodyJsonMarshaller).build();
    }

    private Request<OrigRequest> fillBasicRequestParams(OperationInfo operationInfo, OrigRequest OrigRequest) {
        DefaultRequest<OrigRequest> defaultRequest = this.createRequest(operationInfo, OrigRequest);
        defaultRequest.setHttpMethod(operationInfo.httpMethodName());
        defaultRequest.setResourcePath(UriResourcePathUtils.addStaticQueryParamtersToRequest(defaultRequest, operationInfo.requestUri()));
        if (operationInfo.operationIdentifier() != null) {
            defaultRequest.addHeader("X-Amz-Target", operationInfo.operationIdentifier());
        }
        return defaultRequest;
    }

    private DefaultRequest<OrigRequest> createRequest(OperationInfo operationInfo, OrigRequest OrigRequest) {
        if (OrigRequest instanceof AmazonWebServiceRequest) {
            return new DefaultRequest((AmazonWebServiceRequest)OrigRequest, operationInfo.serviceName());
        }
        return new DefaultRequest(operationInfo.serviceName());
    }

    private static MarshallerRegistry createDefaultMarshallerRegistry() {
        return MarshallerRegistry.builder().payloadMarshaller(MarshallingType.STRING, SimpleTypeJsonMarshallers.STRING).payloadMarshaller(MarshallingType.JSON_VALUE, SimpleTypeJsonMarshallers.STRING).payloadMarshaller(MarshallingType.INTEGER, SimpleTypeJsonMarshallers.INTEGER).payloadMarshaller(MarshallingType.LONG, SimpleTypeJsonMarshallers.LONG).payloadMarshaller(MarshallingType.SHORT, SimpleTypeJsonMarshallers.SHORT).payloadMarshaller(MarshallingType.DOUBLE, SimpleTypeJsonMarshallers.DOUBLE).payloadMarshaller(MarshallingType.FLOAT, SimpleTypeJsonMarshallers.FLOAT).payloadMarshaller(MarshallingType.BIG_DECIMAL, SimpleTypeJsonMarshallers.BIG_DECIMAL).payloadMarshaller(MarshallingType.BOOLEAN, SimpleTypeJsonMarshallers.BOOLEAN).payloadMarshaller(MarshallingType.DATE, SimpleTypeJsonMarshallers.DATE).payloadMarshaller(MarshallingType.BYTE_BUFFER, SimpleTypeJsonMarshallers.BYTE_BUFFER).payloadMarshaller(MarshallingType.STRUCTURED, SimpleTypeJsonMarshallers.STRUCTURED).payloadMarshaller(MarshallingType.LIST, SimpleTypeJsonMarshallers.LIST).payloadMarshaller(MarshallingType.MAP, SimpleTypeJsonMarshallers.MAP).payloadMarshaller(MarshallingType.NULL, SimpleTypeJsonMarshallers.NULL).headerMarshaller(MarshallingType.STRING, HeaderMarshallers.STRING).headerMarshaller(MarshallingType.JSON_VALUE, HeaderMarshallers.JSON_VALUE).headerMarshaller(MarshallingType.INTEGER, HeaderMarshallers.INTEGER).headerMarshaller(MarshallingType.LONG, HeaderMarshallers.LONG).headerMarshaller(MarshallingType.DOUBLE, HeaderMarshallers.DOUBLE).headerMarshaller(MarshallingType.FLOAT, HeaderMarshallers.FLOAT).headerMarshaller(MarshallingType.BOOLEAN, HeaderMarshallers.BOOLEAN).headerMarshaller(MarshallingType.DATE, HeaderMarshallers.DATE).headerMarshaller(MarshallingType.NULL, JsonMarshaller.NULL).queryParamMarshaller(MarshallingType.STRING, QueryParamMarshallers.STRING).queryParamMarshaller(MarshallingType.INTEGER, QueryParamMarshallers.INTEGER).queryParamMarshaller(MarshallingType.LONG, QueryParamMarshallers.LONG).queryParamMarshaller(MarshallingType.SHORT, QueryParamMarshallers.SHORT).queryParamMarshaller(MarshallingType.DOUBLE, QueryParamMarshallers.DOUBLE).queryParamMarshaller(MarshallingType.FLOAT, QueryParamMarshallers.FLOAT).queryParamMarshaller(MarshallingType.BOOLEAN, QueryParamMarshallers.BOOLEAN).queryParamMarshaller(MarshallingType.DATE, QueryParamMarshallers.DATE).queryParamMarshaller(MarshallingType.LIST, QueryParamMarshallers.LIST).queryParamMarshaller(MarshallingType.MAP, QueryParamMarshallers.MAP).queryParamMarshaller(MarshallingType.NULL, JsonMarshaller.NULL).pathParamMarshaller(MarshallingType.STRING, SimpleTypePathMarshallers.STRING).pathParamMarshaller(MarshallingType.INTEGER, SimpleTypePathMarshallers.INTEGER).pathParamMarshaller(MarshallingType.LONG, SimpleTypePathMarshallers.LONG).pathParamMarshaller(MarshallingType.NULL, SimpleTypePathMarshallers.NULL).greedyPathParamMarshaller(MarshallingType.STRING, SimpleTypePathMarshallers.GREEDY_STRING).greedyPathParamMarshaller(MarshallingType.NULL, SimpleTypePathMarshallers.NULL).build();
    }

    @Override
    public void startMarshalling() {
        if (!this.hasExplicitPayloadMember) {
            this.jsonGenerator.writeStartObject();
        }
    }

    public <V> void marshall(V v, MarshallingInfo<V> marshallingInfo) {
        this.doMarshall(this.resolveValue(v, marshallingInfo), marshallingInfo);
    }

    private <V> V resolveValue(V v, MarshallingInfo<V> marshallingInfo) {
        return v == null && marshallingInfo.defaultValueSupplier() != null ? marshallingInfo.defaultValueSupplier().get() : v;
    }

    private <V> void doMarshall(V v, MarshallingInfo<V> marshallingInfo) {
        if (marshallingInfo.isBinary()) {
            this.marshallBinaryPayload(v);
        } else {
            this.marshallerRegistry.getMarshaller(marshallingInfo.marshallLocation(), marshallingInfo.marshallingType(), v).marshall(v, this.marshallerContext, marshallingInfo);
        }
    }

    private void marshallBinaryPayload(Object object) {
        if (object instanceof ByteBuffer) {
            this.request.setContent(BinaryUtils.toStream((ByteBuffer)object));
        } else if (object instanceof InputStream) {
            this.request.setContent((InputStream)object);
        }
    }

    @Override
    public Request<OrigRequest> finishMarshalling() {
        if (this.request.getContent() == null) {
            if (!this.hasExplicitPayloadMember) {
                this.jsonGenerator.writeEndObject();
            }
            byte[] byArray = this.jsonGenerator.getBytes();
            this.request.setContent(new ByteArrayInputStream(byArray));
            if (byArray.length > 0) {
                this.request.addHeader("Content-Length", Integer.toString(byArray.length));
            }
        }
        if (!this.request.getHeaders().containsKey("Content-Type") && this.contentType != null && this.request.getHeaders().containsKey("Content-Length")) {
            this.request.addHeader("Content-Type", this.contentType);
        }
        return this.request;
    }
}

