/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.protocol.json;

import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.http.ErrorCodeParser;
import com.amazonaws.internal.http.JsonErrorCodeParser;
import com.amazonaws.internal.http.JsonErrorMessageParser;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkStructuredJsonFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonFactory;
import java.util.List;
import java.util.Map;

public abstract class SdkStructuredJsonFactoryImpl
implements SdkStructuredJsonFactory {
    private final JsonFactory jsonFactory;
    private final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> unmarshallers;
    private final Map<JsonUnmarshallerContext.UnmarshallerType, Unmarshaller<?, JsonUnmarshallerContext>> customTypeUnmarshallers;

    public SdkStructuredJsonFactoryImpl(JsonFactory jsonFactory, Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> map, Map<JsonUnmarshallerContext.UnmarshallerType, Unmarshaller<?, JsonUnmarshallerContext>> map2) {
        this.jsonFactory = jsonFactory;
        this.unmarshallers = map;
        this.customTypeUnmarshallers = map2;
    }

    @Override
    public StructuredJsonGenerator createWriter(String string) {
        return this.createWriter(this.jsonFactory, string);
    }

    protected abstract StructuredJsonGenerator createWriter(JsonFactory var1, String var2);

    @Override
    public <T> JsonResponseHandler<T> createResponseHandler(JsonOperationMetadata jsonOperationMetadata, Unmarshaller<T, JsonUnmarshallerContext> unmarshaller) {
        return new JsonResponseHandler<T>(unmarshaller, this.unmarshallers, this.customTypeUnmarshallers, this.jsonFactory, jsonOperationMetadata.isHasStreamingSuccessResponse(), jsonOperationMetadata.isPayloadJson());
    }

    @Override
    public JsonErrorResponseHandler createErrorResponseHandler(List<JsonErrorUnmarshaller> list, String string) {
        return new JsonErrorResponseHandler(list, this.unmarshallers, this.customTypeUnmarshallers, this.getErrorCodeParser(string), JsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER, this.jsonFactory);
    }

    protected ErrorCodeParser getErrorCodeParser(String string) {
        return new JsonErrorCodeParser(string);
    }
}

