/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.partitions.model;

import com.amazonaws.partitions.model.Endpoint;
import com.amazonaws.partitions.model.Region;
import com.amazonaws.partitions.model.Service;
import com.amazonaws.util.ValidationUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.regex.Pattern;

public class Partition {
    private final String partition;
    private final Map<String, Region> regions;
    private final Map<String, Service> services;
    private String partitionName;
    private String dnsSuffix;
    private String regionRegex;
    private Endpoint defaults;

    public Partition(@JsonProperty(value="partition") String string, @JsonProperty(value="regions") Map<String, Region> map, @JsonProperty(value="services") Map<String, Service> map2) {
        this.partition = ValidationUtils.assertNotNull(string, "Partition");
        this.regions = map;
        this.services = map2;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String string) {
        this.partitionName = string;
    }

    public String getDnsSuffix() {
        return this.dnsSuffix;
    }

    public void setDnsSuffix(String string) {
        this.dnsSuffix = string;
    }

    public String getRegionRegex() {
        return this.regionRegex;
    }

    public void setRegionRegex(String string) {
        this.regionRegex = string;
    }

    public Endpoint getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Endpoint endpoint) {
        this.defaults = endpoint;
    }

    public Map<String, Region> getRegions() {
        return this.regions;
    }

    public Map<String, Service> getServices() {
        return this.services;
    }

    public boolean hasRegion(String string) {
        return this.regions.containsKey(string) || this.matchesRegionRegex(string) || this.hasServiceEndpoint(string);
    }

    private boolean matchesRegionRegex(String string) {
        Pattern pattern = Pattern.compile(this.regionRegex);
        return pattern.matcher(string).matches();
    }

    @Deprecated
    private boolean hasServiceEndpoint(String string) {
        for (Service service : this.services.values()) {
            if (!service.getEndpoints().containsKey(string)) continue;
            return true;
        }
        return false;
    }
}

