/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.logging.LogFactory;

public enum MBeans {


    public static <T> boolean registerMBean(String string, T t2) throws MBeanRegistrationException {
        MBeanServer mBeanServer = MBeans.getMBeanServer();
        try {
            mBeanServer.registerMBean(t2, new ObjectName(string));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(malformedObjectNameException);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new IllegalArgumentException(notCompliantMBeanException);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            LogFactory.getLog(MBeans.class).debug("Failed to register mbean " + string, instanceAlreadyExistsException);
            return false;
        }
        return true;
    }

    public static <T> boolean unregisterMBean(String string) throws MBeanRegistrationException {
        MBeanServer mBeanServer = MBeans.getMBeanServer();
        try {
            mBeanServer.unregisterMBean(new ObjectName(string));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(malformedObjectNameException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            LogFactory.getLog(MBeans.class).debug("Failed to unregister mbean " + string, instanceNotFoundException);
            return false;
        }
        return true;
    }

    public static boolean isRegistered(String string) {
        MBeanServer mBeanServer = MBeans.getMBeanServer();
        try {
            return mBeanServer.isRegistered(new ObjectName(string));
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException(malformedObjectNameException);
        }
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> arrayList = MBeanServerFactory.findMBeanServer(null);
        MBeanServer mBeanServer = arrayList.size() > 0 ? (MBeanServer)arrayList.get(0) : ManagementFactory.getPlatformMBeanServer();
        return mBeanServer;
    }
}

