/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jmespath;

import com.amazonaws.jmespath.InvalidTypeException;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathFunction;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class JmesPathContainsFunction
extends JmesPathFunction {
    public JmesPathContainsFunction(JmesPathExpression ... jmesPathExpressionArray) {
        this(Arrays.asList(jmesPathExpressionArray));
    }

    public JmesPathContainsFunction(List<JmesPathExpression> list) {
        super(list);
    }

    @Override
    public JsonNode evaluate(List<JsonNode> list) {
        JsonNode jsonNode = list.get(0);
        JsonNode jsonNode2 = list.get(1);
        if (jsonNode.isArray()) {
            return JmesPathContainsFunction.doesArrayContain(jsonNode, jsonNode2);
        }
        if (jsonNode.isTextual()) {
            return JmesPathContainsFunction.doesStringContain(jsonNode, jsonNode2);
        }
        throw new InvalidTypeException("Type mismatch. Expecting a string or an array.");
    }

    private static BooleanNode doesArrayContain(JsonNode jsonNode, JsonNode jsonNode2) {
        Iterator<JsonNode> iterator2 = jsonNode.elements();
        while (iterator2.hasNext()) {
            if (!iterator2.next().equals(jsonNode2)) continue;
            return BooleanNode.TRUE;
        }
        return BooleanNode.FALSE;
    }

    private static BooleanNode doesStringContain(JsonNode jsonNode, JsonNode jsonNode2) {
        if (jsonNode.asText().contains(jsonNode2.asText())) {
            return BooleanNode.TRUE;
        }
        return BooleanNode.FALSE;
    }
}

