/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.SdkClock;
import com.amazonaws.auth.internal.AWS4SignerUtils;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.retry.ClockSkewAdjuster;
import com.amazonaws.retry.RetryPolicyAdapter;
import com.amazonaws.retry.v2.RetryPolicy;
import java.util.ArrayList;
import java.util.List;

@ThreadSafe
@SdkInternalApi
public final class SdkRequestRetryHeaderProvider {
    private static final String SDK_REQUEST_RETRY_HEADER = "amz-sdk-request";
    private final ClientConfiguration config;
    private final Integer maxErrorRetry;
    private final ClockSkewAdjuster clockSkewAdjuster;

    public SdkRequestRetryHeaderProvider(ClientConfiguration clientConfiguration, RetryPolicy retryPolicy, ClockSkewAdjuster clockSkewAdjuster) {
        this.config = clientConfiguration;
        this.maxErrorRetry = retryPolicy instanceof RetryPolicyAdapter ? Integer.valueOf(((RetryPolicyAdapter)retryPolicy).getMaxErrorRetry() + 1) : null;
        this.clockSkewAdjuster = clockSkewAdjuster;
    }

    public void addSdkRequestRetryHeader(Request<?> request, int n) {
        List<Pair> list = this.requestPairs(request, String.valueOf(n));
        StringBuilder stringBuilder = new StringBuilder();
        for (Pair pair : list) {
            stringBuilder.append(pair.name).append("=").append(pair.value).append(";");
        }
        String string = stringBuilder.toString().substring(0, stringBuilder.length() - 1);
        request.addHeader(SDK_REQUEST_RETRY_HEADER, string);
    }

    private List<Pair> requestPairs(Request<?> request, String string) {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        String string2 = this.calculateTtl(request);
        if (string2 != null) {
            arrayList.add(new Pair("ttl", string2));
        }
        arrayList.add(new Pair("attempt", string));
        if (this.maxErrorRetry != null) {
            arrayList.add(new Pair("max", String.valueOf(this.maxErrorRetry)));
        }
        return arrayList;
    }

    private String calculateTtl(Request<?> request) {
        if (this.isStreaming(request)) {
            return null;
        }
        Integer n = this.clockSkewAdjuster.getEstimatedSkew();
        if (n == null) {
            return null;
        }
        long l = SdkClock.Instance.get().currentTimeMillis();
        long l2 = l + (long)this.config.getSocketTimeout() - (long)(n * 1000);
        return AWS4SignerUtils.formatTimestamp(l2);
    }

    private boolean isStreaming(Request<?> request) {
        return Boolean.TRUE.equals(request.getHandlerContext(HandlerContextKey.HAS_STREAMING_INPUT)) || Boolean.TRUE.equals(request.getHandlerContext(HandlerContextKey.HAS_STREAMING_OUTPUT));
    }

    private static final class Pair {
        private String name;
        private String value;

        Pair(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

