/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.internal.ReleasableInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@NotThreadSafe
public class ResettableInputStream
extends ReleasableInputStream {
    private static final Log log = LogFactory.getLog(ResettableInputStream.class);
    private final File file;
    private FileInputStream fis;
    private FileChannel fileChannel;
    private long markPos;

    public ResettableInputStream(File file) throws IOException {
        this(new FileInputStream(file), file);
    }

    public ResettableInputStream(FileInputStream fileInputStream) throws IOException {
        this(fileInputStream, null);
    }

    private ResettableInputStream(FileInputStream fileInputStream, File file) throws IOException {
        super(fileInputStream);
        this.file = file;
        this.fis = fileInputStream;
        this.fileChannel = fileInputStream.getChannel();
        this.markPos = this.fileChannel.position();
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.abortIfNeeded();
        try {
            this.markPos = this.fileChannel.position();
        }
        catch (IOException iOException) {
            throw new SdkClientException("Failed to mark the file position", iOException);
        }
        if (log.isTraceEnabled()) {
            log.trace("File input stream marked at position " + this.markPos);
        }
    }

    @Override
    public void reset() throws IOException {
        this.abortIfNeeded();
        this.fileChannel.position(this.markPos);
        if (log.isTraceEnabled()) {
            log.trace("Reset to position " + this.markPos);
        }
    }

    @Override
    public int available() throws IOException {
        this.abortIfNeeded();
        return this.fis.available();
    }

    @Override
    public int read() throws IOException {
        this.abortIfNeeded();
        return this.fis.read();
    }

    @Override
    public long skip(long l) throws IOException {
        this.abortIfNeeded();
        return this.fis.skip(l);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.abortIfNeeded();
        return this.fis.read(byArray, n, n2);
    }

    public File getFile() {
        return this.file;
    }

    public static ResettableInputStream newResettableInputStream(File file) {
        return ResettableInputStream.newResettableInputStream(file, null);
    }

    public static ResettableInputStream newResettableInputStream(File file, String string) {
        try {
            return new ResettableInputStream(file);
        }
        catch (IOException iOException) {
            throw string == null ? new SdkClientException(iOException) : new SdkClientException(string, iOException);
        }
    }

    public static ResettableInputStream newResettableInputStream(FileInputStream fileInputStream) {
        return ResettableInputStream.newResettableInputStream(fileInputStream, null);
    }

    public static ResettableInputStream newResettableInputStream(FileInputStream fileInputStream, String string) {
        try {
            return new ResettableInputStream(fileInputStream);
        }
        catch (IOException iOException) {
            throw new SdkClientException(string, iOException);
        }
    }
}

