/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.response;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.Request;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.SdkHttpMetadata;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.MetadataCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwsResponseHandlerAdapter<T>
implements HttpResponseHandler<T> {
    private static final Log requestIdLog = LogFactory.getLog("com.amazonaws.requestId");
    private static final Log requestLog = AmazonHttpClient.requestLog;
    private final HttpResponseHandler<AmazonWebServiceResponse<T>> delegate;
    private final Request<?> request;
    private final AWSRequestMetrics awsRequestMetrics;
    private final MetadataCache responseMetadataCache;

    public AwsResponseHandlerAdapter(HttpResponseHandler<AmazonWebServiceResponse<T>> httpResponseHandler, Request<?> request, AWSRequestMetrics aWSRequestMetrics, MetadataCache metadataCache) {
        this.delegate = httpResponseHandler;
        this.request = request;
        this.awsRequestMetrics = aWSRequestMetrics;
        this.responseMetadataCache = metadataCache;
    }

    @Override
    public T handle(HttpResponse httpResponse) throws Exception {
        AmazonWebServiceResponse<T> amazonWebServiceResponse = this.delegate.handle(httpResponse);
        if (amazonWebServiceResponse == null) {
            throw new RuntimeException("Unable to unmarshall response metadata. Response Code: " + httpResponse.getStatusCode() + ", Response Text: " + httpResponse.getStatusText());
        }
        AmazonWebServiceRequest amazonWebServiceRequest = this.request.getOriginalRequest();
        if (amazonWebServiceRequest.getCloneRoot() != null) {
            amazonWebServiceRequest = amazonWebServiceRequest.getCloneRoot();
        }
        this.responseMetadataCache.add(amazonWebServiceRequest, amazonWebServiceResponse.getResponseMetadata());
        String string = amazonWebServiceResponse.getRequestId();
        if (requestLog.isDebugEnabled()) {
            requestLog.debug("Received successful response: " + httpResponse.getStatusCode() + ", AWS Request ID: " + string);
        }
        if (!this.logHeaderRequestId(httpResponse)) {
            this.logResponseRequestId(string);
        }
        this.logExtendedRequestId(httpResponse);
        this.awsRequestMetrics.addProperty(AWSRequestMetrics.Field.AWSRequestID, (Object)string);
        return this.fillInResponseMetadata(amazonWebServiceResponse, httpResponse);
    }

    private <T> T fillInResponseMetadata(AmazonWebServiceResponse<T> amazonWebServiceResponse, HttpResponse httpResponse) {
        T t2 = amazonWebServiceResponse.getResult();
        if (t2 instanceof AmazonWebServiceResult) {
            ((AmazonWebServiceResult)t2).setSdkResponseMetadata(amazonWebServiceResponse.getResponseMetadata()).setSdkHttpMetadata(SdkHttpMetadata.from(httpResponse));
        }
        return t2;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return this.delegate.needsConnectionLeftOpen();
    }

    private boolean logHeaderRequestId(HttpResponse httpResponse) {
        boolean bl;
        String string = httpResponse.getHeaders().get("x-amzn-RequestId");
        boolean bl2 = bl = string != null;
        if (requestIdLog.isDebugEnabled() || requestLog.isDebugEnabled()) {
            String string2 = "x-amzn-RequestId: " + (bl ? string : "not available");
            if (requestIdLog.isDebugEnabled()) {
                requestIdLog.debug(string2);
            } else {
                requestLog.debug(string2);
            }
        }
        return bl;
    }

    private void logResponseRequestId(String string) {
        if (requestIdLog.isDebugEnabled() || requestLog.isDebugEnabled()) {
            String string2 = "AWS Request ID: " + (string == null ? "not available" : string);
            if (requestIdLog.isDebugEnabled()) {
                requestIdLog.debug(string2);
            } else {
                requestLog.debug(string2);
            }
        }
    }

    private void logExtendedRequestId(HttpResponse httpResponse) {
        String string = httpResponse.getHeaders().get("x-amz-id-2");
        if (string != null && (requestIdLog.isDebugEnabled() || requestLog.isDebugEnabled())) {
            String string2 = "AWS Extended Request ID: " + string;
            if (requestIdLog.isDebugEnabled()) {
                requestIdLog.debug(string2);
            } else {
                requestLog.debug(string2);
            }
        }
    }
}

