/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn;

import com.amazonaws.http.conn.ClientConnectionRequestFactory;
import com.amazonaws.http.conn.Wrapped;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.pool.ConnPoolControl;

public class ClientConnectionManagerFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionManagerFactory.class);

    public static HttpClientConnectionManager wrap(HttpClientConnectionManager httpClientConnectionManager) {
        if (httpClientConnectionManager instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        Class[] classArray = httpClientConnectionManager instanceof ConnPoolControl ? new Class[]{HttpClientConnectionManager.class, ConnPoolControl.class, Wrapped.class} : new Class[]{HttpClientConnectionManager.class, Wrapped.class};
        return (HttpClientConnectionManager)Proxy.newProxyInstance(ClientConnectionManagerFactory.class.getClassLoader(), classArray, (InvocationHandler)new Handler(httpClientConnectionManager));
    }

    private static class Handler
    implements InvocationHandler {
        private final HttpClientConnectionManager orig;

        Handler(HttpClientConnectionManager httpClientConnectionManager) {
            this.orig = httpClientConnectionManager;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                Object object2 = method.invoke((Object)this.orig, objectArray);
                return object2 instanceof ConnectionRequest ? ClientConnectionRequestFactory.wrap((ConnectionRequest)object2) : object2;
            }
            catch (InvocationTargetException invocationTargetException) {
                log.debug("", invocationTargetException);
                throw invocationTargetException.getCause();
            }
        }
    }
}

