/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.apache.client.impl;

import com.amazonaws.SDKGlobalConfiguration;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.DelegatingDnsResolver;
import com.amazonaws.http.SystemPropertyTlsKeyManagersProvider;
import com.amazonaws.http.TlsKeyManagersProvider;
import com.amazonaws.http.client.ConnectionManagerFactory;
import com.amazonaws.http.conn.SdkPlainSocketFactory;
import com.amazonaws.http.conn.ssl.SdkTLSSocketFactory;
import com.amazonaws.http.settings.HttpClientSettings;
import com.amazonaws.internal.SdkSSLContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class ApacheConnectionManagerFactory
implements ConnectionManagerFactory<HttpClientConnectionManager> {
    private final Log LOG = LogFactory.getLog(AmazonHttpClient.class);

    @Override
    public HttpClientConnectionManager create(HttpClientSettings httpClientSettings) {
        ConnectionSocketFactory connectionSocketFactory = this.getPreferredSocketFactory(httpClientSettings);
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(this.createSocketFactoryRegistry(connectionSocketFactory), null, DefaultSchemePortResolver.INSTANCE, new DelegatingDnsResolver(httpClientSettings.getDnsResolver()), httpClientSettings.getConnectionPoolTTL(), TimeUnit.MILLISECONDS);
        poolingHttpClientConnectionManager.setValidateAfterInactivity(httpClientSettings.getValidateAfterInactivityMillis());
        poolingHttpClientConnectionManager.setDefaultMaxPerRoute(httpClientSettings.getMaxConnections());
        poolingHttpClientConnectionManager.setMaxTotal(httpClientSettings.getMaxConnections());
        poolingHttpClientConnectionManager.setDefaultSocketConfig(this.buildSocketConfig(httpClientSettings));
        poolingHttpClientConnectionManager.setDefaultConnectionConfig(this.buildConnectionConfig(httpClientSettings));
        return poolingHttpClientConnectionManager;
    }

    private ConnectionSocketFactory getPreferredSocketFactory(HttpClientSettings httpClientSettings) {
        ConnectionSocketFactory connectionSocketFactory = httpClientSettings.getApacheHttpClientConfig().getSslSocketFactory();
        return connectionSocketFactory != null ? connectionSocketFactory : new SdkTLSSocketFactory(SdkSSLContext.getPreferredSSLContext(this.getKeyManagers(httpClientSettings), httpClientSettings.getSecureRandom()), this.getHostNameVerifier(httpClientSettings));
    }

    private SocketConfig buildSocketConfig(HttpClientSettings httpClientSettings) {
        return SocketConfig.custom().setSoKeepAlive(httpClientSettings.useTcpKeepAlive()).setSoTimeout(httpClientSettings.getSocketTimeout()).setTcpNoDelay(true).build();
    }

    private ConnectionConfig buildConnectionConfig(HttpClientSettings httpClientSettings) {
        int n = Math.max(httpClientSettings.getSocketBufferSize()[0], httpClientSettings.getSocketBufferSize()[1]);
        return n <= 0 ? null : ConnectionConfig.custom().setBufferSize(n).build();
    }

    private KeyManager[] getKeyManagers(HttpClientSettings httpClientSettings) {
        TlsKeyManagersProvider tlsKeyManagersProvider = httpClientSettings.getTlsKeyMangersProvider();
        if (tlsKeyManagersProvider == null) {
            tlsKeyManagersProvider = new SystemPropertyTlsKeyManagersProvider();
        }
        return tlsKeyManagersProvider.getKeyManagers();
    }

    private HostnameVerifier getHostNameVerifier(HttpClientSettings httpClientSettings) {
        return httpClientSettings.useBrowserCompatibleHostNameVerifier() ? SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER;
    }

    private Registry<ConnectionSocketFactory> createSocketFactoryRegistry(ConnectionSocketFactory connectionSocketFactory) {
        if (SDKGlobalConfiguration.isCertCheckingDisabled()) {
            if (this.LOG.isWarnEnabled()) {
                this.LOG.warn("SSL Certificate checking for endpoints has been explicitly disabled.");
            }
            connectionSocketFactory = new TrustingSocketFactory();
        }
        return RegistryBuilder.create().register("http", new SdkPlainSocketFactory()).register("https", (SdkPlainSocketFactory)connectionSocketFactory).build();
    }

    private static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X509_CERTIFICATES = new X509Certificate[0];

        private TrustingX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return X509_CERTIFICATES;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }
    }

    private static class TrustingSocketFactory
    implements LayeredConnectionSocketFactory {
        private SSLContext sslcontext = null;

        private TrustingSocketFactory() {
        }

        private static SSLContext createSSLContext() throws IOException {
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                sSLContext.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
                return sSLContext;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage(), exception);
            }
        }

        @Override
        public Socket createLayeredSocket(Socket socket, String string, int n, HttpContext httpContext) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(socket, string, n, true);
        }

        @Override
        public Socket createSocket(HttpContext httpContext) throws IOException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }

        @Override
        public Socket connectSocket(int n, Socket socket, HttpHost httpHost, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpContext httpContext) throws IOException {
            SSLSocket sSLSocket = (SSLSocket)(socket != null ? socket : this.createSocket(httpContext));
            if (inetSocketAddress2 != null) {
                sSLSocket.bind(inetSocketAddress2);
            }
            sSLSocket.connect(inetSocketAddress, n);
            return sSLSocket;
        }

        private SSLContext getSSLContext() throws IOException {
            if (this.sslcontext == null) {
                this.sslcontext = TrustingSocketFactory.createSSLContext();
            }
            return this.sslcontext;
        }
    }
}

