/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.Request;
import com.amazonaws.metrics.MetricInputStreamEntity;
import com.amazonaws.metrics.ThroughputMetricType;
import com.amazonaws.metrics.internal.ServiceMetricTypeGuesser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.InputStreamEntity;

public class RepeatableInputStreamRequestEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private InputStreamEntity inputStreamRequestEntity;
    private InputStream content;
    private static final Log log = LogFactory.getLog(RepeatableInputStreamRequestEntity.class);
    private IOException originalException;

    public RepeatableInputStreamRequestEntity(Request<?> request) {
        String string;
        this.setChunked(false);
        long l = -1L;
        try {
            string = request.getHeaders().get("Content-Length");
            if (string != null) {
                l = Long.parseLong(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Unable to parse content length from request.  Buffering contents in memory.");
        }
        string = request.getHeaders().get("Content-Type");
        ThroughputMetricType throughputMetricType = ServiceMetricTypeGuesser.guessThroughputMetricType(request, "UploadThroughput", "UploadByteCount");
        this.content = this.getContent(request);
        this.inputStreamRequestEntity = throughputMetricType == null ? new InputStreamEntity(this.content, l) : new MetricInputStreamEntity(throughputMetricType, this.content, l);
        this.inputStreamRequestEntity.setContentType(string);
        this.setContent(this.content);
        this.setContentType(string);
        this.setContentLength(l);
    }

    private InputStream getContent(Request<?> request) {
        return request.getContent() == null ? new ByteArrayInputStream(new byte[0]) : request.getContent();
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamRequestEntity.isRepeatable();
    }

    @Override
    public void writeTo(OutputStream outputStream2) throws IOException {
        try {
            if (!this.firstAttempt && this.isRepeatable()) {
                this.content.reset();
            }
            this.firstAttempt = false;
            this.inputStreamRequestEntity.writeTo(outputStream2);
        }
        catch (IOException iOException) {
            if (this.originalException == null) {
                this.originalException = iOException;
            }
            throw this.originalException;
        }
    }
}

